/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.publicHoliday;

import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.repo.EventsPlanningLineRepository;
import com.axelor.apps.base.service.publicHoliday.PublicHolidayService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.hr.db.Employee;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.List;

public class PublicHolidayHrService
extends PublicHolidayService {
    @Inject
    public PublicHolidayHrService(WeeklyPlanningService weeklyPlanningService, EventsPlanningLineRepository eventsPlanningLineRepo) {
        super(weeklyPlanningService, eventsPlanningLineRepo);
    }

    public boolean checkPublicHolidayDay(LocalDate date, Employee employee) {
        return super.checkPublicHolidayDay(date, employee.getPublicHolidayEventsPlanning());
    }

    public int getImposedDayNumber(Employee employee, LocalDate startDate, LocalDate endDate) {
        EventsPlanning imposedDays = employee.getImposedDayEventsPlanning();
        if (imposedDays == null || imposedDays.getEventsPlanningLineList() == null || imposedDays.getEventsPlanningLineList().isEmpty()) {
            return 0;
        }
        List imposedDayList = this.eventsPlanningLineRepo.all().filter("self.eventsPlanning = ?1 AND self.date BETWEEN ?2 AND ?3", new Object[]{imposedDays, startDate, endDate}).fetch();
        return imposedDayList.size();
    }
}

