/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.timesheet;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.TimesheetHRRepository;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetService;
import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimesheetLineServiceImpl
implements TimesheetLineService {
    protected TimesheetService timesheetService;
    protected TimesheetHRRepository timesheetHRRepository;
    protected TimesheetRepository timesheetRepository;
    protected EmployeeRepository employeeRepository;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public TimesheetLineServiceImpl(TimesheetService timesheetService, TimesheetHRRepository timesheetHRRepository, TimesheetRepository timesheetRepository, EmployeeRepository employeeRepository) {
        this.timesheetService = timesheetService;
        this.timesheetHRRepository = timesheetHRRepository;
        this.timesheetRepository = timesheetRepository;
        this.employeeRepository = employeeRepository;
    }

    @Override
    public BigDecimal computeHoursDuration(Timesheet timesheet, BigDecimal duration, boolean toHours) throws AxelorException {
        BigDecimal dailyWorkHrs;
        String timePref;
        if (duration == null) {
            return null;
        }
        AppBaseService appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        log.debug("Get user duration for duration: {}, timesheet: {}", (Object)duration, (Object)(timesheet == null ? "null" : timesheet.getFullName()));
        if (timesheet != null) {
            User user = timesheet.getUser();
            timePref = timesheet.getTimeLoggingPreferenceSelect();
            if (user.getEmployee() != null) {
                Employee employee = (Employee)((Object)this.employeeRepository.find(user.getEmployee().getId()));
                log.debug("Employee: {}", (Object)employee);
                dailyWorkHrs = employee.getDailyWorkHours();
                if (timePref == null) {
                    timePref = employee.getTimeLoggingPreferenceSelect();
                }
            } else {
                dailyWorkHrs = appBaseService.getAppBase().getDailyWorkHours();
            }
        } else {
            timePref = appBaseService.getAppBase().getTimeLoggingPreferenceSelect();
            dailyWorkHrs = appBaseService.getAppBase().getDailyWorkHours();
        }
        return this.computeHoursDuration(timePref, duration, dailyWorkHrs, toHours);
    }

    @Override
    public BigDecimal computeHoursDuration(String timePref, BigDecimal duration, BigDecimal dailyWorkHrs, boolean toHours) throws AxelorException {
        log.debug("Timesheet time pref: {}, Daily Working hours: {}", (Object)timePref, (Object)dailyWorkHrs);
        if (timePref == null) {
            return duration;
        }
        duration = toHours ? this.computeDurationToHours(timePref, duration, dailyWorkHrs) : this.computeDurationFromHours(timePref, duration, dailyWorkHrs);
        log.debug("Calculated duration: {}", (Object)duration);
        return duration;
    }

    protected BigDecimal computeDurationToHours(String timePref, BigDecimal duration, BigDecimal dailyWorkHrs) throws AxelorException {
        switch (timePref) {
            case "days": {
                if (dailyWorkHrs.compareTo(BigDecimal.ZERO) == 0) {
                    throw new AxelorException(4, I18n.get((String)"Please, configure the number of daily work hours."));
                }
                return duration.multiply(dailyWorkHrs);
            }
            case "minutes": {
                return duration.divide(new BigDecimal(60), 2, RoundingMode.HALF_UP);
            }
        }
        return duration;
    }

    protected BigDecimal computeDurationFromHours(String timePref, BigDecimal duration, BigDecimal dailyWorkHrs) throws AxelorException {
        switch (timePref) {
            case "days": {
                if (dailyWorkHrs.compareTo(BigDecimal.ZERO) == 0) {
                    throw new AxelorException(4, I18n.get((String)"Please, configure the number of daily work hours."));
                }
                return duration.divide(dailyWorkHrs, 2, RoundingMode.HALF_UP);
            }
            case "minutes": {
                return duration.multiply(new BigDecimal(60));
            }
        }
        return duration;
    }

    @Override
    public TimesheetLine createTimesheetLine(Project project, Product product, User user, LocalDate date, Timesheet timesheet, BigDecimal hours, String comments) {
        TimesheetLine timesheetLine = new TimesheetLine();
        timesheetLine.setDate(date);
        timesheetLine.setComments(comments);
        timesheetLine.setProduct(product);
        timesheetLine.setProject(project);
        timesheetLine.setUser(user);
        timesheetLine.setHoursDuration(hours);
        try {
            timesheetLine.setDuration(this.computeHoursDuration(timesheet, hours, false));
        }
        catch (AxelorException e) {
            log.error(e.getLocalizedMessage());
            TraceBackService.trace((AxelorException)e);
        }
        timesheet.addTimesheetLineListItem(timesheetLine);
        return timesheetLine;
    }

    @Override
    public TimesheetLine createTimesheetLine(User user, LocalDate date, Timesheet timesheet, BigDecimal hours, String comments) {
        return this.createTimesheetLine(null, null, user, date, timesheet, hours, comments);
    }

    @Override
    public TimesheetLine updateTimesheetLine(TimesheetLine timesheetLine, Project project, Product product, User user, LocalDate date, Timesheet timesheet, BigDecimal hours, String comments) {
        timesheetLine.setDate(date);
        timesheetLine.setComments(comments);
        timesheetLine.setProduct(product);
        timesheetLine.setProject(project);
        timesheetLine.setUser(user);
        timesheetLine.setHoursDuration(hours);
        try {
            timesheetLine.setDuration(this.computeHoursDuration(timesheet, hours, false));
        }
        catch (AxelorException e) {
            log.error(e.getLocalizedMessage());
            TraceBackService.trace((AxelorException)e);
        }
        timesheet.addTimesheetLineListItem(timesheetLine);
        return timesheetLine;
    }

    @Override
    public Duration computeTotalDuration(List<TimesheetLine> timesheetLineList) {
        if (timesheetLineList == null || timesheetLineList.isEmpty()) {
            return Duration.ZERO;
        }
        long totalSecDuration = 0L;
        for (TimesheetLine timesheetLine : timesheetLineList) {
            if (timesheetLine.getTimesheet() != null && timesheetLine.getTimesheet().getStatusSelect() == 5) continue;
            totalSecDuration += timesheetLine.getHoursDuration().multiply(new BigDecimal("3600")).longValue();
        }
        return Duration.ofSeconds(totalSecDuration);
    }

    @Override
    public Map<Project, BigDecimal> getProjectTimeSpentMap(List<TimesheetLine> timesheetLineList) {
        HashMap<Project, BigDecimal> projectTimeSpentMap = new HashMap<Project, BigDecimal>();
        if (timesheetLineList != null) {
            for (TimesheetLine timesheetLine : timesheetLineList) {
                Project project = timesheetLine.getProject();
                BigDecimal hoursDuration = timesheetLine.getHoursDuration();
                if (project == null) continue;
                if (projectTimeSpentMap.containsKey((Object)project)) {
                    hoursDuration = hoursDuration.add((BigDecimal)projectTimeSpentMap.get((Object)project));
                }
                projectTimeSpentMap.put(project, hoursDuration);
            }
        }
        return projectTimeSpentMap;
    }

    @Transactional
    public TimesheetLine setTimesheet(TimesheetLine timesheetLine) {
        Timesheet timesheet = (Timesheet)((Object)this.timesheetRepository.all().filter("self.user = ?1 AND self.company = ?2 AND (self.statusSelect = 1 OR self.statusSelect = 2) AND ((?3 BETWEEN self.fromDate AND self.toDate) OR (self.toDate = null)) ORDER BY self.id ASC", new Object[]{timesheetLine.getUser(), timesheetLine.getProject().getCompany(), timesheetLine.getDate()}).fetchOne());
        if (timesheet == null) {
            Timesheet lastTimesheet = (Timesheet)((Object)this.timesheetRepository.all().filter("self.user = ?1 AND self.statusSelect != ?2 ORDER BY self.toDate DESC", new Object[]{timesheetLine.getUser(), 5}).fetchOne());
            timesheet = this.timesheetService.createTimesheet(timesheetLine.getUser(), lastTimesheet != null && lastTimesheet.getToDate() != null ? lastTimesheet.getToDate().plusDays(1L) : timesheetLine.getDate(), null);
            timesheet = this.timesheetHRRepository.save(timesheet);
        }
        timesheetLine.setTimesheet(timesheet);
        return timesheetLine;
    }
}

