/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.timesheet;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.meta.schema.actions.ActionView;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;

public interface TimesheetService {
    @Transactional(rollbackOn={Exception.class})
    public void confirm(Timesheet var1) throws AxelorException;

    public Message sendConfirmationEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public Message confirmAndSendConfirmationEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public void checkEmptyPeriod(Timesheet var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void validate(Timesheet var1) throws AxelorException;

    public Message sendValidationEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public Message validateAndSendValidationEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public void refuse(Timesheet var1) throws AxelorException;

    public Message sendRefusalEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public Message refuseAndSendRefusalEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public void cancel(Timesheet var1) throws AxelorException;

    public void draft(Timesheet var1);

    public Message sendCancellationEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public Message cancelAndSendCancellationEmail(Timesheet var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public Timesheet generateLines(Timesheet var1, LocalDate var2, LocalDate var3, BigDecimal var4, Project var5, Product var6) throws AxelorException;

    public LocalDate getFromPeriodDate();

    public Timesheet getCurrentTimesheet();

    public Timesheet getCurrentOrCreateTimesheet();

    public Timesheet createTimesheet(User var1, LocalDate var2, LocalDate var3);

    public List<InvoiceLine> createInvoiceLines(Invoice var1, List<TimesheetLine> var2, int var3) throws AxelorException;

    public List<InvoiceLine> createInvoiceLine(Invoice var1, Product var2, User var3, String var4, BigDecimal var5, int var6, PriceList var7) throws AxelorException;

    @Transactional
    public void computeTimeSpent(Timesheet var1);

    public BigDecimal computeSubTimeSpent(Project var1);

    public void computeParentTimeSpent(Project var1);

    public BigDecimal computeTimeSpent(Project var1);

    public String computeFullName(Timesheet var1);

    public List<Map<String, Object>> createDefaultLines(Timesheet var1);

    public BigDecimal computePeriodTotal(Timesheet var1);

    public String getPeriodTotalConvertTitle(Timesheet var1);

    public void createDomainAllTimesheetLine(User var1, Employee var2, ActionView.ActionViewBuilder var3);

    public void createValidateDomainTimesheetLine(User var1, Employee var2, ActionView.ActionViewBuilder var3);

    public void updateTimeLoggingPreference(Timesheet var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void generateLinesFromExpectedProjectPlanning(Timesheet var1) throws AxelorException;

    public void prefillLines(Timesheet var1) throws AxelorException;

    public void setTeamTaskTotalRealHrs(List<TimesheetLine> var1, boolean var2);

    public void removeAfterToDateTimesheetLines(Timesheet var1);
}

