/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.timesheet;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.base.db.AppTimesheet;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.DayPlanning;
import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.publicHoliday.PublicHolidayService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.hr.service.publicHoliday.PublicHolidayHrService;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetService;
import com.axelor.apps.hr.service.user.UserHrService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectPlanningTime;
import com.axelor.apps.project.db.repo.ProjectPlanningTimeRepository;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JpaSupport;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.mail.MessagingException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.apache.commons.collections4.ListUtils;

public class TimesheetServiceImpl
extends JpaSupport
implements TimesheetService {
    protected PriceListService priceListService;
    protected AppHumanResourceService appHumanResourceService;
    protected HRConfigService hrConfigService;
    protected TemplateMessageService templateMessageService;
    protected ProjectRepository projectRepo;
    protected UserRepository userRepo;
    protected UserHrService userHrService;
    protected TimesheetLineService timesheetLineService;
    protected ProjectPlanningTimeRepository projectPlanningTimeRepository;
    protected TeamTaskRepository teamTaskRepository;
    protected ProductCompanyService productCompanyService;
    protected TimesheetLineRepository timesheetlineRepo;
    protected TimesheetRepository timeSheetRepository;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static final int ENTITY_FIND_TIMEOUT = 10000;
    private static final int ENTITY_FIND_INTERVAL = 50;

    @Inject
    public TimesheetServiceImpl(PriceListService priceListService, AppHumanResourceService appHumanResourceService, HRConfigService hrConfigService, TemplateMessageService templateMessageService, ProjectRepository projectRepo, UserRepository userRepo, UserHrService userHrService, TimesheetLineService timesheetLineService, ProjectPlanningTimeRepository projectPlanningTimeRepository, TeamTaskRepository teamTaskRepository, ProductCompanyService productCompanyService, TimesheetLineRepository timesheetlineRepo, TimesheetRepository timeSheetRepository) {
        this.priceListService = priceListService;
        this.appHumanResourceService = appHumanResourceService;
        this.hrConfigService = hrConfigService;
        this.templateMessageService = templateMessageService;
        this.projectRepo = projectRepo;
        this.userRepo = userRepo;
        this.userHrService = userHrService;
        this.timesheetLineService = timesheetLineService;
        this.projectPlanningTimeRepository = projectPlanningTimeRepository;
        this.teamTaskRepository = teamTaskRepository;
        this.productCompanyService = productCompanyService;
        this.timesheetlineRepo = timesheetlineRepo;
        this.timeSheetRepository = timeSheetRepository;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void confirm(Timesheet timesheet) throws AxelorException {
        this.fillToDate(timesheet);
        this.validateDates(timesheet);
        timesheet.setStatusSelect(2);
        timesheet.setSentDate(this.appHumanResourceService.getTodayDate(timesheet.getCompany()));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message sendConfirmationEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(timesheet.getCompany());
        Template template = hrConfig.getSentTimesheetTemplate();
        if (hrConfig.getTimesheetMailNotification().booleanValue() && template != null) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)timesheet), template);
        }
        return null;
    }

    @Override
    public void checkEmptyPeriod(Timesheet timesheet) throws AxelorException {
        LeaveService leaveService = (LeaveService)Beans.get(LeaveService.class);
        PublicHolidayHrService publicHolidayHrService = (PublicHolidayHrService)((Object)Beans.get(PublicHolidayHrService.class));
        User user = timesheet.getUser();
        Employee employee = user.getEmployee();
        if (employee == null) {
            return;
        }
        if (employee.getPublicHolidayEventsPlanning() == null) {
            throw new AxelorException((Model)((Object)timesheet), 4, I18n.get((String)"Please add an employee's public holiday events planning related to user %s"), new Object[]{user.getName()});
        }
        WeeklyPlanning planning = employee.getWeeklyPlanning();
        if (planning == null) {
            throw new AxelorException((Model)((Object)timesheet), 4, I18n.get((String)"Please add an employee's planning related to user %s"), new Object[]{user.getName()});
        }
        List dayPlanningList = planning.getWeekDays();
        Map<Integer, String> correspMap = this.getCorresMap();
        List<TimesheetLine> timesheetLines = timesheet.getTimesheetLineList();
        timesheetLines.sort(Comparator.comparing(TimesheetLine::getDate));
        for (int i = 0; i < timesheetLines.size(); ++i) {
            if (i + 1 >= timesheetLines.size()) continue;
            LocalDate date1 = timesheetLines.get(i).getDate();
            LocalDate date2 = timesheetLines.get(i + 1).getDate();
            LocalDate missingDay = date1.plusDays(1L);
            while (ChronoUnit.DAYS.between(date1, date2) > 1L) {
                if (this.isWorkedDay(missingDay, correspMap, dayPlanningList) && !leaveService.isLeaveDay(user, missingDay) && !publicHolidayHrService.checkPublicHolidayDay(missingDay, employee)) {
                    throw new AxelorException(1, "Line for %s is missing.", new Object[]{missingDay});
                }
                date1 = missingDay;
                missingDay = missingDay.plusDays(1L);
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message confirmAndSendConfirmationEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        this.confirm(timesheet);
        return this.sendConfirmationEmail(timesheet);
    }

    @Override
    @Transactional
    public void validate(Timesheet timesheet) {
        timesheet.setStatusSelect(3);
        timesheet.setValidatedBy(AuthUtils.getUser());
        timesheet.setValidationDate(this.appHumanResourceService.getTodayDate(timesheet.getCompany()));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message sendValidationEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(timesheet.getCompany());
        Template template = hrConfig.getValidatedTimesheetTemplate();
        if (hrConfig.getTimesheetMailNotification().booleanValue() && template != null) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)timesheet), template);
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message validateAndSendValidationEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        this.validate(timesheet);
        return this.sendValidationEmail(timesheet);
    }

    @Override
    @Transactional
    public void refuse(Timesheet timesheet) {
        timesheet.setStatusSelect(4);
        timesheet.setRefusedBy(AuthUtils.getUser());
        timesheet.setRefusalDate(this.appHumanResourceService.getTodayDate(timesheet.getCompany()));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message sendRefusalEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(timesheet.getCompany());
        Template template = hrConfig.getRefusedTimesheetTemplate();
        if (hrConfig.getTimesheetMailNotification().booleanValue() && template != null) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)timesheet), template);
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message refuseAndSendRefusalEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        this.refuse(timesheet);
        return this.sendRefusalEmail(timesheet);
    }

    @Override
    @Transactional
    public void cancel(Timesheet timesheet) {
        timesheet.setStatusSelect(5);
    }

    @Override
    @Transactional
    public void draft(Timesheet timesheet) {
        timesheet.setStatusSelect(1);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message sendCancellationEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(timesheet.getCompany());
        Template template = hrConfig.getCanceledTimesheetTemplate();
        if (hrConfig.getTimesheetMailNotification().booleanValue() && template != null) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)timesheet), template);
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Message cancelAndSendCancellationEmail(Timesheet timesheet) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        this.cancel(timesheet);
        return this.sendCancellationEmail(timesheet);
    }

    @Override
    public Timesheet generateLines(Timesheet timesheet, LocalDate fromGenerationDate, LocalDate toGenerationDate, BigDecimal logTime, Project project, Product product) throws AxelorException {
        User user = timesheet.getUser();
        Employee employee = user.getEmployee();
        if (fromGenerationDate == null) {
            throw new AxelorException((Model)((Object)timesheet), 1, I18n.get((String)"Please add a start date for generation"));
        }
        if (toGenerationDate == null) {
            throw new AxelorException((Model)((Object)timesheet), 1, I18n.get((String)"Please add an end date for generation"));
        }
        if (product == null) {
            throw new AxelorException((Model)((Object)timesheet), 1, I18n.get((String)"Please add a product"));
        }
        if (employee == null) {
            throw new AxelorException((Model)((Object)timesheet), 4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{user.getName()});
        }
        WeeklyPlanning planning = employee.getWeeklyPlanning();
        if (planning == null) {
            throw new AxelorException((Model)((Object)timesheet), 4, I18n.get((String)"Please add an employee's planning related to user %s"), new Object[]{user.getName()});
        }
        List dayPlanningList = planning.getWeekDays();
        Map<Integer, String> correspMap = this.getCorresMap();
        LocalDate fromDate = fromGenerationDate;
        LocalDate toDate = toGenerationDate;
        if (employee.getPublicHolidayEventsPlanning() == null) {
            throw new AxelorException((Model)((Object)timesheet), 4, I18n.get((String)"Please add an employee's public holiday events planning related to user %s"), new Object[]{user.getName()});
        }
        LeaveService leaveService = (LeaveService)Beans.get(LeaveService.class);
        PublicHolidayHrService publicHolidayHrService = (PublicHolidayHrService)((Object)Beans.get(PublicHolidayHrService.class));
        while (!fromDate.isAfter(toDate)) {
            if (this.isWorkedDay(fromDate, correspMap, dayPlanningList) && !leaveService.isLeaveDay(user, fromDate) && !publicHolidayHrService.checkPublicHolidayDay(fromDate, employee)) {
                TimesheetLine timesheetLine = this.timesheetLineService.createTimesheetLine(project, product, user, fromDate, timesheet, this.timesheetLineService.computeHoursDuration(timesheet, logTime, true), "");
                timesheetLine.setDuration(logTime);
            }
            fromDate = fromDate.plusDays(1L);
        }
        return timesheet;
    }

    protected Map<Integer, String> getCorresMap() {
        HashMap<Integer, String> correspMap = new HashMap<Integer, String>();
        correspMap.put(1, "monday");
        correspMap.put(2, "tuesday");
        correspMap.put(3, "wednesday");
        correspMap.put(4, "thursday");
        correspMap.put(5, "friday");
        correspMap.put(6, "saturday");
        correspMap.put(7, "sunday");
        return correspMap;
    }

    protected boolean isWorkedDay(LocalDate date, Map<Integer, String> correspMap, List<DayPlanning> dayPlanningList) {
        DayPlanning dayPlanningCurr = new DayPlanning();
        for (DayPlanning dayPlanning : dayPlanningList) {
            if (!dayPlanning.getName().equals(correspMap.get(date.getDayOfWeek().getValue()))) continue;
            dayPlanningCurr = dayPlanning;
            break;
        }
        return dayPlanningCurr.getMorningFrom() != null || dayPlanningCurr.getMorningTo() != null || dayPlanningCurr.getAfternoonFrom() != null || dayPlanningCurr.getAfternoonTo() != null;
    }

    @Override
    public LocalDate getFromPeriodDate() {
        Timesheet timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).all().filter("self.user = ?1 ORDER BY self.toDate DESC", new Object[]{AuthUtils.getUser()}).fetchOne());
        if (timesheet != null) {
            return timesheet.getToDate();
        }
        return null;
    }

    @Override
    public Timesheet getCurrentTimesheet() {
        Timesheet timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).all().filter("self.statusSelect = ?1 AND self.user.id = ?2", new Object[]{1, Optional.ofNullable(AuthUtils.getUser()).map(User::getId).orElse(null)}).order("-id").fetchOne());
        if (timesheet != null) {
            return timesheet;
        }
        return null;
    }

    @Override
    public Timesheet getCurrentOrCreateTimesheet() {
        Timesheet timesheet = this.getCurrentTimesheet();
        if (timesheet == null) {
            timesheet = this.createTimesheet(AuthUtils.getUser(), this.appHumanResourceService.getTodayDateTime().toLocalDate(), null);
        }
        return timesheet;
    }

    @Override
    public Timesheet createTimesheet(User user, LocalDate fromDate, LocalDate toDate) {
        Timesheet timesheet = new Timesheet();
        timesheet.setUser(user);
        Company company = null;
        Employee employee = user.getEmployee();
        company = employee != null && employee.getMainEmploymentContract() != null ? employee.getMainEmploymentContract().getPayCompany() : user.getActiveCompany();
        String timeLoggingPreferenceSelect = employee == null ? null : employee.getTimeLoggingPreferenceSelect();
        timesheet.setTimeLoggingPreferenceSelect(timeLoggingPreferenceSelect);
        timesheet.setCompany(company);
        timesheet.setFromDate(fromDate);
        timesheet.setStatusSelect(1);
        timesheet.setFullName(this.computeFullName(timesheet));
        return timesheet;
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<TimesheetLine> timesheetLineList, int priority) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        int count = 0;
        SimpleDateFormat ddmmFormat = new SimpleDateFormat("dd/MM");
        HashMap<String, Object[]> timeSheetInformationsMap = new HashMap<String, Object[]>();
        boolean consolidate = this.appHumanResourceService.getAppTimesheet().getConsolidateTSLine();
        for (TimesheetLine timesheetLine : timesheetLineList) {
            Object[] tabInformations = new Object[]{timesheetLine.getProduct(), timesheetLine.getUser(), timesheetLine.getDate(), timesheetLine.getDate(), timesheetLine.getHoursDuration()};
            String key = null;
            if (consolidate) {
                key = timesheetLine.getProduct().getId() + "|" + timesheetLine.getUser().getId();
                if (timeSheetInformationsMap.containsKey(key)) {
                    tabInformations = (Object[])timeSheetInformationsMap.get(key);
                    if (timesheetLine.getDate().compareTo((LocalDate)tabInformations[2]) < 0) {
                        tabInformations[2] = timesheetLine.getDate();
                    } else if (timesheetLine.getDate().compareTo((LocalDate)tabInformations[3]) > 0) {
                        tabInformations[3] = timesheetLine.getDate();
                    }
                    tabInformations[4] = ((BigDecimal)tabInformations[4]).add(timesheetLine.getHoursDuration());
                } else {
                    timeSheetInformationsMap.put(key, tabInformations);
                }
            } else {
                key = String.valueOf(timesheetLine.getId());
                timeSheetInformationsMap.put(key, tabInformations);
            }
            timesheetLine.setInvoiced(true);
        }
        for (Object[] timesheetInformations : timeSheetInformationsMap.values()) {
            String strDate = null;
            Product product = (Product)((Object)timesheetInformations[0]);
            User user = (User)((Object)timesheetInformations[1]);
            LocalDate startDate = (LocalDate)timesheetInformations[2];
            LocalDate endDate = (LocalDate)timesheetInformations[3];
            BigDecimal hoursDuration = (BigDecimal)timesheetInformations[4];
            PriceList priceList = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(invoice.getPartner(), 1);
            strDate = consolidate ? ddmmFormat.format(startDate) + " - " + ddmmFormat.format(endDate) : ddmmFormat.format(startDate);
            invoiceLineList.addAll(this.createInvoiceLine(invoice, product, user, strDate, hoursDuration, priority * 100 + count, priceList));
            ++count;
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, Product product, User user, String date, BigDecimal hoursDuration, int priority, PriceList priceList) throws AxelorException {
        int discountMethodTypeSelect = 1;
        int discountTypeSelect = 0;
        if (product == null) {
            throw new AxelorException(4, I18n.get((String)"Please add a product"));
        }
        BigDecimal price = (BigDecimal)this.productCompanyService.get(product, "salePrice", invoice.getCompany());
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal priceDiscounted = price;
        BigDecimal qtyConverted = ((UnitConversionService)Beans.get(UnitConversionService.class)).convert(this.appHumanResourceService.getAppBase().getUnitHours(), (Unit)this.productCompanyService.get(product, "unit", invoice.getCompany()), hoursDuration, 2, product);
        if (priceList != null) {
            Map discounts;
            PriceListLine priceListLine = this.priceListService.getPriceListLine(product, qtyConverted, priceList, price);
            if (priceListLine != null) {
                discountMethodTypeSelect = priceListLine.getTypeSelect();
            }
            if ((discounts = this.priceListService.getDiscounts(priceList, priceListLine, price)) != null) {
                discountAmount = (BigDecimal)discounts.get("discountAmount");
                discountTypeSelect = (Integer)discounts.get("discountTypeSelect");
                priceDiscounted = this.priceListService.computeDiscount(price, discountTypeSelect, discountAmount);
            }
            if (this.appHumanResourceService.getAppBase().getComputeMethodDiscountSelect() == 2 && discountMethodTypeSelect == 3 || this.appHumanResourceService.getAppBase().getComputeMethodDiscountSelect() == 3) {
                discountTypeSelect = 0;
                price = priceDiscounted;
            }
        }
        String description = user.getFullName();
        String productName = (String)this.productCompanyService.get(product, "name", invoice.getCompany());
        if (date != null) {
            productName = productName + " (" + date + ")";
        }
        InvoiceLineGenerator invoiceLineGenerator = new InvoiceLineGenerator(invoice, product, productName, price, price, priceDiscounted, description, qtyConverted, (Unit)this.productCompanyService.get(product, "unit", invoice.getCompany()), null, priority, discountAmount, discountTypeSelect, price.multiply(qtyConverted), null, false){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    @Override
    @Transactional
    public void computeTimeSpent(Timesheet timesheet) {
        List<TimesheetLine> timesheetLineList = timesheet.getTimesheetLineList();
        if (timesheetLineList != null) {
            Map<Project, BigDecimal> projectTimeSpentMap = this.timesheetLineService.getProjectTimeSpentMap(timesheetLineList);
            for (Project project : projectTimeSpentMap.keySet()) {
                this.getEntityManager().flush();
                this.executor.submit(() -> {
                    Long startTime = System.currentTimeMillis();
                    boolean done = false;
                    PersistenceException persistenceException = null;
                    do {
                        try {
                            this.inTransaction(() -> {
                                Project updateProject = this.findProject(project.getId());
                                this.getEntityManager().lock((Object)updateProject, LockModeType.PESSIMISTIC_WRITE);
                                BigDecimal timeSpent = ((BigDecimal)projectTimeSpentMap.get((Object)updateProject)).add(this.computeSubTimeSpent(updateProject));
                                updateProject.setTimeSpent(timeSpent);
                                this.projectRepo.save((Model)((Object)updateProject));
                                this.computeParentTimeSpent(updateProject);
                            });
                            done = true;
                        }
                        catch (PersistenceException e) {
                            persistenceException = e;
                            this.sleep();
                        }
                    } while (!done && System.currentTimeMillis() - startTime < 10000L);
                    if (!done) {
                        throw persistenceException;
                    }
                    return true;
                });
            }
        }
        this.setTeamTaskTotalRealHrs(timesheet.getTimesheetLineList(), true);
    }

    private Project findProject(Long projectId) {
        Project project;
        long startTime = System.currentTimeMillis();
        while ((project = (Project)((Object)this.projectRepo.find(projectId))) == null && System.currentTimeMillis() - startTime < 10000L) {
            this.sleep();
        }
        if (project == null) {
            throw new EntityNotFoundException(projectId.toString());
        }
        return project;
    }

    private void sleep() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public BigDecimal computeSubTimeSpent(Project project) {
        BigDecimal sum = BigDecimal.ZERO;
        List subProjectList = this.projectRepo.all().filter("self.parentProject = ?1", new Object[]{project}).fetch();
        if (subProjectList == null || subProjectList.isEmpty()) {
            return this.computeTimeSpent(project);
        }
        for (Project projectIt : subProjectList) {
            sum = sum.add(this.computeSubTimeSpent(projectIt));
        }
        return sum;
    }

    @Override
    public void computeParentTimeSpent(Project project) {
        Project parentProject = project.getParentProject();
        if (parentProject == null) {
            return;
        }
        parentProject.setTimeSpent(project.getTimeSpent().add(this.computeTimeSpent(parentProject)));
        this.projectRepo.save((Model)((Object)parentProject));
        this.computeParentTimeSpent(parentProject);
    }

    @Override
    public BigDecimal computeTimeSpent(Project project) {
        BigDecimal sum = BigDecimal.ZERO;
        List timesheetLineList = this.timesheetlineRepo.all().filter("self.project = ?1 AND self.timesheet.statusSelect = ?2", new Object[]{project, 3}).fetch();
        for (TimesheetLine timesheetLine : timesheetLineList) {
            sum = sum.add(timesheetLine.getHoursDuration());
        }
        return sum;
    }

    @Override
    public String computeFullName(Timesheet timesheet) {
        User timesheetUser = timesheet.getUser();
        LocalDateTime createdOn = timesheet.getCreatedOn();
        if (timesheetUser != null && createdOn != null) {
            return timesheetUser.getFullName() + " " + createdOn.getDayOfMonth() + "/" + createdOn.getMonthValue() + "/" + timesheet.getCreatedOn().getYear() + " " + createdOn.getHour() + ":" + createdOn.getMinute();
        }
        if (timesheetUser != null) {
            return timesheetUser.getFullName() + " N\u00b0" + timesheet.getId();
        }
        return "N\u00b0" + timesheet.getId();
    }

    protected void validateDates(Timesheet timesheet) throws AxelorException {
        List<TimesheetLine> timesheetLineList = timesheet.getTimesheetLineList();
        LocalDate fromDate = timesheet.getFromDate();
        LocalDate toDate = timesheet.getToDate();
        if (fromDate == null) {
            throw new AxelorException((Model)((Object)timesheet), 1, I18n.get((String)"From date can't be empty"));
        }
        if (toDate == null) {
            throw new AxelorException((Model)((Object)timesheet), 1, I18n.get((String)"To date can't be empty"));
        }
        if (ObjectUtils.isEmpty(timesheetLineList)) {
            throw new AxelorException((Model)((Object)timesheet), 3, I18n.get((String)"Timesheet line list is empty, please add a timesheet line list"));
        }
        for (TimesheetLine timesheetLine : timesheetLineList) {
            LocalDate timesheetLineDate = timesheetLine.getDate();
            if (timesheetLineDate != null) continue;
            throw new AxelorException((Model)((Object)timesheetLine), 1, I18n.get((String)"The date of timesheet line %d can't be empty"), new Object[]{timesheetLineList.indexOf((Object)timesheetLine) + 1});
        }
    }

    protected void fillToDate(Timesheet timesheet) throws AxelorException {
        if (timesheet.getToDate() == null) {
            List<TimesheetLine> timesheetLineList = timesheet.getTimesheetLineList();
            if (timesheetLineList.isEmpty()) {
                throw new AxelorException(3, I18n.get((String)"Timesheet line list is empty, please add a timesheet line list"));
            }
            LocalDate timesheetLineLastDate = timesheetLineList.get(0).getDate();
            if (timesheetLineLastDate == null) {
                throw new AxelorException(1, I18n.get((String)"The date of timesheet line %d can't be empty"), new Object[]{1});
            }
            for (TimesheetLine timesheetLine : timesheetLineList.subList(1, timesheetLineList.size())) {
                LocalDate timesheetLineDate = timesheetLine.getDate();
                if (timesheetLineDate == null) {
                    throw new AxelorException((Model)((Object)timesheetLine), 1, I18n.get((String)"The date of timesheet line %d can't be empty"), new Object[]{timesheetLineList.indexOf((Object)timesheetLine) + 1});
                }
                if (!timesheetLineDate.isAfter(timesheetLineLastDate)) continue;
                timesheetLineLastDate = timesheetLineDate;
            }
            timesheet.setToDate(timesheetLineLastDate);
        }
    }

    @Override
    public List<Map<String, Object>> createDefaultLines(Timesheet timesheet) {
        ArrayList<Map<String, Object>> lines = new ArrayList<Map<String, Object>>();
        User user = timesheet.getUser();
        if (user == null || timesheet.getFromDate() == null) {
            return lines;
        }
        Product product = this.userHrService.getTimesheetProduct(user = (User)((Object)this.userRepo.find(user.getId())));
        if (product == null) {
            return lines;
        }
        List projects = this.projectRepo.all().filter("self.membersUserSet.id = ?1 and self.imputable = true and self.statusSelect != 3", new Object[]{user.getId()}).fetch();
        for (Project project : projects) {
            TimesheetLine line = this.timesheetLineService.createTimesheetLine(project, product, user, timesheet.getFromDate(), timesheet, new BigDecimal(0), null);
            lines.add(Mapper.toMap((Object)((Object)line)));
        }
        return lines;
    }

    @Override
    public BigDecimal computePeriodTotal(Timesheet timesheet) {
        BigDecimal periodTotal = BigDecimal.ZERO;
        List<TimesheetLine> timesheetLines = timesheet.getTimesheetLineList();
        if (timesheetLines != null) {
            for (TimesheetLine timesheetLine : timesheetLines) {
                BigDecimal periodTotalTemp;
                if (timesheetLine == null || (periodTotalTemp = timesheetLine.getHoursDuration()) == null) continue;
                periodTotal = periodTotal.add(periodTotalTemp);
            }
        }
        return periodTotal;
    }

    @Override
    public String getPeriodTotalConvertTitle(Timesheet timesheet) {
        String title = "";
        if (timesheet != null) {
            if (timesheet.getTimeLoggingPreferenceSelect() != null) {
                title = timesheet.getTimeLoggingPreferenceSelect();
            }
        } else {
            title = ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getTimeLoggingPreferenceSelect();
        }
        switch (title) {
            case "days": {
                return I18n.get((String)"Days");
            }
            case "minutes": {
                return I18n.get((String)"Minutes");
            }
        }
        return I18n.get((String)"Hours");
    }

    @Override
    public void createDomainAllTimesheetLine(User user, Employee employee, ActionView.ActionViewBuilder actionView) {
        actionView.domain("self.timesheet.company = :_activeCompany").context("_activeCompany", (Object)user.getActiveCompany());
        if (employee == null || !employee.getHrManager().booleanValue()) {
            if (employee == null || employee.getManagerUser() == null) {
                actionView.domain(actionView.get().getDomain() + " AND (self.timesheet.user = :_user OR self.timesheet.user.employee.managerUser = :_user)").context("_user", (Object)user);
            } else {
                actionView.domain(actionView.get().getDomain() + " AND self.timesheet.user.employee.managerUser = :_user").context("_user", (Object)user);
            }
        }
    }

    @Override
    public void createValidateDomainTimesheetLine(User user, Employee employee, ActionView.ActionViewBuilder actionView) {
        actionView.domain("self.timesheet.company = :_activeCompany AND  self.timesheet.statusSelect = 2").context("_activeCompany", (Object)user.getActiveCompany());
        if (employee == null || !employee.getHrManager().booleanValue()) {
            if (employee == null || employee.getManagerUser() == null) {
                actionView.domain(actionView.get().getDomain() + " AND (self.timesheet.user = :_user OR self.timesheet.user.employee.managerUser = :_user)").context("_user", (Object)user);
            } else {
                actionView.domain(actionView.get().getDomain() + " AND self.timesheet.user.employee.managerUser = :_user").context("_user", (Object)user);
            }
        }
    }

    @Override
    public void updateTimeLoggingPreference(Timesheet timesheet) throws AxelorException {
        String timeLoggingPref;
        if (timesheet.getUser() == null || timesheet.getUser().getEmployee() == null) {
            timeLoggingPref = "hours";
        } else {
            Employee employee = timesheet.getUser().getEmployee();
            timeLoggingPref = employee.getTimeLoggingPreferenceSelect();
        }
        timesheet.setTimeLoggingPreferenceSelect(timeLoggingPref);
        if (timesheet.getTimesheetLineList() != null) {
            for (TimesheetLine timesheetLine : timesheet.getTimesheetLineList()) {
                timesheetLine.setDuration(((TimesheetLineService)Beans.get(TimesheetLineService.class)).computeHoursDuration(timesheet, timesheetLine.getHoursDuration(), false));
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void generateLinesFromExpectedProjectPlanning(Timesheet timesheet) throws AxelorException {
        User user = timesheet.getUser();
        List<ProjectPlanningTime> planningList = this.getExpectedProjectPlanningTimeList(timesheet);
        for (ProjectPlanningTime projectPlanningTime : planningList) {
            TimesheetLine timesheetLine = new TimesheetLine();
            timesheetLine.setHoursDuration(projectPlanningTime.getPlannedHours());
            timesheetLine.setDuration(this.timesheetLineService.computeHoursDuration(timesheet, projectPlanningTime.getPlannedHours(), false));
            timesheetLine.setTimesheet(timesheet);
            timesheetLine.setUser(user);
            timesheetLine.setProduct(projectPlanningTime.getProduct());
            timesheetLine.setTeamTask(projectPlanningTime.getTask());
            timesheetLine.setProject(projectPlanningTime.getProject());
            timesheetLine.setDate(projectPlanningTime.getDate());
            timesheetLine.setProjectPlanningTime(projectPlanningTime);
            timesheet.addTimesheetLineListItem(timesheetLine);
        }
    }

    private List<ProjectPlanningTime> getExpectedProjectPlanningTimeList(Timesheet timesheet) {
        List planningList = timesheet.getToDate() == null ? this.projectPlanningTimeRepository.all().filter("self.user.id = ?1 AND self.date >= ?2 AND self.id NOT IN (SELECT timesheetLine.projectPlanningTime.id FROM TimesheetLine as timesheetLine WHERE timesheetLine.projectPlanningTime != null AND timesheetLine.timesheet = ?3) AND self.task != null ", new Object[]{timesheet.getUser().getId(), timesheet.getFromDate(), timesheet}).fetch() : this.projectPlanningTimeRepository.all().filter("self.user.id = ?1 AND self.date BETWEEN ?2 AND ?3 AND self.id NOT IN (SELECT timesheetLine.projectPlanningTime.id FROM TimesheetLine as timesheetLine WHERE timesheetLine.projectPlanningTime != null AND timesheetLine.timesheet = ?4) AND self.task != null ", new Object[]{timesheet.getUser().getId(), timesheet.getFromDate(), timesheet.getToDate(), timesheet}).fetch();
        return planningList;
    }

    @Override
    public void prefillLines(Timesheet timesheet) throws AxelorException {
        PublicHolidayService holidayService = (PublicHolidayService)Beans.get(PublicHolidayService.class);
        LeaveService leaveService = (LeaveService)Beans.get(LeaveService.class);
        WeeklyPlanningService weeklyPlanningService = (WeeklyPlanningService)Beans.get(WeeklyPlanningService.class);
        AppTimesheet appTimesheet = this.appHumanResourceService.getAppTimesheet();
        LocalDate fromDate = timesheet.getFromDate();
        LocalDate toDate = timesheet.getToDate();
        User user = timesheet.getUser();
        Employee employee = user.getEmployee();
        HRConfig config = timesheet.getCompany().getHrConfig();
        WeeklyPlanning weeklyPlanning = employee != null ? employee.getWeeklyPlanning() : config.getWeeklyPlanning();
        EventsPlanning holidayPlanning = employee != null ? employee.getPublicHolidayEventsPlanning() : config.getPublicHolidayEventsPlanning();
        LocalDate date = fromDate;
        while (!date.isAfter(toDate)) {
            BigDecimal dayValueInHours = weeklyPlanningService.getWorkingDayValueInHours(weeklyPlanning, date, LocalTime.MIN, LocalTime.MAX);
            if (appTimesheet.getCreateLinesForHolidays().booleanValue() && holidayService.checkPublicHolidayDay(date, holidayPlanning)) {
                this.timesheetLineService.createTimesheetLine(user, date, timesheet, dayValueInHours, I18n.get((String)"Holiday"));
            } else if (appTimesheet.getCreateLinesForLeaves().booleanValue()) {
                List<LeaveRequest> leaveList = leaveService.getLeaves(user, date);
                BigDecimal totalLeaveHours = BigDecimal.ZERO;
                if (ObjectUtils.notEmpty(leaveList)) {
                    for (LeaveRequest leave : leaveList) {
                        BigDecimal leaveHours = leaveService.computeDuration(leave, date, date);
                        if (leave.getLeaveLine().getLeaveReason().getUnitSelect() == 1) {
                            leaveHours = leaveHours.multiply(dayValueInHours);
                        }
                        totalLeaveHours = totalLeaveHours.add(leaveHours);
                    }
                    this.timesheetLineService.createTimesheetLine(user, date, timesheet, totalLeaveHours, I18n.get((String)"Day leave"));
                }
            }
            date = date.plusDays(1L);
        }
    }

    @Override
    @Transactional
    public void setTeamTaskTotalRealHrs(List<TimesheetLine> timesheetLines, boolean isAdd) {
        for (TimesheetLine timesheetLine : timesheetLines) {
            TeamTask teamTask = timesheetLine.getTeamTask();
            if (teamTask == null) continue;
            teamTask = (TeamTask)((Object)this.teamTaskRepository.find(teamTask.getId()));
            BigDecimal totalrealhrs = isAdd ? teamTask.getTotalRealHrs().add(timesheetLine.getHoursDuration()) : teamTask.getTotalRealHrs().subtract(timesheetLine.getHoursDuration());
            teamTask.setTotalRealHrs(totalrealhrs);
            this.teamTaskRepository.save((Model)((Object)teamTask));
        }
    }

    @Override
    @Transactional
    public void removeAfterToDateTimesheetLines(Timesheet timesheet) {
        ArrayList<TimesheetLine> removedTimesheetLines = new ArrayList<TimesheetLine>();
        for (TimesheetLine timesheetLine : ListUtils.emptyIfNull(timesheet.getTimesheetLineList())) {
            if (!timesheetLine.getDate().isAfter(timesheet.getToDate())) continue;
            removedTimesheetLines.add(timesheetLine);
            if (timesheetLine.getId() == null) continue;
            this.timesheetlineRepo.remove((Model)((Object)timesheetLine));
        }
        timesheet.getTimesheetLineList().removeAll(removedTimesheetLines);
    }
}

