/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.timesheet.timer;

import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.TSTimer;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TSTimerRepository;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetService;
import com.axelor.apps.hr.service.timesheet.timer.TimesheetTimerService;
import com.axelor.apps.tool.date.DurationTool;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimesheetTimerServiceImpl
implements TimesheetTimerService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @Transactional
    public void pause(TSTimer timer) {
        timer.setStatusSelect(2);
        this.calculateDuration(timer);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void stop(TSTimer timer) throws AxelorException {
        timer.setStatusSelect(3);
        this.calculateDuration(timer);
        if (timer.getDuration() <= 59L) {
            throw new AxelorException(5, I18n.get((String)"No timesheet line has been created because the duration is less than 1 minute"), new Object[]{timer});
        }
        this.generateTimesheetLine(timer);
    }

    @Override
    @Transactional
    public void calculateDuration(TSTimer timer) {
        long currentDuration = timer.getDuration();
        Duration duration = DurationTool.computeDuration((LocalDateTime)timer.getTimerStartDateT(), (LocalDateTime)((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
        long secondes = DurationTool.getSecondsDuration((Duration)duration) + currentDuration;
        timer.setDuration(secondes);
    }

    @Override
    @Transactional
    public TimesheetLine generateTimesheetLine(TSTimer timer) {
        BigDecimal durationHours = this.convertSecondDurationInHours(timer.getDuration());
        Timesheet timesheet = ((TimesheetService)Beans.get(TimesheetService.class)).getCurrentOrCreateTimesheet();
        LocalDate startDateTime = timer.getStartDateTime() == null ? ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDate() : timer.getStartDateTime().toLocalDate();
        TimesheetLine timesheetLine = ((TimesheetLineService)Beans.get(TimesheetLineService.class)).createTimesheetLine(timer.getProject(), timer.getProduct(), timer.getUser(), startDateTime, timesheet, durationHours, timer.getComments());
        ((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).save((Model)((Object)timesheet));
        ((TimesheetLineRepository)((Object)Beans.get(TimesheetLineRepository.class))).save((Model)((Object)timesheetLine));
        timer.setTimesheetLine(timesheetLine);
        return timesheetLine;
    }

    @Override
    public BigDecimal convertSecondDurationInHours(long durationInSeconds) {
        this.logger.debug("Duration in seconds : {}", (Object)durationInSeconds);
        BigDecimal durationHours = new BigDecimal(durationInSeconds).divide(new BigDecimal(3600), 4, RoundingMode.HALF_EVEN);
        this.logger.debug("Duration in hours : {}", (Object)durationHours);
        return durationHours;
    }

    @Override
    public TSTimer getCurrentTSTimer() {
        return (TSTimer)((Object)((TSTimerRepository)((Object)Beans.get(TSTimerRepository.class))).all().filter("self.user = ?1", new Object[]{AuthUtils.getUser()}).fetchOne());
    }
}

