/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.hr.db.EmployeeBonusMgt;
import com.axelor.apps.hr.db.repo.EmployeeBonusMgtRepository;
import com.axelor.apps.hr.service.EmployeeBonusService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class EmployeeBonusController {
    public void compute(ActionRequest request, ActionResponse response) {
        EmployeeBonusMgt employeeBonusMgt = (EmployeeBonusMgt)((Object)request.getContext().asType(EmployeeBonusMgt.class));
        PeriodService periodService = (PeriodService)Beans.get(PeriodService.class);
        try {
            employeeBonusMgt = (EmployeeBonusMgt)((Object)((EmployeeBonusMgtRepository)((Object)Beans.get(EmployeeBonusMgtRepository.class))).find(employeeBonusMgt.getId()));
            ((EmployeeBonusService)Beans.get(EmployeeBonusService.class)).compute(employeeBonusMgt);
            response.setReload(true);
            periodService.checkPeriod(employeeBonusMgt.getPayPeriod());
            periodService.checkPeriod(employeeBonusMgt.getLeavePeriod());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        EmployeeBonusMgt bonus = (EmployeeBonusMgt)((Object)((EmployeeBonusMgtRepository)((Object)Beans.get(EmployeeBonusMgtRepository.class))).find(((EmployeeBonusMgt)((Object)request.getContext().asType(EmployeeBonusMgt.class))).getId()));
        String name = I18n.get((String)"Employee bonus management") + " :  " + bonus.getEmployeeBonusType().getLabel();
        String fileLink = ReportFactory.createReport((String)"EmployeeBonusMgt.rptdesign", (String)name).addParam("EmployeeBonusMgtId", (Object)bonus.getId()).addParam("Timezone", bonus.getCompany() != null ? bonus.getCompany().getTimezone() : null).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).toAttach((Model)((Object)bonus)).generate().getFileLink();
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }
}

