/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web;

import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.PayrollLeave;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.apps.hr.db.repo.EmploymentContractRepository;
import com.axelor.apps.hr.db.repo.PayrollPreparationRepository;
import com.axelor.apps.hr.service.PayrollPreparationService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;

@Singleton
public class PayrollPreparationController {
    public void generateFromEmploymentContract(ActionRequest request, ActionResponse response) {
        PayrollPreparation payrollPreparation = (PayrollPreparation)((Object)request.getContext().asType(PayrollPreparation.class));
        EmploymentContract employmentContract = (EmploymentContract)((Object)((EmploymentContractRepository)((Object)Beans.get(EmploymentContractRepository.class))).find(new Long(request.getContext().get((Object)"_idEmploymentContract").toString())));
        response.setValues((Object)((PayrollPreparationService)Beans.get(PayrollPreparationService.class)).generateFromEmploymentContract(payrollPreparation, employmentContract));
    }

    public void fillInPayrollPreparation(ActionRequest request, ActionResponse response) throws AxelorException {
        PayrollPreparation payrollPreparation = (PayrollPreparation)((Object)request.getContext().asType(PayrollPreparation.class));
        List<PayrollLeave> payrollLeaveList = ((PayrollPreparationService)Beans.get(PayrollPreparationService.class)).fillInPayrollPreparation(payrollPreparation);
        response.setValue("extraHoursLineList", payrollPreparation.getExtraHoursLineList());
        response.setValue("$payrollLeavesList", payrollLeaveList);
        response.setValue("duration", (Object)payrollPreparation.getDuration());
        response.setValue("leaveDuration", (Object)payrollPreparation.getLeaveDuration());
        response.setValue("expenseAmount", (Object)payrollPreparation.getExpenseAmount());
        response.setValue("expenseList", payrollPreparation.getExpenseList());
        response.setValue("otherCostsEmployeeSet", payrollPreparation.getEmploymentContract().getOtherCostsEmployeeSet());
        response.setValue("annualGrossSalary", (Object)payrollPreparation.getEmploymentContract().getAnnualGrossSalary());
        response.setValue("employeeBonusMgtLineList", payrollPreparation.getEmployeeBonusMgtLineList());
        response.setValue("lunchVoucherNumber", (Object)payrollPreparation.getLunchVoucherNumber());
        response.setValue("lunchVoucherMgtLineList", payrollPreparation.getLunchVoucherMgtLineList());
        response.setValue("employeeBonusAmount", (Object)payrollPreparation.getEmployeeBonusAmount());
        response.setValue("extraHoursNumber", (Object)payrollPreparation.getExtraHoursNumber());
    }

    public void fillInPayrollPreparationLeaves(ActionRequest request, ActionResponse response) throws AxelorException {
        PayrollPreparation payrollPreparation = (PayrollPreparation)((Object)request.getContext().asType(PayrollPreparation.class));
        List<PayrollLeave> payrollLeaveList = ((PayrollPreparationService)Beans.get(PayrollPreparationService.class)).fillInLeaves(payrollPreparation);
        response.setValue("$payrollLeavesList", payrollLeaveList);
    }

    public void exportPayrollPreparation(ActionRequest request, ActionResponse response) throws IOException, AxelorException {
        PayrollPreparation payrollPreparation;
        PayrollPreparationService payrollPreparationService = (PayrollPreparationService)Beans.get(PayrollPreparationService.class);
        String file = payrollPreparationService.exportPayrollPreparation(payrollPreparation = (PayrollPreparation)((Object)((PayrollPreparationRepository)((Object)Beans.get(PayrollPreparationRepository.class))).find(((PayrollPreparation)((Object)request.getContext().asType(PayrollPreparation.class))).getId())));
        if (file != null) {
            response.setExportFile(file);
        }
        payrollPreparationService.closePayPeriodIfExported(payrollPreparation);
        response.setReload(true);
    }
}

