/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web;

import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.service.user.UserHrService;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.List;

@Singleton
public class UserHrController {
    @Transactional
    public void createEmployee(ActionRequest request, ActionResponse response) {
        User user = (User)((Object)((UserRepository)((Object)Beans.get(UserRepository.class))).find(((User)((Object)request.getContext().asType(User.class))).getId()));
        ((UserHrService)Beans.get(UserHrService.class)).createEmployee(user);
        response.setReload(true);
    }

    @Transactional
    public void createUser(ActionRequest request, ActionResponse response) {
        Object employeeId;
        Context context = request.getContext();
        User user = (User)((Object)context.asType(User.class));
        EmployeeRepository employeeRepository = (EmployeeRepository)((Object)Beans.get(EmployeeRepository.class));
        User employeeUser = new User();
        employeeUser.setActivateOn(user.getActivateOn());
        employeeUser.setExpiresOn(user.getExpiresOn());
        employeeUser.setCode(user.getCode());
        employeeUser.setGroup(user.getGroup());
        if (context.containsKey((Object)"_id") && (employeeId = context.get((Object)"_id")) != null) {
            List<EmploymentContract> contractList;
            Employee employee = (Employee)((Object)employeeRepository.find(Long.parseLong(employeeId.toString())));
            employeeUser.setEmployee((Employee)((Object)employeeRepository.find(employee.getId())));
            if (employee.getContactPartner() != null) {
                String employeeName = employee.getContactPartner().getName();
                if (employee.getContactPartner().getFirstName() != null) {
                    employeeName = employeeName + " " + employee.getContactPartner().getFirstName();
                }
                employeeUser.setName(employeeName);
                if (employee.getContactPartner().getEmailAddress() != null) {
                    employeeUser.setEmail(employee.getContactPartner().getEmailAddress().getAddress());
                }
            }
            if (employee.getMainEmploymentContract() != null) {
                employeeUser.setActiveCompany(employee.getMainEmploymentContract().getPayCompany());
            }
            if ((contractList = employee.getEmploymentContractList()) != null && !contractList.isEmpty()) {
                for (EmploymentContract employmentContract : contractList) {
                    employeeUser.addCompanySetItem(employmentContract.getPayCompany());
                }
            }
            CharSequence password = ((UserService)Beans.get(UserService.class)).generateRandomPassword();
            employeeUser.setPassword(password.toString());
            employee.setUser(employeeUser);
        }
        ((UserRepository)((Object)Beans.get(UserRepository.class))).save((Model)((Object)employeeUser));
        response.setCanClose(true);
    }
}

