/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.extra.hours;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.base.service.message.MessageServiceBaseImpl;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.ExtraHours;
import com.axelor.apps.hr.db.repo.ExtraHoursRepository;
import com.axelor.apps.hr.service.HRMenuTagService;
import com.axelor.apps.hr.service.HRMenuValidateService;
import com.axelor.apps.hr.service.extra.hours.ExtraHoursService;
import com.axelor.apps.message.db.Message;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
public class ExtraHoursController {
    public void editExtraHours(ActionRequest request, ActionResponse response) {
        List extraHoursList = ((ExtraHoursRepository)((Object)Beans.get(ExtraHoursRepository.class))).all().filter("self.user = ?1 AND self.company = ?2 AND self.statusSelect = 1", new Object[]{AuthUtils.getUser(), Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)}).fetch();
        if (extraHoursList.isEmpty()) {
            response.setView(ActionView.define((String)I18n.get((String)"Extra Hours")).model(ExtraHours.class.getName()).add("form", "extra-hours-form").map());
        } else if (extraHoursList.size() == 1) {
            response.setView(ActionView.define((String)I18n.get((String)"ExtraHours")).model(ExtraHours.class.getName()).add("form", "extra-hours-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(((ExtraHours)((Object)extraHoursList.get(0))).getId())).map());
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"ExtraHours")).model(Wizard.class.getName()).add("form", "popup-extra-hours-form").param("forceEdit", "true").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("forceEdit", "true").param("popup-save", "false").map());
        }
    }

    public void validateExtraHours(ActionRequest request, ActionResponse response) throws AxelorException {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Extra hours to Validate")).model(ExtraHours.class.getName()).add("grid", "extra-hours-validate-grid").add("form", "extra-hours-form").param("search-filters", "extra-hours-filters");
        ((HRMenuValidateService)Beans.get(HRMenuValidateService.class)).createValidateDomain(user, employee, actionView);
        response.setView(actionView.map());
    }

    public void editExtraHoursSelected(ActionRequest request, ActionResponse response) {
        Map extraHoursMap = (Map)request.getContext().get((Object)"extraHoursSelect");
        ExtraHours extraHours = (ExtraHours)((Object)((ExtraHoursRepository)((Object)Beans.get(ExtraHoursRepository.class))).find(new Long(((Integer)extraHoursMap.get("id")).intValue())));
        response.setView(ActionView.define((String)"Extra hours").model(ExtraHours.class.getName()).add("form", "extra-hours-form").param("forceEdit", "true").domain("self.id = " + extraHoursMap.get("id")).context("_showRecord", (Object)String.valueOf(extraHours.getId())).map());
    }

    public void historicExtraHours(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Historic colleague extra hours")).model(ExtraHours.class.getName()).add("grid", "extra-hours-grid").add("form", "extra-hours-form").param("search-filters", "extra-hours-filters");
        actionView.domain("self.company = :_activeCompany AND (self.statusSelect = 3 OR self.statusSelect = 4)").context("_activeCompany", (Object)user.getActiveCompany());
        if (employee == null || !employee.getHrManager().booleanValue()) {
            actionView.domain(actionView.get().getDomain() + " AND self.user.employee.managerUser = :_user").context("_user", (Object)user);
        }
        response.setView(actionView.map());
    }

    public void showSubordinateExtraHours(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Company activeCompany = user.getActiveCompany();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Extra hours to be Validated by your subordinates")).model(ExtraHours.class.getName()).add("grid", "extra-hours-grid").add("form", "extra-hours-form").param("search-filters", "extra-hours-filters");
        String domain = "self.user.employee.managerUser.employee.managerUser = :_user AND self.company = :_activeCompany AND self.statusSelect = 2";
        long nbExtraHours = Query.of(ExtraHours.class).filter(domain).bind("_user", (Object)user).bind("_activeCompany", (Object)activeCompany).count();
        if (nbExtraHours == 0L) {
            response.setNotify(I18n.get((String)"No extra hours to be validated by your subordinates"));
        } else {
            response.setView(actionView.domain(domain).context("_user", (Object)user).context("_activeCompany", (Object)activeCompany).map());
        }
    }

    @CallMethod
    public String extraHoursValidateMenuTag() {
        return ((HRMenuTagService)Beans.get(HRMenuTagService.class)).countRecordsTag(ExtraHours.class, ExtraHoursRepository.STATUS_CONFIRMED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirm(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            ExtraHours extraHours = (ExtraHours)((Object)request.getContext().asType(ExtraHours.class));
            extraHours = (ExtraHours)((Object)((ExtraHoursRepository)((Object)Beans.get(ExtraHoursRepository.class))).find(extraHours.getId()));
            ((ExtraHoursService)Beans.get(ExtraHoursService.class)).confirm(extraHours);
            Message message = ((ExtraHoursService)Beans.get(ExtraHoursService.class)).sendConfirmationEmail(extraHours);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valid(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            ExtraHours extraHours = (ExtraHours)((Object)request.getContext().asType(ExtraHours.class));
            extraHours = (ExtraHours)((Object)((ExtraHoursRepository)((Object)Beans.get(ExtraHoursRepository.class))).find(extraHours.getId()));
            ((ExtraHoursService)Beans.get(ExtraHoursService.class)).validate(extraHours);
            Message message = ((ExtraHoursService)Beans.get(ExtraHoursService.class)).sendValidationEmail(extraHours);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
            ((PeriodService)Beans.get(PeriodService.class)).checkPeriod(extraHours.getCompany(), extraHours.getValidationDate());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuse(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            ExtraHours extraHours = (ExtraHours)((Object)request.getContext().asType(ExtraHours.class));
            extraHours = (ExtraHours)((Object)((ExtraHoursRepository)((Object)Beans.get(ExtraHoursRepository.class))).find(extraHours.getId()));
            ((ExtraHoursService)Beans.get(ExtraHoursService.class)).refuse(extraHours);
            Message message = ((ExtraHoursService)Beans.get(ExtraHoursService.class)).sendRefusalEmail(extraHours);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            ExtraHours extraHours = (ExtraHours)((Object)request.getContext().asType(ExtraHours.class));
            extraHours = (ExtraHours)((Object)((ExtraHoursRepository)((Object)Beans.get(ExtraHoursRepository.class))).find(extraHours.getId()));
            ((ExtraHoursService)Beans.get(ExtraHoursService.class)).cancel(extraHours);
            Message message = ((ExtraHoursService)Beans.get(ExtraHoursService.class)).sendCancellationEmail(extraHours);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void compute(ActionRequest request, ActionResponse response) {
        try {
            ExtraHours extraHours = (ExtraHours)((Object)request.getContext().asType(ExtraHours.class));
            ((ExtraHoursService)Beans.get(ExtraHoursService.class)).compute(extraHours);
            response.setValue("totalQty", (Object)extraHours.getTotalQty());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

