/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.leave;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.base.service.message.MessageServiceBaseImpl;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.LeaveReasonRepository;
import com.axelor.apps.hr.db.repo.LeaveRequestRepository;
import com.axelor.apps.hr.service.HRMenuTagService;
import com.axelor.apps.hr.service.HRMenuValidateService;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.message.db.Message;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.Map;

@Singleton
public class LeaveController {
    public void editLeave(ActionRequest request, ActionResponse response) {
        try {
            User user = AuthUtils.getUser();
            List leaveList = ((LeaveRequestRepository)((Object)Beans.get(LeaveRequestRepository.class))).all().filter("self.user = ?1 AND self.company = ?2 AND self.statusSelect = 1", new Object[]{user, user.getActiveCompany()}).fetch();
            if (leaveList.isEmpty()) {
                response.setView(ActionView.define((String)I18n.get((String)"LeaveRequest")).model(LeaveRequest.class.getName()).add("form", "leave-request-form").map());
            } else if (leaveList.size() == 1) {
                response.setView(ActionView.define((String)I18n.get((String)"LeaveRequest")).model(LeaveRequest.class.getName()).add("form", "leave-request-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(((LeaveRequest)((Object)leaveList.get(0))).getId())).map());
            } else {
                response.setView(ActionView.define((String)I18n.get((String)"LeaveRequest")).model(Wizard.class.getName()).add("form", "popup-leave-request-form").param("forceEdit", "true").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("forceEdit", "true").param("popup-save", "false").map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void editLeaveSelected(ActionRequest request, ActionResponse response) {
        try {
            Map leaveMap = (Map)request.getContext().get((Object)"leaveSelect");
            if (leaveMap == null) {
                response.setError(I18n.get((String)"Select the leave request you want to edit"));
            } else {
                Long leaveId = Long.valueOf(leaveMap.get("id").toString());
                response.setView(ActionView.define((String)I18n.get((String)"LeaveRequest")).model(LeaveRequest.class.getName()).add("form", "leave-request-form").param("forceEdit", "true").domain("self.id = " + leaveId).context("_showRecord", (Object)leaveId).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateLeave(ActionRequest request, ActionResponse response) {
        try {
            User user = AuthUtils.getUser();
            Employee employee = user.getEmployee();
            ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Leave Requests to Validate")).model(LeaveRequest.class.getName()).add("grid", "leave-request-validate-grid").add("form", "leave-request-form").param("search-filters", "leave-request-filters");
            ((HRMenuValidateService)Beans.get(HRMenuValidateService.class)).createValidateDomain(user, employee, actionView);
            response.setView(actionView.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void historicLeave(ActionRequest request, ActionResponse response) {
        try {
            User user = AuthUtils.getUser();
            Employee employee = user.getEmployee();
            ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Colleague Leave Requests")).model(LeaveRequest.class.getName()).add("grid", "leave-request-grid").add("form", "leave-request-form").param("search-filters", "leave-request-filters");
            actionView.domain("(self.statusSelect = 3 OR self.statusSelect = 4)");
            if (employee == null || !employee.getHrManager().booleanValue()) {
                actionView.domain(actionView.get().getDomain() + " AND self.user.employee.managerUser = :_user").context("_user", (Object)user);
            }
            response.setView(actionView.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void leaveCalendar(ActionRequest request, ActionResponse response) {
        try {
            User user = AuthUtils.getUser();
            Employee employee = user.getEmployee();
            ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Leaves calendar")).model(ICalendarEvent.class.getName()).add("calendar", "calendar-event-leave-request").add("grid", "calendar-event-grid").add("form", "calendar-event-form");
            actionView.domain("self.typeSelect = 4 AND self.id IN (SELECT leaveRequest.icalendarEvent FROM LeaveRequest leaveRequest WHERE leaveRequest.statusSelect = 3");
            if (employee == null || !employee.getHrManager().booleanValue()) {
                actionView.domain(actionView.get().getDomain() + " AND leaveRequest.user.employee.managerUser = :_user").context("_user", (Object)user);
            }
            actionView.domain(actionView.get().getDomain() + ")");
            response.setView(actionView.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showSubordinateLeaves(ActionRequest request, ActionResponse response) {
        try {
            User user = AuthUtils.getUser();
            String domain = "self.user.employee.managerUser.employee.managerUser = :_user AND self.statusSelect = 2";
            long nbLeaveRequests = Query.of(LeaveRequest.class).filter(domain).bind("_user", (Object)user).count();
            if (nbLeaveRequests == 0L) {
                response.setNotify(I18n.get((String)"No Leave Request to be validated by your subordinates"));
            } else {
                ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Leaves to be Validated by your subordinates")).model(LeaveRequest.class.getName()).add("grid", "leave-request-grid").add("form", "leave-request-form").param("search-filters", "leave-request-filters");
                response.setView(actionView.domain(domain).context("_user", (Object)user).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void testDuration(ActionRequest request, ActionResponse response) {
        try {
            LeaveRequest leave = (LeaveRequest)((Object)request.getContext().asType(LeaveRequest.class));
            double duration = leave.getDuration().doubleValue();
            if (duration % 0.5 != 0.0) {
                response.setError(I18n.get((String)"Invalid duration (must be a 0.5's multiple)"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeDuration(ActionRequest request, ActionResponse response) {
        try {
            LeaveRequest leave = (LeaveRequest)((Object)request.getContext().asType(LeaveRequest.class));
            response.setValue("duration", (Object)((LeaveService)Beans.get(LeaveService.class)).computeDuration(leave));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ActionRequest request, ActionResponse response) {
        try {
            LeaveService leaveService = (LeaveService)Beans.get(LeaveService.class);
            LeaveRequest leaveRequest = (LeaveRequest)((Object)request.getContext().asType(LeaveRequest.class));
            leaveRequest = (LeaveRequest)((Object)((LeaveRequestRepository)((Object)Beans.get(LeaveRequestRepository.class))).find(leaveRequest.getId()));
            if (leaveRequest.getUser().getEmployee().getWeeklyPlanning() == null) {
                response.setAlert(String.format(I18n.get((String)"Please, add a planning for employee : %s"), leaveRequest.getUser().getEmployee().getName()));
                return;
            }
            if (leaveRequest.getLeaveLine().getQuantity().subtract(leaveRequest.getDuration()).signum() < 0) {
                if (!leaveRequest.getLeaveLine().getLeaveReason().getAllowNegativeValue().booleanValue() && !leaveService.willHaveEnoughDays(leaveRequest)) {
                    String instruction = leaveRequest.getLeaveLine().getLeaveReason().getInstruction();
                    if (instruction == null) {
                        instruction = "";
                    }
                    response.setAlert(String.format(I18n.get((String)"You are not able to take leave in advance for the reason '%s'."), leaveRequest.getLeaveLine().getLeaveReason().getLeaveReason()) + " " + instruction);
                    return;
                }
                response.setNotify(String.format(I18n.get((String)"You now have a negative amount of leave available for the reason %s"), leaveRequest.getLeaveLine().getLeaveReason().getLeaveReason()));
            }
            leaveService.confirm(leaveRequest);
            Message message = leaveService.sendConfirmationEmail(leaveRequest);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(ActionRequest request, ActionResponse response) {
        try {
            LeaveService leaveService = (LeaveService)Beans.get(LeaveService.class);
            LeaveRequest leaveRequest = (LeaveRequest)((Object)request.getContext().asType(LeaveRequest.class));
            leaveRequest = (LeaveRequest)((Object)((LeaveRequestRepository)((Object)Beans.get(LeaveRequestRepository.class))).find(leaveRequest.getId()));
            leaveService.validate(leaveRequest);
            Message message = leaveService.sendValidationEmail(leaveRequest);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
            ((PeriodService)Beans.get(PeriodService.class)).checkPeriod(leaveRequest.getCompany(), leaveRequest.getToDateT().toLocalDate(), leaveRequest.getFromDateT().toLocalDate());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuse(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            LeaveService leaveService = (LeaveService)Beans.get(LeaveService.class);
            LeaveRequest leaveRequest = (LeaveRequest)((Object)request.getContext().asType(LeaveRequest.class));
            leaveRequest = (LeaveRequest)((Object)((LeaveRequestRepository)((Object)Beans.get(LeaveRequestRepository.class))).find(leaveRequest.getId()));
            leaveService.refuse(leaveRequest);
            Message message = leaveService.sendRefusalEmail(leaveRequest);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ActionRequest request, ActionResponse response) {
        try {
            LeaveRequest leave = (LeaveRequest)((Object)request.getContext().asType(LeaveRequest.class));
            leave = (LeaveRequest)((Object)((LeaveRequestRepository)((Object)Beans.get(LeaveRequestRepository.class))).find(leave.getId()));
            LeaveService leaveService = (LeaveService)Beans.get(LeaveService.class);
            leaveService.cancel(leave);
            Message message = leaveService.sendCancellationEmail(leave);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    @Transactional
    public void leaveReasonToJustify(ActionRequest request, ActionResponse response) {
        try {
            LeaveRequest leave = (LeaveRequest)((Object)request.getContext().asType(LeaveRequest.class));
            Boolean leaveToJustify = leave.getToJustifyLeaveReason();
            LeaveLine leaveLine = null;
            if (!leaveToJustify.booleanValue()) {
                return;
            }
            Company company = leave.getCompany();
            if (leave.getUser() == null) {
                return;
            }
            if (company == null) {
                company = leave.getUser().getActiveCompany();
            }
            if (company == null) {
                return;
            }
            ((HRConfigService)Beans.get(HRConfigService.class)).getLeaveReason(company.getHrConfig());
            Employee employee = leave.getUser().getEmployee();
            LeaveReason leaveReason = (LeaveReason)((Object)((LeaveReasonRepository)((Object)Beans.get(LeaveReasonRepository.class))).find(company.getHrConfig().getToJustifyLeaveReason().getId()));
            if (employee != null) {
                employee = (Employee)((Object)((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).find(leave.getUser().getEmployee().getId()));
                leaveLine = ((LeaveService)Beans.get(LeaveService.class)).addLeaveReasonOrCreateIt(employee, leaveReason);
                response.setValue("leaveLine", (Object)leaveLine);
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @CallMethod
    public String leaveValidateMenuTag() {
        return ((HRMenuTagService)Beans.get(HRMenuTagService.class)).countRecordsTag(LeaveRequest.class, 2);
    }
}

