/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.lunch.voucher;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LunchVoucherAdvance;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherAdvanceService;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherMgtService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.EntityHelper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

@Singleton
public class LunchVoucherAdvanceController {
    public void checkOnNewAdvance(ActionRequest request, ActionResponse response) throws AxelorException {
        LunchVoucherAdvance lunchVoucherAdvance = (LunchVoucherAdvance)((Object)EntityHelper.getEntity((Object)request.getContext().asType(LunchVoucherAdvance.class)));
        if (lunchVoucherAdvance.getEmployee().getMainEmploymentContract() == null) {
            response.setError(String.format(I18n.get((String)"Please, add a contract of employment for employee : %s"), lunchVoucherAdvance.getEmployee().getName()));
            return;
        }
        Company company = lunchVoucherAdvance.getEmployee().getMainEmploymentContract().getPayCompany();
        HRConfig hrConfig = ((HRConfigService)Beans.get(HRConfigService.class)).getHRConfig(company);
        int stock = ((LunchVoucherMgtService)Beans.get(LunchVoucherMgtService.class)).checkStock(company, lunchVoucherAdvance.getNbrLunchVouchers());
        if (stock <= 0) {
            response.setAlert(String.format(I18n.get((String)"Minimum stock of lunch vouchers will be reached for the company %s. Minimum Stock allowed : %s. Available Stock : %s"), company.getName(), hrConfig.getMinStockLunchVoucher(), hrConfig.getAvailableStockLunchVoucher(), 5));
        }
    }

    public void onNewAdvance(ActionRequest request, ActionResponse response) {
        LunchVoucherAdvance lunchVoucherAdvance = (LunchVoucherAdvance)((Object)EntityHelper.getEntity((Object)request.getContext().asType(LunchVoucherAdvance.class)));
        try {
            ((LunchVoucherAdvanceService)Beans.get(LunchVoucherAdvanceService.class)).onNewAdvance(lunchVoucherAdvance);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void print(ActionRequest request, ActionResponse response) {
        LunchVoucherAdvance lunchVoucherAdvance = (LunchVoucherAdvance)((Object)request.getContext().asType(LunchVoucherAdvance.class));
        String name = lunchVoucherAdvance.getEmployee().getName() + "-" + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate((Company)Optional.ofNullable(lunchVoucherAdvance.getEmployee()).map(Employee::getUser).map(User::getActiveCompany).orElse(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null))).format(DateTimeFormatter.ISO_DATE);
        try {
            String fileLink = ReportFactory.createReport((String)"LunchVoucherAdvance.rptdesign", (String)name).addParam("lunchVoucherAdvId", (Object)lunchVoucherAdvance.getId()).addParam("Timezone", (Object)this.getTimezone(lunchVoucherAdvance)).addFormat("pdf").generate().getFileLink();
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private String getTimezone(LunchVoucherAdvance lunchVoucherAdvance) {
        if (lunchVoucherAdvance.getEmployee() == null || lunchVoucherAdvance.getEmployee().getUser() == null || lunchVoucherAdvance.getEmployee().getUser().getActiveCompany() == null) {
            return null;
        }
        return lunchVoucherAdvance.getEmployee().getUser().getActiveCompany().getTimezone();
    }
}

