/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.lunch.voucher;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.hr.db.LunchVoucherMgt;
import com.axelor.apps.hr.db.repo.LunchVoucherMgtLineRepository;
import com.axelor.apps.hr.db.repo.LunchVoucherMgtRepository;
import com.axelor.apps.hr.service.lunch.voucher.LunchVoucherMgtService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Singleton
public class LunchVoucherMgtController {
    public void calculate(ActionRequest request, ActionResponse response) {
        try {
            LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)((LunchVoucherMgtRepository)((Object)Beans.get(LunchVoucherMgtRepository.class))).find(((LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class))).getId()));
            ((LunchVoucherMgtService)Beans.get(LunchVoucherMgtService.class)).calculate(lunchVoucherMgt);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)((LunchVoucherMgtRepository)((Object)Beans.get(LunchVoucherMgtRepository.class))).find(((LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class))).getId()));
        try {
            ((LunchVoucherMgtService)Beans.get(LunchVoucherMgtService.class)).validate(lunchVoucherMgt);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            return;
        }
        try {
            ((PeriodService)Beans.get(PeriodService.class)).checkPeriod(lunchVoucherMgt.getPayPeriod());
            ((PeriodService)Beans.get(PeriodService.class)).checkPeriod(lunchVoucherMgt.getLeavePeriod());
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }

    public void updateTotal(ActionRequest request, ActionResponse response) {
        LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class));
        ((LunchVoucherMgtService)Beans.get(LunchVoucherMgtService.class)).calculateTotal(lunchVoucherMgt);
        response.setValue("totalLunchVouchers", (Object)lunchVoucherMgt.getTotalLunchVouchers());
        response.setValue("requestedLunchVouchers", (Object)lunchVoucherMgt.getRequestedLunchVouchers());
        response.setValue("givenLunchVouchers", (Object)lunchVoucherMgt.getGivenLunchVouchers());
    }

    public void export(ActionRequest request, ActionResponse response) throws IOException {
        LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)((LunchVoucherMgtRepository)((Object)Beans.get(LunchVoucherMgtRepository.class))).find(((LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class))).getId()));
        try {
            ((LunchVoucherMgtService)Beans.get(LunchVoucherMgtService.class)).export(lunchVoucherMgt);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void print(ActionRequest request, ActionResponse response) throws IOException {
        LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class));
        String name = lunchVoucherMgt.getCompany().getName() + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(lunchVoucherMgt.getCompany()).format(DateTimeFormatter.BASIC_ISO_DATE);
        try {
            String fileLink = ReportFactory.createReport((String)"LunchVoucherMgt_Monthly.rptdesign", (String)name).addParam("lunchVoucherMgtId", (Object)lunchVoucherMgt.getId()).addParam("Timezone", lunchVoucherMgt.getCompany() != null ? lunchVoucherMgt.getCompany().getTimezone() : null).addParam("Locale", (Object)((UserService)Beans.get(UserService.class)).getLanguage()).addFormat("pdf").generate().getFileLink();
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateStock(ActionRequest request, ActionResponse response) {
        try {
            LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class));
            if (lunchVoucherMgt.getId() == null) {
                return;
            }
            List oldLunchVoucherLines = ((LunchVoucherMgtLineRepository)((Object)Beans.get(LunchVoucherMgtLineRepository.class))).all().filter("self.lunchVoucherMgt.id = ?", new Object[]{lunchVoucherMgt.getId()}).fetch();
            int stockQuantityStatus = ((LunchVoucherMgtService)Beans.get(LunchVoucherMgtService.class)).updateStock(lunchVoucherMgt.getLunchVoucherMgtLineList(), oldLunchVoucherLines, lunchVoucherMgt.getCompany());
            response.setValue("stockQuantityStatus", (Object)stockQuantityStatus);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkPayPeriod(ActionRequest request, ActionResponse response) {
        LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class));
        try {
            ((PeriodService)Beans.get(PeriodService.class)).checkPeriod(lunchVoucherMgt.getPayPeriod());
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }

    public void checkLeavePeriod(ActionRequest request, ActionResponse response) {
        LunchVoucherMgt lunchVoucherMgt = (LunchVoucherMgt)((Object)request.getContext().asType(LunchVoucherMgt.class));
        try {
            ((PeriodService)Beans.get(PeriodService.class)).checkPeriod(lunchVoucherMgt.getLeavePeriod());
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }
}

