/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.timesheet;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.message.MessageServiceBaseImpl;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.HRMenuTagService;
import com.axelor.apps.hr.service.HRMenuValidateService;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetService;
import com.axelor.apps.hr.service.user.UserHrService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimesheetController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void prefillLines(ActionRequest request, ActionResponse response) {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            ((TimesheetService)Beans.get(TimesheetService.class)).prefillLines(timesheet);
            response.setValues((Object)timesheet);
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateLines(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            Context context = request.getContext();
            LocalDate fromGenerationDate = null;
            if (context.get((Object)"fromGenerationDate") != null) {
                fromGenerationDate = LocalDate.parse(context.get((Object)"fromGenerationDate").toString(), DateTimeFormatter.ISO_DATE);
            }
            LocalDate toGenerationDate = null;
            if (context.get((Object)"toGenerationDate") != null) {
                toGenerationDate = LocalDate.parse(context.get((Object)"toGenerationDate").toString(), DateTimeFormatter.ISO_DATE);
            }
            BigDecimal logTime = BigDecimal.ZERO;
            if (context.get((Object)"logTime") != null) {
                logTime = new BigDecimal(context.get((Object)"logTime").toString());
            }
            Map projectContext = (Map)context.get((Object)"project");
            Project project = null;
            if (projectContext != null) {
                project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(((Integer)projectContext.get("id")).longValue()));
            }
            Map productContext = (Map)context.get((Object)"product");
            Product product = null;
            if (productContext != null) {
                product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(((Integer)productContext.get("id")).longValue()));
            }
            if (context.get((Object)"showActivity") == null || !((Boolean)context.get((Object)"showActivity")).booleanValue()) {
                product = ((UserHrService)Beans.get(UserHrService.class)).getTimesheetProduct(timesheet.getUser());
            }
            timesheet = ((TimesheetService)Beans.get(TimesheetService.class)).generateLines(timesheet, fromGenerationDate, toGenerationDate, logTime, project, product);
            response.setValue("timesheetLineList", timesheet.getTimesheetLineList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void editTimesheet(ActionRequest request, ActionResponse response) {
        List timesheetList = ((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).all().filter("self.user = ?1 AND self.company = ?2 AND self.statusSelect = 1", new Object[]{AuthUtils.getUser(), Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)}).fetch();
        if (timesheetList.isEmpty()) {
            response.setView(ActionView.define((String)I18n.get((String)"Timesheet")).model(Timesheet.class.getName()).add("form", "timesheet-form").map());
        } else if (timesheetList.size() == 1) {
            response.setView(ActionView.define((String)I18n.get((String)"Timesheet")).model(Timesheet.class.getName()).add("form", "timesheet-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(((Timesheet)((Object)timesheetList.get(0))).getId())).map());
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Timesheet")).model(Wizard.class.getName()).add("form", "popup-timesheet-form").param("forceEdit", "true").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("forceEdit", "true").param("popup-save", "false").map());
        }
    }

    public void allTimesheet(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Timesheets")).model(Timesheet.class.getName()).add("grid", "all-timesheet-grid").add("form", "timesheet-form").param("search-filters", "timesheet-filters");
        if (employee == null || !employee.getHrManager().booleanValue()) {
            if (employee == null || employee.getManagerUser() == null) {
                actionView.domain("self.user = :_user OR self.user.employee.managerUser = :_user").context("_user", (Object)user);
            } else {
                actionView.domain("self.user.employee.managerUser = :_user").context("_user", (Object)user);
            }
        }
        response.setView(actionView.map());
    }

    public void allTimesheetLine(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"See timesheet lines")).model(TimesheetLine.class.getName()).add("grid", "timesheet-line-grid").add("form", "timesheet-line-form");
        ((TimesheetService)Beans.get(TimesheetService.class)).createDomainAllTimesheetLine(user, employee, actionView);
        response.setView(actionView.map());
    }

    public void validateTimesheet(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Timesheets to Validate")).model(Timesheet.class.getName()).add("grid", "timesheet-validate-grid").add("form", "timesheet-form").param("search-filters", "timesheet-filters").context("todayDate", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(user.getActiveCompany()));
        ((HRMenuValidateService)Beans.get(HRMenuValidateService.class)).createValidateDomain(user, employee, actionView);
        response.setView(actionView.map());
    }

    public void validateTimesheetLine(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"See timesheet lines")).model(TimesheetLine.class.getName()).add("grid", "timesheet-line-grid").add("form", "timesheet-line-form").context("todayDate", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(user.getActiveCompany()));
        ((TimesheetService)Beans.get(TimesheetService.class)).createValidateDomainTimesheetLine(user, employee, actionView);
        response.setView(actionView.map());
    }

    public void editTimesheetSelected(ActionRequest request, ActionResponse response) {
        Map timesheetMap = (Map)request.getContext().get((Object)"timesheetSelect");
        Timesheet timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find((long)((Integer)timesheetMap.get("id"))));
        response.setView(ActionView.define((String)"Timesheet").model(Timesheet.class.getName()).add("form", "timesheet-form").param("forceEdit", "true").domain("self.id = " + timesheetMap.get("id")).context("_showRecord", (Object)String.valueOf(timesheet.getId())).map());
    }

    public void historicTimesheet(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Historic colleague Timesheets")).model(Timesheet.class.getName()).add("grid", "timesheet-grid").add("form", "timesheet-form").param("search-filters", "timesheet-filters");
        actionView.domain("(self.statusSelect = 3 OR self.statusSelect = 4)");
        if (employee == null || !employee.getHrManager().booleanValue()) {
            actionView.domain(actionView.get().getDomain() + " AND self.user.employee.managerUser = :_user").context("_user", (Object)user);
        }
        response.setView(actionView.map());
    }

    public void historicTimesheetLine(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Employee employee = user.getEmployee();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"See timesheet lines")).model(TimesheetLine.class.getName()).add("grid", "timesheet-line-grid").add("form", "timesheet-line-form");
        actionView.domain("self.timesheet.company = :_activeCompany AND (self.timesheet.statusSelect = 3 OR self.timesheet.statusSelect = 4)").context("_activeCompany", (Object)user.getActiveCompany());
        if (employee == null || !employee.getHrManager().booleanValue()) {
            actionView.domain(actionView.get().getDomain() + " AND self.timesheet.user.employee.managerUser = :_user").context("_user", (Object)user);
        }
        response.setView(actionView.map());
    }

    public void showSubordinateTimesheets(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        Company activeCompany = user.getActiveCompany();
        ActionView.ActionViewBuilder actionView = ActionView.define((String)I18n.get((String)"Timesheets to be Validated by your subordinates")).model(Timesheet.class.getName()).add("grid", "timesheet-grid").add("form", "timesheet-form").param("search-filters", "timesheet-filters");
        String domain = "self.user.employee.managerUser.employee.managerUser = :_user AND self.company = :_activeCompany AND self.statusSelect = 2";
        long nbTimesheets = Query.of(Timesheet.class).filter(domain).bind("_user", (Object)user).bind("_activeCompany", (Object)activeCompany).count();
        if (nbTimesheets == 0L) {
            response.setNotify(I18n.get((String)"No timesheet to be validated by your subordinates"));
        } else {
            response.setView(actionView.domain(domain).context("_user", (Object)user).context("_activeCompany", (Object)activeCompany).map());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ActionRequest request, ActionResponse response) {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find(timesheet.getId()));
            Message message = ((TimesheetService)Beans.get(TimesheetService.class)).cancelAndSendCancellationEmail(timesheet);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void draft(ActionRequest request, ActionResponse response) {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find(timesheet.getId()));
            ((TimesheetService)Beans.get(TimesheetService.class)).draft(timesheet);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void confirm(ActionRequest request, ActionResponse response) {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find(timesheet.getId()));
            Message message = ((TimesheetService)Beans.get(TimesheetService.class)).confirmAndSendConfirmationEmail(timesheet);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            response.setError(e.getMessage());
        }
    }

    public void continueBtn(ActionRequest request, ActionResponse response) {
        response.setView(ActionView.define((String)I18n.get((String)"Timesheet")).model(Timesheet.class.getName()).add("form", "timesheet-form").add("grid", "timesheet-grid").param("search-filters", "timesheet-filters").domain("self.user = :_user").context("_user", (Object)AuthUtils.getUser()).map());
    }

    public void confirmContinue(ActionRequest request, ActionResponse response) {
        this.confirm(request, response);
        this.continueBtn(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valid(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find(timesheet.getId()));
            TimesheetService timesheetService = (TimesheetService)Beans.get(TimesheetService.class);
            timesheetService.checkEmptyPeriod(timesheet);
            this.computeTimeSpent(request, response);
            Message message = timesheetService.validateAndSendValidationEmail(timesheet);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
            ((PeriodService)Beans.get(PeriodService.class)).checkPeriod(timesheet.getCompany(), timesheet.getToDate(), timesheet.getFromDate());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuse(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find(timesheet.getId()));
            Message message = ((TimesheetService)Beans.get(TimesheetService.class)).refuseAndSendRefusalEmail(timesheet);
            if (message != null && message.getStatusSelect() == 3) {
                response.setFlash(String.format(I18n.get((String)"Email sent to %s"), ((MessageServiceBaseImpl)Beans.get(MessageServiceBaseImpl.class)).getToRecipients(message)));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void computeTimeSpent(ActionRequest request, ActionResponse response) {
        Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
        timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find(timesheet.getId()));
        if (timesheet.getTimesheetLineList() != null && !timesheet.getTimesheetLineList().isEmpty()) {
            ((TimesheetService)Beans.get(TimesheetService.class)).computeTimeSpent(timesheet);
        }
    }

    @CallMethod
    public String timesheetValidateMenuTag() {
        return ((HRMenuTagService)Beans.get(HRMenuTagService.class)).countRecordsTag(Timesheet.class, 2);
    }

    public void printTimesheet(ActionRequest request, ActionResponse response) throws AxelorException {
        Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
        String name = I18n.get((String)"Timesheet") + " " + timesheet.getFullName().replace("/", "-");
        String fileLink = ReportFactory.createReport((String)"Timesheet.rptdesign", (String)name).addParam("TimesheetId", (Object)timesheet.getId()).addParam("Timezone", timesheet.getCompany() != null ? timesheet.getCompany().getTimezone() : null).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).toAttach((Model)((Object)timesheet)).generate().getFileLink();
        this.logger.debug("Printing {}", (Object)name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void setShowActivity(ActionRequest request, ActionResponse response) {
        Company company;
        Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
        boolean showActivity = true;
        User user = timesheet.getUser();
        if (user != null && (company = user.getActiveCompany()) != null && company.getHrConfig() != null) {
            showActivity = company.getHrConfig().getUseUniqueProductForTimesheet() == false;
        }
        response.setValue("$showActivity", (Object)showActivity);
    }

    public void openTimesheetEditor(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        String url = "hr/timesheet?timesheetId=" + context.get((Object)"id") + "&showActivity=" + context.get((Object)"showActivity");
        response.setView(ActionView.define((String)I18n.get((String)"Timesheet lines")).add("html", url).param("popup", "reload").param("popup-save", "false").map());
    }

    public void timesheetPeriodTotalController(ActionRequest request, ActionResponse response) {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            TimesheetService timesheetService = (TimesheetService)Beans.get(TimesheetService.class);
            BigDecimal periodTotal = timesheetService.computePeriodTotal(timesheet);
            response.setAttr("periodTotal", "value", (Object)periodTotal);
            response.setAttr("$periodTotalConvert", "hidden", (Object)false);
            response.setAttr("$periodTotalConvert", "value", (Object)((TimesheetLineService)Beans.get(TimesheetLineService.class)).computeHoursDuration(timesheet, periodTotal, false));
            response.setAttr("$periodTotalConvert", "title", (Object)timesheetService.getPeriodTotalConvertTitle(timesheet));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateTimeLoggingPreference(ActionRequest request, ActionResponse response) {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            ((TimesheetService)Beans.get(TimesheetService.class)).updateTimeLoggingPreference(timesheet);
            response.setAttr("$periodTotalConvert", "hidden", (Object)false);
            response.setAttr("$periodTotalConvert", "value", (Object)((TimesheetLineService)Beans.get(TimesheetLineService.class)).computeHoursDuration(timesheet, timesheet.getPeriodTotal(), false));
            response.setAttr("$periodTotalConvert", "title", (Object)((TimesheetService)Beans.get(TimesheetService.class)).getPeriodTotalConvertTitle(timesheet));
            response.setValue("timeLoggingPreferenceSelect", (Object)timesheet.getTimeLoggingPreferenceSelect());
            response.setValue("timesheetLineList", timesheet.getTimesheetLineList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateLinesFromExpectedPlanning(ActionRequest request, ActionResponse response) {
        try {
            Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
            timesheet = (Timesheet)((Object)((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).find(timesheet.getId()));
            ((TimesheetService)Beans.get(TimesheetService.class)).generateLinesFromExpectedProjectPlanning(timesheet);
            response.setReload(true);
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void removeAfterToDateTimesheetLines(ActionRequest request, ActionResponse response) {
        Timesheet timesheet = (Timesheet)((Object)request.getContext().asType(Timesheet.class));
        if (timesheet.getTimesheetLineList() != null && !timesheet.getTimesheetLineList().isEmpty()) {
            ((TimesheetService)Beans.get(TimesheetService.class)).removeAfterToDateTimesheetLines(timesheet);
        }
        response.setValues((Object)timesheet);
    }
}

