/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.web.timesheet;

import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetLineServiceImpl;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class TimesheetLineController {
    private static final String HOURS_DURATION_FIELD = "hoursDuration";
    private static final String DURATION_FIELD = "duration";

    public void setStoredDuration(ActionRequest request, ActionResponse response) {
        try {
            TimesheetLine timesheetLine = (TimesheetLine)((Object)request.getContext().asType(TimesheetLine.class));
            Context parent = request.getContext().getParent();
            Timesheet timesheet = parent != null && parent.getContextClass().equals(Timesheet.class) ? (Timesheet)((Object)parent.asType(Timesheet.class)) : timesheetLine.getTimesheet();
            BigDecimal hoursDuration = ((TimesheetLineService)Beans.get(TimesheetLineService.class)).computeHoursDuration(timesheet, timesheetLine.getDuration(), true);
            response.setValue(HOURS_DURATION_FIELD, (Object)hoursDuration);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setDuration(ActionRequest request, ActionResponse response) {
        try {
            TimesheetLine timesheetLine = (TimesheetLine)((Object)request.getContext().asType(TimesheetLine.class));
            Context parent = request.getContext().getParent();
            Timesheet timesheet = parent != null && parent.getContextClass().equals(Timesheet.class) ? (Timesheet)((Object)parent.asType(Timesheet.class)) : timesheetLine.getTimesheet();
            BigDecimal duration = ((TimesheetLineService)Beans.get(TimesheetLineService.class)).computeHoursDuration(timesheet, timesheetLine.getHoursDuration(), false);
            response.setValue(DURATION_FIELD, (Object)duration);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void updateToInvoice(ActionRequest request, ActionResponse response) {
        try {
            TimesheetLine timesheetLine = (TimesheetLine)((Object)request.getContext().asType(TimesheetLine.class));
            timesheetLine = (TimesheetLine)((Object)((TimesheetLineRepository)((Object)Beans.get(TimesheetLineRepository.class))).find(timesheetLine.getId()));
            timesheetLine.setToInvoice(timesheetLine.getToInvoice() == false);
            ((TimesheetLineRepository)((Object)Beans.get(TimesheetLineRepository.class))).save((Model)((Object)timesheetLine));
            response.setValue("toInvoice", (Object)timesheetLine.getToInvoice());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setTimesheet(ActionRequest request, ActionResponse response) {
        TimesheetLine timesheetLine = (TimesheetLine)((Object)request.getContext().asType(TimesheetLine.class));
        timesheetLine = ((TimesheetLineServiceImpl)Beans.get(TimesheetLineServiceImpl.class)).setTimesheet(timesheetLine);
        response.setValues((Object)timesheetLine);
    }
}

