/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.TeamTask;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="PROJECT_PROJECT_PLANNING_TIME", indexes={@Index(columnList="user_id"), @Index(columnList="project"), @Index(columnList="task"), @Index(columnList="product"), @Index(columnList="fullName")})
public class ProjectPlanningTime
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_PLANNING_TIME_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_PLANNING_TIME_SEQ", sequenceName="PROJECT_PROJECT_PLANNING_TIME_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Date")
    @NotNull
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Planned hours")
    private BigDecimal plannedHours = BigDecimal.ZERO;
    @Widget(title="User")
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Project")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Team task")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TeamTask task;
    @Widget(title="Time %", selection="project.task.progress.select")
    private Integer timepercent = 0;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Activity")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Include in turnover forecast")
    private Boolean isIncludeInTurnoverForecast = Boolean.FALSE;
    @Widget(title="Start time")
    private LocalTime startTime;
    @Widget(title="End time")
    private LocalTime endTime;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BigDecimal getPlannedHours() {
        return this.plannedHours == null ? BigDecimal.ZERO : this.plannedHours;
    }

    public void setPlannedHours(BigDecimal plannedHours) {
        this.plannedHours = plannedHours;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public TeamTask getTask() {
        return this.task;
    }

    public void setTask(TeamTask task) {
        this.task = task;
    }

    public Integer getTimepercent() {
        return this.timepercent == null ? 0 : this.timepercent;
    }

    public void setTimepercent(Integer timepercent) {
        this.timepercent = timepercent;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Boolean getIsIncludeInTurnoverForecast() {
        return this.isIncludeInTurnoverForecast == null ? Boolean.FALSE : this.isIncludeInTurnoverForecast;
    }

    public void setIsIncludeInTurnoverForecast(Boolean isIncludeInTurnoverForecast) {
        this.isIncludeInTurnoverForecast = isIncludeInTurnoverForecast;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.user != null && this.user.getName() != null) {
            fullName = fullName + this.user.getName();
        }
        if (this.project != null && this.project.getCode() != null) {
            fullName = fullName + "-" + this.project.getCode();
        }
        String dateStr = this.date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        fullName = !fullName.isEmpty() ? fullName + "-" + dateStr : dateStr;
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectPlanningTime)) {
            return false;
        }
        ProjectPlanningTime other = (ProjectPlanningTime)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("date", (Object)this.getDate()).add("plannedHours", (Object)this.getPlannedHours()).add("timepercent", (Object)this.getTimepercent()).add("isIncludeInTurnoverForecast", (Object)this.getIsIncludeInTurnoverForecast()).add("startTime", (Object)this.getStartTime()).add("endTime", (Object)this.getEndTime()).omitNullValues().toString();
    }
}

