/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountType;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_ACCOUNT", uniqueConstraints={@UniqueConstraint(columnNames={"code", "company"})}, indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="parent_account"), @Index(columnList="account_type"), @Index(columnList="company"), @Index(columnList="label")})
@Track(fields={@TrackField(name="name"), @TrackField(name="code"), @TrackField(name="parentAccount"), @TrackField(name="accountType"), @TrackField(name="reconcileOk"), @TrackField(name="company"), @TrackField(name="useForPartnerBalance"), @TrackField(name="analyticDistributionRequiredOnInvoiceLines"), @TrackField(name="analyticDistributionRequiredOnMoveLines"), @TrackField(name="analyticDistributionAuthorized"), @TrackField(name="isTaxAuthorizedOnMoveLine"), @TrackField(name="isTaxRequiredOnMoveLine")})
public class Account
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ACCOUNT_SEQ")
    @SequenceGenerator(name="ACCOUNT_ACCOUNT_SEQ", sequenceName="ACCOUNT_ACCOUNT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Parent Account", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account parentAccount;
    @Widget(title="Account Type", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountType accountType;
    @Widget(title="Reconcilable", massUpdate=true)
    private Boolean reconcileOk = Boolean.FALSE;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Compatible Accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Account> compatibleAccountSet;
    @Widget(title="Use for partner balance", massUpdate=true)
    private Boolean useForPartnerBalance = Boolean.FALSE;
    @Widget(title="Full name", search={"code", "name", "company"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String label;
    @Widget(title="Analytic distribution required on invoice lines", massUpdate=true)
    private Boolean analyticDistributionRequiredOnInvoiceLines = Boolean.FALSE;
    @Widget(title="Analytic distribution required on move lines", massUpdate=true)
    private Boolean analyticDistributionRequiredOnMoveLines = Boolean.FALSE;
    @Widget(title="Analytic distribution authorized", massUpdate=true)
    private Boolean analyticDistributionAuthorized = Boolean.FALSE;
    @Widget(title="Tax authorized on move line", massUpdate=true)
    private Boolean isTaxAuthorizedOnMoveLine = Boolean.FALSE;
    @Widget(title="Tax required on move line", massUpdate=true)
    private Boolean isTaxRequiredOnMoveLine = Boolean.FALSE;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Account() {
    }

    public Account(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Account getParentAccount() {
        return this.parentAccount;
    }

    public void setParentAccount(Account parentAccount) {
        this.parentAccount = parentAccount;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public Boolean getReconcileOk() {
        return this.reconcileOk == null ? Boolean.FALSE : this.reconcileOk;
    }

    public void setReconcileOk(Boolean reconcileOk) {
        this.reconcileOk = reconcileOk;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Account> getCompatibleAccountSet() {
        return this.compatibleAccountSet;
    }

    public void setCompatibleAccountSet(Set<Account> compatibleAccountSet) {
        this.compatibleAccountSet = compatibleAccountSet;
    }

    public void addCompatibleAccountSetItem(Account item) {
        if (this.getCompatibleAccountSet() == null) {
            this.setCompatibleAccountSet(new HashSet<Account>());
        }
        this.getCompatibleAccountSet().add(item);
    }

    public void removeCompatibleAccountSetItem(Account item) {
        if (this.getCompatibleAccountSet() == null) {
            return;
        }
        this.getCompatibleAccountSet().remove((Object)item);
    }

    public void clearCompatibleAccountSet() {
        if (this.getCompatibleAccountSet() != null) {
            this.getCompatibleAccountSet().clear();
        }
    }

    public Boolean getUseForPartnerBalance() {
        return this.useForPartnerBalance == null ? Boolean.FALSE : this.useForPartnerBalance;
    }

    public void setUseForPartnerBalance(Boolean useForPartnerBalance) {
        this.useForPartnerBalance = useForPartnerBalance;
    }

    public String getLabel() {
        try {
            this.label = this.computeLabel();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getLabel()", (Throwable)e);
        }
        return this.label;
    }

    protected String computeLabel() {
        if (this.company != null) {
            return this.code + "_" + this.company.getCode() + " - " + this.name;
        }
        return this.code + " - " + this.name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean getAnalyticDistributionRequiredOnInvoiceLines() {
        return this.analyticDistributionRequiredOnInvoiceLines == null ? Boolean.FALSE : this.analyticDistributionRequiredOnInvoiceLines;
    }

    public void setAnalyticDistributionRequiredOnInvoiceLines(Boolean analyticDistributionRequiredOnInvoiceLines) {
        this.analyticDistributionRequiredOnInvoiceLines = analyticDistributionRequiredOnInvoiceLines;
    }

    public Boolean getAnalyticDistributionRequiredOnMoveLines() {
        return this.analyticDistributionRequiredOnMoveLines == null ? Boolean.FALSE : this.analyticDistributionRequiredOnMoveLines;
    }

    public void setAnalyticDistributionRequiredOnMoveLines(Boolean analyticDistributionRequiredOnMoveLines) {
        this.analyticDistributionRequiredOnMoveLines = analyticDistributionRequiredOnMoveLines;
    }

    public Boolean getAnalyticDistributionAuthorized() {
        return this.analyticDistributionAuthorized == null ? Boolean.FALSE : this.analyticDistributionAuthorized;
    }

    public void setAnalyticDistributionAuthorized(Boolean analyticDistributionAuthorized) {
        this.analyticDistributionAuthorized = analyticDistributionAuthorized;
    }

    public Boolean getIsTaxAuthorizedOnMoveLine() {
        return this.isTaxAuthorizedOnMoveLine == null ? Boolean.FALSE : this.isTaxAuthorizedOnMoveLine;
    }

    public void setIsTaxAuthorizedOnMoveLine(Boolean isTaxAuthorizedOnMoveLine) {
        this.isTaxAuthorizedOnMoveLine = isTaxAuthorizedOnMoveLine;
    }

    public Boolean getIsTaxRequiredOnMoveLine() {
        return this.isTaxRequiredOnMoveLine == null ? Boolean.FALSE : this.isTaxRequiredOnMoveLine;
    }

    public void setIsTaxRequiredOnMoveLine(Boolean isTaxRequiredOnMoveLine) {
        this.isTaxRequiredOnMoveLine = isTaxRequiredOnMoveLine;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(487334413, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("reconcileOk", (Object)this.getReconcileOk()).add("useForPartnerBalance", (Object)this.getUseForPartnerBalance()).add("analyticDistributionRequiredOnInvoiceLines", (Object)this.getAnalyticDistributionRequiredOnInvoiceLines()).add("analyticDistributionRequiredOnMoveLines", (Object)this.getAnalyticDistributionRequiredOnMoveLines()).add("analyticDistributionAuthorized", (Object)this.getAnalyticDistributionAuthorized()).add("isTaxAuthorizedOnMoveLine", (Object)this.getIsTaxAuthorizedOnMoveLine()).add("isTaxRequiredOnMoveLine", (Object)this.getIsTaxRequiredOnMoveLine()).omitNullValues().toString();
    }
}

