/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ACCOUNT_CLEARANCE", uniqueConstraints={@UniqueConstraint(columnNames={"name", "company"})}, indexes={@Index(columnList="name"), @Index(columnList="user_id"), @Index(columnList="company")})
public class AccountClearance
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ACCOUNT_CLEARANCE_SEQ")
    @SequenceGenerator(name="ACCOUNT_ACCOUNT_CLEARANCE_SEQ", sequenceName="ACCOUNT_ACCOUNT_CLEARANCE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reference", readonly=true)
    private String name;
    @Widget(title="Account clearance date", readonly=true)
    private ZonedDateTime dateTime;
    @Widget(title="User", readonly=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Status", readonly=true, selection="iaccount.account.clearance.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Clearance maximum amount")
    @NotNull
    private BigDecimal amountThreshold = BigDecimal.ZERO;
    @Widget(title="Overpayment before")
    @NotNull
    private LocalDate dateThreshold;
    @Widget(title="Overpayments collected")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MoveLine> moveLineSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AccountClearance() {
    }

    public AccountClearance(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(ZonedDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public BigDecimal getAmountThreshold() {
        return this.amountThreshold == null ? BigDecimal.ZERO : this.amountThreshold;
    }

    public void setAmountThreshold(BigDecimal amountThreshold) {
        this.amountThreshold = amountThreshold;
    }

    public LocalDate getDateThreshold() {
        return this.dateThreshold;
    }

    public void setDateThreshold(LocalDate dateThreshold) {
        this.dateThreshold = dateThreshold;
    }

    public Set<MoveLine> getMoveLineSet() {
        return this.moveLineSet;
    }

    public void setMoveLineSet(Set<MoveLine> moveLineSet) {
        this.moveLineSet = moveLineSet;
    }

    public void addMoveLineSetItem(MoveLine item) {
        if (this.getMoveLineSet() == null) {
            this.setMoveLineSet(new HashSet<MoveLine>());
        }
        this.getMoveLineSet().add(item);
    }

    public void removeMoveLineSetItem(MoveLine item) {
        if (this.getMoveLineSet() == null) {
            return;
        }
        this.getMoveLineSet().remove((Object)item);
    }

    public void clearMoveLineSet() {
        if (this.getMoveLineSet() != null) {
            this.getMoveLineSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountClearance)) {
            return false;
        }
        AccountClearance other = (AccountClearance)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("dateTime", (Object)this.getDateTime()).add("statusSelect", (Object)this.getStatusSelect()).add("amountThreshold", (Object)this.getAmountThreshold()).add("dateThreshold", (Object)this.getDateThreshold()).omitNullValues().toString();
    }
}

