/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AnalyticAccount;
import com.axelor.apps.account.db.AnalyticAxis;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticJournal;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE", indexes={@Index(name="idx_acc_ana_dist_line_ana_dist_template", columnList="analytic_distribution_template"), @Index(columnList="analytic_axis"), @Index(columnList="analytic_account"), @Index(columnList="analytic_journal")})
public class AnalyticDistributionLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_SEQ", sequenceName="ACCOUNT_ANALYTIC_DISTRIBUTION_LINE_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Axis")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAxis analyticAxis;
    @Widget(title="Analytic Acc.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount analyticAccount;
    @Widget(title="%")
    private BigDecimal percentage = BigDecimal.ZERO;
    @Widget(title="Analytic Journal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticJournal analyticJournal;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public AnalyticAxis getAnalyticAxis() {
        return this.analyticAxis;
    }

    public void setAnalyticAxis(AnalyticAxis analyticAxis) {
        this.analyticAxis = analyticAxis;
    }

    public AnalyticAccount getAnalyticAccount() {
        return this.analyticAccount;
    }

    public void setAnalyticAccount(AnalyticAccount analyticAccount) {
        this.analyticAccount = analyticAccount;
    }

    public BigDecimal getPercentage() {
        return this.percentage == null ? BigDecimal.ZERO : this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public AnalyticJournal getAnalyticJournal() {
        return this.analyticJournal;
    }

    public void setAnalyticJournal(AnalyticJournal analyticJournal) {
        this.analyticJournal = analyticJournal;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnalyticDistributionLine)) {
            return false;
        }
        AnalyticDistributionLine other = (AnalyticDistributionLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("percentage", (Object)this.getPercentage()).omitNullValues().toString();
    }
}

