/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ANALYTIC_DISTRIBUTION_TEMPLATE", indexes={@Index(columnList="name"), @Index(columnList="company")})
public class AnalyticDistributionTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ANALYTIC_DISTRIBUTION_TEMPLATE_SEQ")
    @SequenceGenerator(name="ACCOUNT_ANALYTIC_DISTRIBUTION_TEMPLATE_SEQ", sequenceName="ACCOUNT_ANALYTIC_DISTRIBUTION_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Analytic distribution lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="analyticDistributionTemplate", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticDistributionLine> analyticDistributionLineList;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AnalyticDistributionTemplate() {
    }

    public AnalyticDistributionTemplate(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AnalyticDistributionLine> getAnalyticDistributionLineList() {
        return this.analyticDistributionLineList;
    }

    public void setAnalyticDistributionLineList(List<AnalyticDistributionLine> analyticDistributionLineList) {
        this.analyticDistributionLineList = analyticDistributionLineList;
    }

    public void addAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.getAnalyticDistributionLineList() == null) {
            this.setAnalyticDistributionLineList(new ArrayList<AnalyticDistributionLine>());
        }
        this.getAnalyticDistributionLineList().add(item);
        item.setAnalyticDistributionTemplate(this);
    }

    public void removeAnalyticDistributionLineListItem(AnalyticDistributionLine item) {
        if (this.getAnalyticDistributionLineList() == null) {
            return;
        }
        this.getAnalyticDistributionLineList().remove((Object)item);
    }

    public void clearAnalyticDistributionLineList() {
        if (this.getAnalyticDistributionLineList() != null) {
            this.getAnalyticDistributionLineList().clear();
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnalyticDistributionTemplate)) {
            return false;
        }
        AnalyticDistributionTemplate other = (AnalyticDistributionTemplate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

