/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ASSISTANT_REPORT_INVOICE", indexes={@Index(columnList="company")})
public class AssistantReportInvoice
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ASSISTANT_REPORT_INVOICE_SEQ")
    @SequenceGenerator(name="ACCOUNT_ASSISTANT_REPORT_INVOICE_SEQ", sequenceName="ACCOUNT_ASSISTANT_REPORT_INVOICE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To")
    private LocalDate toDate;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Partners")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> partnerSet;
    @Widget(title="Products")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Product categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductCategory> productCategorySet;
    @Widget(title="Graph type", selection="assistant.report.invoice.graph.type.select")
    private Integer graphTypeSelect = 1;
    @Widget(title="Format", selection="iadministration.export.type.select")
    private String formatSelect = "pdf";
    @Widget(title="Last print date", readonly=true)
    private ZonedDateTime publicationDateTime;
    @Widget(title="Turnover type", selection="assistant.report.invoice.turnover.type.select")
    private Integer turnoverTypeSelect = 3;
    private Integer type = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Partner> getPartnerSet() {
        return this.partnerSet;
    }

    public void setPartnerSet(Set<Partner> partnerSet) {
        this.partnerSet = partnerSet;
    }

    public void addPartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            this.setPartnerSet(new HashSet<Partner>());
        }
        this.getPartnerSet().add(item);
    }

    public void removePartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            return;
        }
        this.getPartnerSet().remove((Object)item);
    }

    public void clearPartnerSet() {
        if (this.getPartnerSet() != null) {
            this.getPartnerSet().clear();
        }
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            this.setProductSet(new HashSet<Product>());
        }
        this.getProductSet().add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            return;
        }
        this.getProductSet().remove((Object)item);
    }

    public void clearProductSet() {
        if (this.getProductSet() != null) {
            this.getProductSet().clear();
        }
    }

    public Set<ProductCategory> getProductCategorySet() {
        return this.productCategorySet;
    }

    public void setProductCategorySet(Set<ProductCategory> productCategorySet) {
        this.productCategorySet = productCategorySet;
    }

    public void addProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            this.setProductCategorySet(new HashSet<ProductCategory>());
        }
        this.getProductCategorySet().add(item);
    }

    public void removeProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            return;
        }
        this.getProductCategorySet().remove(item);
    }

    public void clearProductCategorySet() {
        if (this.getProductCategorySet() != null) {
            this.getProductCategorySet().clear();
        }
    }

    public Integer getGraphTypeSelect() {
        return this.graphTypeSelect == null ? 0 : this.graphTypeSelect;
    }

    public void setGraphTypeSelect(Integer graphTypeSelect) {
        this.graphTypeSelect = graphTypeSelect;
    }

    public String getFormatSelect() {
        return this.formatSelect;
    }

    public void setFormatSelect(String formatSelect) {
        this.formatSelect = formatSelect;
    }

    public ZonedDateTime getPublicationDateTime() {
        return this.publicationDateTime;
    }

    public void setPublicationDateTime(ZonedDateTime publicationDateTime) {
        this.publicationDateTime = publicationDateTime;
    }

    public Integer getTurnoverTypeSelect() {
        return this.turnoverTypeSelect == null ? 0 : this.turnoverTypeSelect;
    }

    public void setTurnoverTypeSelect(Integer turnoverTypeSelect) {
        this.turnoverTypeSelect = turnoverTypeSelect;
    }

    public Integer getType() {
        return this.type == null ? 0 : this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssistantReportInvoice)) {
            return false;
        }
        AssistantReportInvoice other = (AssistantReportInvoice)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("graphTypeSelect", (Object)this.getGraphTypeSelect()).add("formatSelect", (Object)this.getFormatSelect()).add("publicationDateTime", (Object)this.getPublicationDateTime()).add("turnoverTypeSelect", (Object)this.getTurnoverTypeSelect()).add("type", (Object)this.getType()).omitNullValues().toString();
    }
}

