/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.DebtRecoveryHistory;
import com.axelor.apps.account.db.DebtRecoveryMethod;
import com.axelor.apps.account.db.DebtRecoveryMethodLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_DEBT_RECOVERY", indexes={@Index(columnList="accounting_situation"), @Index(columnList="debt_recovery_method"), @Index(columnList="debt_recovery_method_line"), @Index(columnList="wait_debt_recovery_method_line"), @Index(columnList="company"), @Index(columnList="currency"), @Index(columnList="name")})
public class DebtRecovery
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_DEBT_RECOVERY_SEQ")
    @SequenceGenerator(name="ACCOUNT_DEBT_RECOVERY_SEQ", sequenceName="ACCOUNT_DEBT_RECOVERY_SEQ", allocationSize=1)
    private Long id;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountingSituation accountingSituation;
    @Widget(title="Debt recovery method")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryMethod debtRecoveryMethod;
    @Widget(title="Active level")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryMethodLine debtRecoveryMethodLine;
    @Widget(title="Last debt recovery date")
    private LocalDate debtRecoveryDate;
    @Widget(title="Reference Date")
    private LocalDate referenceDate;
    @Widget(title="Debt recovery history list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="debtRecovery", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebtRecoveryHistory> debtRecoveryHistoryList;
    @Widget(title="Shift to irrecoverable")
    private Boolean setToIrrecoverableOk = Boolean.FALSE;
    @Widget(title="Address unknown")
    private Boolean unknownAddressOk = Boolean.FALSE;
    @Widget(title="Partner Balance due")
    private BigDecimal balanceDue = BigDecimal.ZERO;
    @Widget(title="Balance due recoverable")
    private BigDecimal balanceDueDebtRecovery = BigDecimal.ZERO;
    @Widget(title="Level to apply / awaiting")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryMethodLine waitDebtRecoveryMethodLine;
    @Widget(title="Invoice concerned by the debt recovery")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Invoice> invoiceDebtRecoverySet;
    @Widget(title="Schedule line concerned by the debt recovery")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<PaymentScheduleLine> paymentScheduleLineDebtRecoverySet;
    @Widget(title="Owner deceased")
    private Boolean deceasedPartnerOk = Boolean.FALSE;
    @Widget(title="Batches")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Name", search={"referenceDate", "id"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public DebtRecovery() {
    }

    public DebtRecovery(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AccountingSituation getAccountingSituation() {
        return this.accountingSituation;
    }

    public void setAccountingSituation(AccountingSituation accountingSituation) {
        this.accountingSituation = accountingSituation;
    }

    public DebtRecoveryMethod getDebtRecoveryMethod() {
        return this.debtRecoveryMethod;
    }

    public void setDebtRecoveryMethod(DebtRecoveryMethod debtRecoveryMethod) {
        this.debtRecoveryMethod = debtRecoveryMethod;
    }

    public DebtRecoveryMethodLine getDebtRecoveryMethodLine() {
        return this.debtRecoveryMethodLine;
    }

    public void setDebtRecoveryMethodLine(DebtRecoveryMethodLine debtRecoveryMethodLine) {
        this.debtRecoveryMethodLine = debtRecoveryMethodLine;
    }

    public LocalDate getDebtRecoveryDate() {
        return this.debtRecoveryDate;
    }

    public void setDebtRecoveryDate(LocalDate debtRecoveryDate) {
        this.debtRecoveryDate = debtRecoveryDate;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    public List<DebtRecoveryHistory> getDebtRecoveryHistoryList() {
        return this.debtRecoveryHistoryList;
    }

    public void setDebtRecoveryHistoryList(List<DebtRecoveryHistory> debtRecoveryHistoryList) {
        this.debtRecoveryHistoryList = debtRecoveryHistoryList;
    }

    public void addDebtRecoveryHistoryListItem(DebtRecoveryHistory item) {
        if (this.getDebtRecoveryHistoryList() == null) {
            this.setDebtRecoveryHistoryList(new ArrayList<DebtRecoveryHistory>());
        }
        this.getDebtRecoveryHistoryList().add(item);
        item.setDebtRecovery(this);
    }

    public void removeDebtRecoveryHistoryListItem(DebtRecoveryHistory item) {
        if (this.getDebtRecoveryHistoryList() == null) {
            return;
        }
        this.getDebtRecoveryHistoryList().remove((Object)item);
    }

    public void clearDebtRecoveryHistoryList() {
        if (this.getDebtRecoveryHistoryList() != null) {
            this.getDebtRecoveryHistoryList().clear();
        }
    }

    public Boolean getSetToIrrecoverableOk() {
        return this.setToIrrecoverableOk == null ? Boolean.FALSE : this.setToIrrecoverableOk;
    }

    public void setSetToIrrecoverableOk(Boolean setToIrrecoverableOk) {
        this.setToIrrecoverableOk = setToIrrecoverableOk;
    }

    public Boolean getUnknownAddressOk() {
        return this.unknownAddressOk == null ? Boolean.FALSE : this.unknownAddressOk;
    }

    public void setUnknownAddressOk(Boolean unknownAddressOk) {
        this.unknownAddressOk = unknownAddressOk;
    }

    public BigDecimal getBalanceDue() {
        return this.balanceDue == null ? BigDecimal.ZERO : this.balanceDue;
    }

    public void setBalanceDue(BigDecimal balanceDue) {
        this.balanceDue = balanceDue;
    }

    public BigDecimal getBalanceDueDebtRecovery() {
        return this.balanceDueDebtRecovery == null ? BigDecimal.ZERO : this.balanceDueDebtRecovery;
    }

    public void setBalanceDueDebtRecovery(BigDecimal balanceDueDebtRecovery) {
        this.balanceDueDebtRecovery = balanceDueDebtRecovery;
    }

    public DebtRecoveryMethodLine getWaitDebtRecoveryMethodLine() {
        return this.waitDebtRecoveryMethodLine;
    }

    public void setWaitDebtRecoveryMethodLine(DebtRecoveryMethodLine waitDebtRecoveryMethodLine) {
        this.waitDebtRecoveryMethodLine = waitDebtRecoveryMethodLine;
    }

    public Set<Invoice> getInvoiceDebtRecoverySet() {
        return this.invoiceDebtRecoverySet;
    }

    public void setInvoiceDebtRecoverySet(Set<Invoice> invoiceDebtRecoverySet) {
        this.invoiceDebtRecoverySet = invoiceDebtRecoverySet;
    }

    public void addInvoiceDebtRecoverySetItem(Invoice item) {
        if (this.getInvoiceDebtRecoverySet() == null) {
            this.setInvoiceDebtRecoverySet(new HashSet<Invoice>());
        }
        this.getInvoiceDebtRecoverySet().add(item);
    }

    public void removeInvoiceDebtRecoverySetItem(Invoice item) {
        if (this.getInvoiceDebtRecoverySet() == null) {
            return;
        }
        this.getInvoiceDebtRecoverySet().remove((Object)item);
    }

    public void clearInvoiceDebtRecoverySet() {
        if (this.getInvoiceDebtRecoverySet() != null) {
            this.getInvoiceDebtRecoverySet().clear();
        }
    }

    public Set<PaymentScheduleLine> getPaymentScheduleLineDebtRecoverySet() {
        return this.paymentScheduleLineDebtRecoverySet;
    }

    public void setPaymentScheduleLineDebtRecoverySet(Set<PaymentScheduleLine> paymentScheduleLineDebtRecoverySet) {
        this.paymentScheduleLineDebtRecoverySet = paymentScheduleLineDebtRecoverySet;
    }

    public void addPaymentScheduleLineDebtRecoverySetItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineDebtRecoverySet() == null) {
            this.setPaymentScheduleLineDebtRecoverySet(new HashSet<PaymentScheduleLine>());
        }
        this.getPaymentScheduleLineDebtRecoverySet().add(item);
    }

    public void removePaymentScheduleLineDebtRecoverySetItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineDebtRecoverySet() == null) {
            return;
        }
        this.getPaymentScheduleLineDebtRecoverySet().remove((Object)item);
    }

    public void clearPaymentScheduleLineDebtRecoverySet() {
        if (this.getPaymentScheduleLineDebtRecoverySet() != null) {
            this.getPaymentScheduleLineDebtRecoverySet().clear();
        }
    }

    public Boolean getDeceasedPartnerOk() {
        return this.deceasedPartnerOk == null ? Boolean.FALSE : this.deceasedPartnerOk;
    }

    public void setDeceasedPartnerOk(Boolean deceasedPartnerOk) {
        this.deceasedPartnerOk = deceasedPartnerOk;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.referenceDate != null) {
            name = name + this.id + " - " + this.referenceDate.toString();
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DebtRecovery)) {
            return false;
        }
        DebtRecovery other = (DebtRecovery)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("debtRecoveryDate", (Object)this.getDebtRecoveryDate()).add("referenceDate", (Object)this.getReferenceDate()).add("setToIrrecoverableOk", (Object)this.getSetToIrrecoverableOk()).add("unknownAddressOk", (Object)this.getUnknownAddressOk()).add("balanceDue", (Object)this.getBalanceDue()).add("balanceDueDebtRecovery", (Object)this.getBalanceDueDebtRecovery()).add("deceasedPartnerOk", (Object)this.getDeceasedPartnerOk()).omitNullValues().toString();
    }
}

