/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_DEPOSIT_SLIP", indexes={@Index(columnList="company"), @Index(columnList="currency"), @Index(columnList="company_bank_details"), @Index(columnList="depositNumber")})
public class DepositSlip
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_DEPOSIT_SLIP_SEQ")
    @SequenceGenerator(name="ACCOUNT_DEPOSIT_SLIP_SEQ", sequenceName="ACCOUNT_DEPOSIT_SLIP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Payment mode type", selection="iaccount.payment.mode.type.select")
    @NotNull
    private Integer paymentModeTypeSelect = 0;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Bank account")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Widget(title="Start date")
    private LocalDate fromDate;
    @Widget(title="End date")
    private LocalDate toDate;
    @Widget(copyable=false)
    @NotNull
    private LocalDate depositDate;
    @Widget(readonly=true, copyable=false)
    @NameColumn
    private String depositNumber;
    @Widget(readonly=true, copyable=false)
    private LocalDate publicationDate;
    @Widget(title="Payment vouchers", copyable=false)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="depositSlip", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<PaymentVoucher> paymentVoucherList;
    @Widget(readonly=true, copyable=false)
    @Digits(integer=18, fraction=2)
    private BigDecimal totalAmount = BigDecimal.ZERO;
    @Widget(title="Number of cheques", readonly=true, copyable=false)
    private Integer chequeCount = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPaymentModeTypeSelect() {
        return this.paymentModeTypeSelect == null ? 0 : this.paymentModeTypeSelect;
    }

    public void setPaymentModeTypeSelect(Integer paymentModeTypeSelect) {
        this.paymentModeTypeSelect = paymentModeTypeSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public LocalDate getDepositDate() {
        return this.depositDate;
    }

    public void setDepositDate(LocalDate depositDate) {
        this.depositDate = depositDate;
    }

    public String getDepositNumber() {
        return this.depositNumber;
    }

    public void setDepositNumber(String depositNumber) {
        this.depositNumber = depositNumber;
    }

    public LocalDate getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(LocalDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    public List<PaymentVoucher> getPaymentVoucherList() {
        return this.paymentVoucherList;
    }

    public void setPaymentVoucherList(List<PaymentVoucher> paymentVoucherList) {
        this.paymentVoucherList = paymentVoucherList;
    }

    public void addPaymentVoucherListItem(PaymentVoucher item) {
        if (this.getPaymentVoucherList() == null) {
            this.setPaymentVoucherList(new ArrayList<PaymentVoucher>());
        }
        this.getPaymentVoucherList().add(item);
        item.setDepositSlip(this);
    }

    public void removePaymentVoucherListItem(PaymentVoucher item) {
        if (this.getPaymentVoucherList() == null) {
            return;
        }
        this.getPaymentVoucherList().remove((Object)item);
        item.setDepositSlip(null);
    }

    public void clearPaymentVoucherList() {
        if (this.getPaymentVoucherList() != null) {
            for (PaymentVoucher item : this.getPaymentVoucherList()) {
                item.setDepositSlip(null);
            }
            this.getPaymentVoucherList().clear();
        }
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount == null ? BigDecimal.ZERO : this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getChequeCount() {
        return this.chequeCount == null ? 0 : this.chequeCount;
    }

    public void setChequeCount(Integer chequeCount) {
        this.chequeCount = chequeCount;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DepositSlip)) {
            return false;
        }
        DepositSlip other = (DepositSlip)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("paymentModeTypeSelect", (Object)this.getPaymentModeTypeSelect()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("depositDate", (Object)this.getDepositDate()).add("depositNumber", (Object)this.getDepositNumber()).add("publicationDate", (Object)this.getPublicationDate()).add("totalAmount", (Object)this.getTotalAmount()).add("chequeCount", (Object)this.getChequeCount()).omitNullValues().toString();
    }
}

