/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.db.FixedAssetLine;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_FIXED_ASSET", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="journal"), @Index(columnList="partner"), @Index(columnList="invoice_line"), @Index(columnList="purchase_account"), @Index(columnList="fixed_asset_category"), @Index(columnList="disposal_move"), @Index(columnList="analytic_distribution_template")})
public class FixedAsset
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_FIXED_ASSET_SEQ")
    @SequenceGenerator(name="ACCOUNT_FIXED_ASSET_SEQ", sequenceName="ACCOUNT_FIXED_ASSET_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reference", readonly=true)
    private String reference;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Status", selection="account.fixed.asset.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Journal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Supplier")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Invoice line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoiceLine invoiceLine;
    @Widget(title="Purchase account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account purchaseAccount;
    @Widget(title="Fixed asset category")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FixedAssetCategory fixedAssetCategory;
    @Widget(title="Computation method", selection="account.fixed.type.category.computation.method.select")
    private String computationMethodSelect;
    @Widget(title="Degressive coef")
    private BigDecimal degressiveCoef = BigDecimal.ZERO;
    @Widget(title="Periodicity in month")
    private Integer periodicityInMonth = 12;
    @Widget(title="Number of depreciation")
    private Integer numberOfDepreciation = 1;
    @Widget(title="Duration in month")
    private Integer durationInMonth = 0;
    @Widget(title="Date of acquisition")
    private LocalDate acquisitionDate;
    @Widget(title="First depreciation date")
    private LocalDate firstDepreciationDate;
    @Widget(title="Gross value")
    private BigDecimal grossValue = BigDecimal.ZERO;
    @Widget(title="Residual value")
    private BigDecimal residualValue = BigDecimal.ZERO;
    @Widget(title="Disposal date")
    private LocalDate disposalDate;
    @Widget(title="Disposal value")
    private BigDecimal disposalValue = BigDecimal.ZERO;
    @Widget(title="Depreciation board")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fixedAsset", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FixedAssetLine> fixedAssetLineList;
    @Widget(title="Disposal move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move disposalMove;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public FixedAsset() {
    }

    public FixedAsset(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public InvoiceLine getInvoiceLine() {
        return this.invoiceLine;
    }

    public void setInvoiceLine(InvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public Account getPurchaseAccount() {
        return this.purchaseAccount;
    }

    public void setPurchaseAccount(Account purchaseAccount) {
        this.purchaseAccount = purchaseAccount;
    }

    public FixedAssetCategory getFixedAssetCategory() {
        return this.fixedAssetCategory;
    }

    public void setFixedAssetCategory(FixedAssetCategory fixedAssetCategory) {
        this.fixedAssetCategory = fixedAssetCategory;
    }

    public String getComputationMethodSelect() {
        return this.computationMethodSelect;
    }

    public void setComputationMethodSelect(String computationMethodSelect) {
        this.computationMethodSelect = computationMethodSelect;
    }

    public BigDecimal getDegressiveCoef() {
        return this.degressiveCoef == null ? BigDecimal.ZERO : this.degressiveCoef;
    }

    public void setDegressiveCoef(BigDecimal degressiveCoef) {
        this.degressiveCoef = degressiveCoef;
    }

    public Integer getPeriodicityInMonth() {
        return this.periodicityInMonth == null ? 0 : this.periodicityInMonth;
    }

    public void setPeriodicityInMonth(Integer periodicityInMonth) {
        this.periodicityInMonth = periodicityInMonth;
    }

    public Integer getNumberOfDepreciation() {
        return this.numberOfDepreciation == null ? 0 : this.numberOfDepreciation;
    }

    public void setNumberOfDepreciation(Integer numberOfDepreciation) {
        this.numberOfDepreciation = numberOfDepreciation;
    }

    public Integer getDurationInMonth() {
        return this.durationInMonth == null ? 0 : this.durationInMonth;
    }

    public void setDurationInMonth(Integer durationInMonth) {
        this.durationInMonth = durationInMonth;
    }

    public LocalDate getAcquisitionDate() {
        return this.acquisitionDate;
    }

    public void setAcquisitionDate(LocalDate acquisitionDate) {
        this.acquisitionDate = acquisitionDate;
    }

    public LocalDate getFirstDepreciationDate() {
        return this.firstDepreciationDate;
    }

    public void setFirstDepreciationDate(LocalDate firstDepreciationDate) {
        this.firstDepreciationDate = firstDepreciationDate;
    }

    public BigDecimal getGrossValue() {
        return this.grossValue == null ? BigDecimal.ZERO : this.grossValue;
    }

    public void setGrossValue(BigDecimal grossValue) {
        this.grossValue = grossValue;
    }

    public BigDecimal getResidualValue() {
        return this.residualValue == null ? BigDecimal.ZERO : this.residualValue;
    }

    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }

    public LocalDate getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(LocalDate disposalDate) {
        this.disposalDate = disposalDate;
    }

    public BigDecimal getDisposalValue() {
        return this.disposalValue == null ? BigDecimal.ZERO : this.disposalValue;
    }

    public void setDisposalValue(BigDecimal disposalValue) {
        this.disposalValue = disposalValue;
    }

    public List<FixedAssetLine> getFixedAssetLineList() {
        return this.fixedAssetLineList;
    }

    public void setFixedAssetLineList(List<FixedAssetLine> fixedAssetLineList) {
        this.fixedAssetLineList = fixedAssetLineList;
    }

    public void addFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getFixedAssetLineList() == null) {
            this.setFixedAssetLineList(new ArrayList<FixedAssetLine>());
        }
        this.getFixedAssetLineList().add(item);
        item.setFixedAsset(this);
    }

    public void removeFixedAssetLineListItem(FixedAssetLine item) {
        if (this.getFixedAssetLineList() == null) {
            return;
        }
        this.getFixedAssetLineList().remove((Object)item);
    }

    public void clearFixedAssetLineList() {
        if (this.getFixedAssetLineList() != null) {
            this.getFixedAssetLineList().clear();
        }
    }

    public Move getDisposalMove() {
        return this.disposalMove;
    }

    public void setDisposalMove(Move disposalMove) {
        this.disposalMove = disposalMove;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedAsset)) {
            return false;
        }
        FixedAsset other = (FixedAsset)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("reference", (Object)this.getReference()).add("name", (Object)this.getName()).add("statusSelect", (Object)this.getStatusSelect()).add("computationMethodSelect", (Object)this.getComputationMethodSelect()).add("degressiveCoef", (Object)this.getDegressiveCoef()).add("periodicityInMonth", (Object)this.getPeriodicityInMonth()).add("numberOfDepreciation", (Object)this.getNumberOfDepreciation()).add("durationInMonth", (Object)this.getDurationInMonth()).add("acquisitionDate", (Object)this.getAcquisitionDate()).add("firstDepreciationDate", (Object)this.getFirstDepreciationDate()).add("grossValue", (Object)this.getGrossValue()).omitNullValues().toString();
    }
}

