/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.FixedAsset;
import com.axelor.apps.account.db.Move;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_FIXED_ASSET_LINE", indexes={@Index(columnList="fixed_asset"), @Index(columnList="depreciation_account_move")})
public class FixedAssetLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_FIXED_ASSET_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_FIXED_ASSET_LINE_SEQ", sequenceName="ACCOUNT_FIXED_ASSET_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Fixed asset")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FixedAsset fixedAsset;
    @Widget(title="Depreciation date")
    private LocalDate depreciationDate;
    @Widget(title="Depreciation")
    private BigDecimal depreciation = BigDecimal.ZERO;
    @Widget(title="Cumulative depreciation")
    private BigDecimal cumulativeDepreciation = BigDecimal.ZERO;
    @Widget(title="Residual value")
    private BigDecimal residualValue = BigDecimal.ZERO;
    @Widget(title="Status", selection="account.fixed.asset.line.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Depreciation account move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move depreciationAccountMove;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FixedAsset getFixedAsset() {
        return this.fixedAsset;
    }

    public void setFixedAsset(FixedAsset fixedAsset) {
        this.fixedAsset = fixedAsset;
    }

    public LocalDate getDepreciationDate() {
        return this.depreciationDate;
    }

    public void setDepreciationDate(LocalDate depreciationDate) {
        this.depreciationDate = depreciationDate;
    }

    public BigDecimal getDepreciation() {
        return this.depreciation == null ? BigDecimal.ZERO : this.depreciation;
    }

    public void setDepreciation(BigDecimal depreciation) {
        this.depreciation = depreciation;
    }

    public BigDecimal getCumulativeDepreciation() {
        return this.cumulativeDepreciation == null ? BigDecimal.ZERO : this.cumulativeDepreciation;
    }

    public void setCumulativeDepreciation(BigDecimal cumulativeDepreciation) {
        this.cumulativeDepreciation = cumulativeDepreciation;
    }

    public BigDecimal getResidualValue() {
        return this.residualValue == null ? BigDecimal.ZERO : this.residualValue;
    }

    public void setResidualValue(BigDecimal residualValue) {
        this.residualValue = residualValue;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Move getDepreciationAccountMove() {
        return this.depreciationAccountMove;
    }

    public void setDepreciationAccountMove(Move depreciationAccountMove) {
        this.depreciationAccountMove = depreciationAccountMove;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedAssetLine)) {
            return false;
        }
        FixedAssetLine other = (FixedAssetLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("depreciationDate", (Object)this.getDepreciationDate()).add("depreciation", (Object)this.getDepreciation()).add("cumulativeDepreciation", (Object)this.getCumulativeDepreciation()).add("residualValue", (Object)this.getResidualValue()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

