/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_INTERBANK_CODE", indexes={@Index(columnList="name")})
public class InterbankCode
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INTERBANK_CODE_SEQ")
    @SequenceGenerator(name="ACCOUNT_INTERBANK_CODE_SEQ", sequenceName="ACCOUNT_INTERBANK_CODE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Expiration date (only for reference)")
    private LocalDate endDate;
    @Widget(title="Description", multiline=true)
    private String description;
    @Widget(title="Type", selection="account.interbankcode.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Rejects/Return Reason Code List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="interbankCode", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InterbankCodeLine> interbankCodeLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public InterbankCode() {
    }

    public InterbankCode(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public List<InterbankCodeLine> getInterbankCodeLineList() {
        return this.interbankCodeLineList;
    }

    public void setInterbankCodeLineList(List<InterbankCodeLine> interbankCodeLineList) {
        this.interbankCodeLineList = interbankCodeLineList;
    }

    public void addInterbankCodeLineListItem(InterbankCodeLine item) {
        if (this.getInterbankCodeLineList() == null) {
            this.setInterbankCodeLineList(new ArrayList<InterbankCodeLine>());
        }
        this.getInterbankCodeLineList().add(item);
        item.setInterbankCode(this);
    }

    public void removeInterbankCodeLineListItem(InterbankCodeLine item) {
        if (this.getInterbankCodeLineList() == null) {
            return;
        }
        this.getInterbankCodeLineList().remove((Object)item);
    }

    public void clearInterbankCodeLineList() {
        if (this.getInterbankCodeLineList() != null) {
            this.getInterbankCodeLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InterbankCode)) {
            return false;
        }
        InterbankCode other = (InterbankCode)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-1041325307, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("endDate", (Object)this.getEndDate()).add("description", (Object)this.getDescription()).add("typeSelect", (Object)this.getTypeSelect()).omitNullValues().toString();
    }
}

