/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_INVOICE_BATCH", indexes={@Index(columnList="company")})
public class InvoiceBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INVOICE_BATCH_SEQ")
    @SequenceGenerator(name="ACCOUNT_INVOICE_BATCH_SEQ", sequenceName="ACCOUNT_INVOICE_BATCH_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Action", selection="iinvoice.batch.action.select")
    @NotNull
    private Integer actionSelect = 0;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Invoice initial status", selection="iaccount.invoice.status.select")
    private Integer fromStatusSelect = 1;
    @Widget(title="Invoice final status", selection="iaccount.invoice.status.select")
    private Integer toStatusSelect = 2;
    @Widget(title="Select invoices manually")
    private Boolean onSelectOk = Boolean.FALSE;
    @Widget(title="Invoices selection")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Invoice> invoiceSet;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batches")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoiceBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public InvoiceBatch() {
    }

    public InvoiceBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getFromStatusSelect() {
        return this.fromStatusSelect == null ? 0 : this.fromStatusSelect;
    }

    public void setFromStatusSelect(Integer fromStatusSelect) {
        this.fromStatusSelect = fromStatusSelect;
    }

    public Integer getToStatusSelect() {
        return this.toStatusSelect == null ? 0 : this.toStatusSelect;
    }

    public void setToStatusSelect(Integer toStatusSelect) {
        this.toStatusSelect = toStatusSelect;
    }

    public Boolean getOnSelectOk() {
        return this.onSelectOk == null ? Boolean.FALSE : this.onSelectOk;
    }

    public void setOnSelectOk(Boolean onSelectOk) {
        this.onSelectOk = onSelectOk;
    }

    public Set<Invoice> getInvoiceSet() {
        return this.invoiceSet;
    }

    public void setInvoiceSet(Set<Invoice> invoiceSet) {
        this.invoiceSet = invoiceSet;
    }

    public void addInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            this.setInvoiceSet(new HashSet<Invoice>());
        }
        this.getInvoiceSet().add(item);
    }

    public void removeInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            return;
        }
        this.getInvoiceSet().remove((Object)item);
    }

    public void clearInvoiceSet() {
        if (this.getInvoiceSet() != null) {
            this.getInvoiceSet().clear();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList<Batch>());
        }
        this.getBatchList().add(item);
        item.setInvoiceBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvoiceBatch)) {
            return false;
        }
        InvoiceBatch other = (InvoiceBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-805245907, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("actionSelect", (Object)this.getActionSelect()).add("fromStatusSelect", (Object)this.getFromStatusSelect()).add("toStatusSelect", (Object)this.getToStatusSelect()).add("onSelectOk", (Object)this.getOnSelectOk()).omitNullValues().toString();
    }
}

