/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.IrrecoverableInvoiceLine;
import com.axelor.apps.account.db.IrrecoverablePaymentScheduleLineLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_IRRECOVERABLE_REPORT_LINE", indexes={@Index(name="idx_acc_irreco_report_line_irreco_inv_line", columnList="irrecoverable_invoice_line"), @Index(name="idx_acc_irreco_report_line_irreco_paym_schedule_line_line", columnList="irrecoverable_payment_schedule_line_line"), @Index(columnList="name")})
public class IrrecoverableReportLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_IRRECOVERABLE_REPORT_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_IRRECOVERABLE_REPORT_LINE_SEQ", sequenceName="ACCOUNT_IRRECOVERABLE_REPORT_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Invoice")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private IrrecoverableInvoiceLine irrecoverableInvoiceLine;
    @Widget(title="Rejected schedule line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private IrrecoverablePaymentScheduleLineLine irrecoverablePaymentScheduleLineLine;
    @Widget(title="Reference")
    private Integer reportLineSeq = 0;
    @Widget(title="Label", readonly=true)
    private String label;
    @Widget(title="Value", readonly=true)
    private BigDecimal value = BigDecimal.ZERO;
    @Widget(title="Name")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public IrrecoverableReportLine() {
    }

    public IrrecoverableReportLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IrrecoverableInvoiceLine getIrrecoverableInvoiceLine() {
        return this.irrecoverableInvoiceLine;
    }

    public void setIrrecoverableInvoiceLine(IrrecoverableInvoiceLine irrecoverableInvoiceLine) {
        this.irrecoverableInvoiceLine = irrecoverableInvoiceLine;
    }

    public IrrecoverablePaymentScheduleLineLine getIrrecoverablePaymentScheduleLineLine() {
        return this.irrecoverablePaymentScheduleLineLine;
    }

    public void setIrrecoverablePaymentScheduleLineLine(IrrecoverablePaymentScheduleLineLine irrecoverablePaymentScheduleLineLine) {
        this.irrecoverablePaymentScheduleLineLine = irrecoverablePaymentScheduleLineLine;
    }

    public Integer getReportLineSeq() {
        return this.reportLineSeq == null ? 0 : this.reportLineSeq;
    }

    public void setReportLineSeq(Integer reportLineSeq) {
        this.reportLineSeq = reportLineSeq;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public BigDecimal getValue() {
        return this.value == null ? BigDecimal.ZERO : this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.irrecoverableInvoiceLine != null) {
            return this.irrecoverableInvoiceLine.getInvoiceLineSeq() + " - " + this.reportLineSeq;
        }
        if (this.irrecoverablePaymentScheduleLineLine != null && this.irrecoverablePaymentScheduleLineLine.getName() != null) {
            return this.irrecoverablePaymentScheduleLineLine.getName() + " - " + this.reportLineSeq;
        }
        return this.reportLineSeq.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IrrecoverableReportLine)) {
            return false;
        }
        IrrecoverableReportLine other = (IrrecoverableReportLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("reportLineSeq", (Object)this.getReportLineSeq()).add("label", (Object)this.getLabel()).add("value", (Object)this.getValue()).omitNullValues().toString();
    }
}

