/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountType;
import com.axelor.apps.account.db.JournalType;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_JOURNAL", uniqueConstraints={@UniqueConstraint(columnNames={"company", "code", "name"})}, indexes={@Index(columnList="code"), @Index(columnList="name"), @Index(columnList="journal_type"), @Index(columnList="sequence"), @Index(columnList="company")})
public class Journal
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_JOURNAL_SEQ")
    @SequenceGenerator(name="ACCOUNT_JOURNAL_SEQ", sequenceName="ACCOUNT_JOURNAL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    private String code;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Journal Type", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private JournalType journalType;
    @Widget(title="Export code", massUpdate=true)
    private String exportCode;
    @Widget(title="Allow payments greater than due amount", massUpdate=true)
    private Boolean excessPaymentOk = Boolean.FALSE;
    @Widget(title="Edit receipt", massUpdate=true)
    private Boolean editReceiptOk = Boolean.FALSE;
    @Widget(title="Label for automatic moveline generation", massUpdate=true)
    private String descriptionModel;
    @Widget(title="Add Move line N\u00b0 in the description", massUpdate=true)
    private Boolean descriptionIdentificationOk = Boolean.FALSE;
    @Widget(title="Do not export", massUpdate=true)
    private Boolean notExportOk = Boolean.FALSE;
    @Widget(title="Status", selection="account.journal.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Consolidate invoice movelines", massUpdate=true)
    private Boolean isInvoiceMoveConsolidated = Boolean.FALSE;
    @Widget(title="Sequence", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence sequence;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Compatible Account Types")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<AccountType> validAccountTypeSet;
    @Widget(title="Compatible Accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Account> validAccountSet;
    @Widget(title="Compatible partner", selection="account.journal.compatible.partner.type.select")
    private String compatiblePartnerTypeSelect;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Journal() {
    }

    public Journal(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JournalType getJournalType() {
        return this.journalType;
    }

    public void setJournalType(JournalType journalType) {
        this.journalType = journalType;
    }

    public String getExportCode() {
        return this.exportCode;
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public Boolean getExcessPaymentOk() {
        return this.excessPaymentOk == null ? Boolean.FALSE : this.excessPaymentOk;
    }

    public void setExcessPaymentOk(Boolean excessPaymentOk) {
        this.excessPaymentOk = excessPaymentOk;
    }

    public Boolean getEditReceiptOk() {
        return this.editReceiptOk == null ? Boolean.FALSE : this.editReceiptOk;
    }

    public void setEditReceiptOk(Boolean editReceiptOk) {
        this.editReceiptOk = editReceiptOk;
    }

    public String getDescriptionModel() {
        return this.descriptionModel;
    }

    public void setDescriptionModel(String descriptionModel) {
        this.descriptionModel = descriptionModel;
    }

    public Boolean getDescriptionIdentificationOk() {
        return this.descriptionIdentificationOk == null ? Boolean.FALSE : this.descriptionIdentificationOk;
    }

    public void setDescriptionIdentificationOk(Boolean descriptionIdentificationOk) {
        this.descriptionIdentificationOk = descriptionIdentificationOk;
    }

    public Boolean getNotExportOk() {
        return this.notExportOk == null ? Boolean.FALSE : this.notExportOk;
    }

    public void setNotExportOk(Boolean notExportOk) {
        this.notExportOk = notExportOk;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIsInvoiceMoveConsolidated() {
        return this.isInvoiceMoveConsolidated == null ? Boolean.FALSE : this.isInvoiceMoveConsolidated;
    }

    public void setIsInvoiceMoveConsolidated(Boolean isInvoiceMoveConsolidated) {
        this.isInvoiceMoveConsolidated = isInvoiceMoveConsolidated;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<AccountType> getValidAccountTypeSet() {
        return this.validAccountTypeSet;
    }

    public void setValidAccountTypeSet(Set<AccountType> validAccountTypeSet) {
        this.validAccountTypeSet = validAccountTypeSet;
    }

    public void addValidAccountTypeSetItem(AccountType item) {
        if (this.getValidAccountTypeSet() == null) {
            this.setValidAccountTypeSet(new HashSet<AccountType>());
        }
        this.getValidAccountTypeSet().add(item);
    }

    public void removeValidAccountTypeSetItem(AccountType item) {
        if (this.getValidAccountTypeSet() == null) {
            return;
        }
        this.getValidAccountTypeSet().remove((Object)item);
    }

    public void clearValidAccountTypeSet() {
        if (this.getValidAccountTypeSet() != null) {
            this.getValidAccountTypeSet().clear();
        }
    }

    public Set<Account> getValidAccountSet() {
        return this.validAccountSet;
    }

    public void setValidAccountSet(Set<Account> validAccountSet) {
        this.validAccountSet = validAccountSet;
    }

    public void addValidAccountSetItem(Account item) {
        if (this.getValidAccountSet() == null) {
            this.setValidAccountSet(new HashSet<Account>());
        }
        this.getValidAccountSet().add(item);
    }

    public void removeValidAccountSetItem(Account item) {
        if (this.getValidAccountSet() == null) {
            return;
        }
        this.getValidAccountSet().remove((Object)item);
    }

    public void clearValidAccountSet() {
        if (this.getValidAccountSet() != null) {
            this.getValidAccountSet().clear();
        }
    }

    public String getCompatiblePartnerTypeSelect() {
        return this.compatiblePartnerTypeSelect;
    }

    public void setCompatiblePartnerTypeSelect(String compatiblePartnerTypeSelect) {
        this.compatiblePartnerTypeSelect = compatiblePartnerTypeSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Journal)) {
            return false;
        }
        Journal other = (Journal)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("exportCode", (Object)this.getExportCode()).add("excessPaymentOk", (Object)this.getExcessPaymentOk()).add("editReceiptOk", (Object)this.getEditReceiptOk()).add("descriptionModel", (Object)this.getDescriptionModel()).add("descriptionIdentificationOk", (Object)this.getDescriptionIdentificationOk()).add("notExportOk", (Object)this.getNotExportOk()).add("statusSelect", (Object)this.getStatusSelect()).add("isInvoiceMoveConsolidated", (Object)this.getIsInvoiceMoveConsolidated()).add("compatiblePartnerTypeSelect", (Object)this.getCompatiblePartnerTypeSelect()).omitNullValues().toString();
    }
}

