/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.MoveTemplateLine;
import com.axelor.apps.account.db.MoveTemplateType;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_MOVE_TEMPLATE", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="move_template_type"), @Index(columnList="company"), @Index(columnList="journal"), @Index(columnList="fullName")})
@Track(on={TrackEvent.UPDATE}, fields={@TrackField(name="name"), @TrackField(name="code"), @TrackField(name="moveTemplateType"), @TrackField(name="company"), @TrackField(name="journal"), @TrackField(name="endOfValidityDate")}, messages={@TrackMessage(message="Move template updated", condition="!isValid")})
public class MoveTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_MOVE_TEMPLATE_SEQ")
    @SequenceGenerator(name="ACCOUNT_MOVE_TEMPLATE_SEQ", sequenceName="ACCOUNT_MOVE_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveTemplateType moveTemplateType;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Valid")
    private Boolean isValid = Boolean.FALSE;
    @Widget(title="Validate automatically the generated moves")
    private Boolean automaticallyValidate = Boolean.FALSE;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Template Move Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="moveTemplate", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MoveTemplateLine> moveTemplateLineList;
    @Widget(title="End of validity date")
    private LocalDate endOfValidityDate;
    @Widget(search={"code", "name"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public MoveTemplate() {
    }

    public MoveTemplate(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public MoveTemplateType getMoveTemplateType() {
        return this.moveTemplateType;
    }

    public void setMoveTemplateType(MoveTemplateType moveTemplateType) {
        this.moveTemplateType = moveTemplateType;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Boolean getIsValid() {
        return this.isValid == null ? Boolean.FALSE : this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Boolean getAutomaticallyValidate() {
        return this.automaticallyValidate == null ? Boolean.FALSE : this.automaticallyValidate;
    }

    public void setAutomaticallyValidate(Boolean automaticallyValidate) {
        this.automaticallyValidate = automaticallyValidate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<MoveTemplateLine> getMoveTemplateLineList() {
        return this.moveTemplateLineList;
    }

    public void setMoveTemplateLineList(List<MoveTemplateLine> moveTemplateLineList) {
        this.moveTemplateLineList = moveTemplateLineList;
    }

    public void addMoveTemplateLineListItem(MoveTemplateLine item) {
        if (this.getMoveTemplateLineList() == null) {
            this.setMoveTemplateLineList(new ArrayList<MoveTemplateLine>());
        }
        this.getMoveTemplateLineList().add(item);
        item.setMoveTemplate(this);
    }

    public void removeMoveTemplateLineListItem(MoveTemplateLine item) {
        if (this.getMoveTemplateLineList() == null) {
            return;
        }
        this.getMoveTemplateLineList().remove((Object)item);
    }

    public void clearMoveTemplateLineList() {
        if (this.getMoveTemplateLineList() != null) {
            this.getMoveTemplateLineList().clear();
        }
    }

    public LocalDate getEndOfValidityDate() {
        return this.endOfValidityDate;
    }

    public void setEndOfValidityDate(LocalDate endOfValidityDate) {
        this.endOfValidityDate = endOfValidityDate;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        return this.code + " - " + this.name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MoveTemplate)) {
            return false;
        }
        MoveTemplate other = (MoveTemplate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("isValid", (Object)this.getIsValid()).add("automaticallyValidate", (Object)this.getAutomaticallyValidate()).add("endOfValidityDate", (Object)this.getEndOfValidityDate()).omitNullValues().toString();
    }
}

