/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.NotificationItem;
import com.axelor.apps.account.db.SubrogationRelease;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_NOTIFICATION", indexes={@Index(columnList="company"), @Index(columnList="factor_partner"), @Index(columnList="subrogation_release")})
public class Notification
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_NOTIFICATION_SEQ")
    @SequenceGenerator(name="ACCOUNT_NOTIFICATION_SEQ", sequenceName="ACCOUNT_NOTIFICATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Status", readonly=true, selection="account.notification.status.select")
    private Integer statusSelect = 1;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Factor")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner factorPartner;
    @NotNull
    private LocalDate paymentDate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SubrogationRelease subrogationRelease;
    @Widget(title="Invoices")
    @NotNull
    @OneToMany(fetch=FetchType.LAZY, mappedBy="notification", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<NotificationItem> notificationItemList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getFactorPartner() {
        return this.factorPartner;
    }

    public void setFactorPartner(Partner factorPartner) {
        this.factorPartner = factorPartner;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public SubrogationRelease getSubrogationRelease() {
        return this.subrogationRelease;
    }

    public void setSubrogationRelease(SubrogationRelease subrogationRelease) {
        this.subrogationRelease = subrogationRelease;
    }

    public List<NotificationItem> getNotificationItemList() {
        return this.notificationItemList;
    }

    public void setNotificationItemList(List<NotificationItem> notificationItemList) {
        this.notificationItemList = notificationItemList;
    }

    public void addNotificationItemListItem(NotificationItem item) {
        if (this.getNotificationItemList() == null) {
            this.setNotificationItemList(new ArrayList<NotificationItem>());
        }
        this.getNotificationItemList().add(item);
        item.setNotification(this);
    }

    public void removeNotificationItemListItem(NotificationItem item) {
        if (this.getNotificationItemList() == null) {
            return;
        }
        this.getNotificationItemList().remove((Object)item);
    }

    public void clearNotificationItemList() {
        if (this.getNotificationItemList() != null) {
            this.getNotificationItemList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("paymentDate", (Object)this.getPaymentDate()).omitNullValues().toString();
    }
}

