/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_PAY_VOUCHER_ELEMENT_TO_PAY", indexes={@Index(columnList="move_line"), @Index(columnList="move_line_generated"), @Index(columnList="payment_voucher"), @Index(columnList="currency")})
public class PayVoucherElementToPay
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAY_VOUCHER_ELEMENT_TO_PAY_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAY_VOUCHER_ELEMENT_TO_PAY_SEQ", sequenceName="ACCOUNT_PAY_VOUCHER_ELEMENT_TO_PAY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Move line", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLine;
    @Widget(title="Total amount", readonly=true)
    private BigDecimal totalAmount = BigDecimal.ZERO;
    @Widget(title="Amount remaining before cashing", readonly=true)
    private BigDecimal remainingAmount = BigDecimal.ZERO;
    @Widget(title="Move Line generated", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLineGenerated;
    @Widget(title="Payment", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentVoucher paymentVoucher;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Imput. amount in currency")
    private BigDecimal amountToPayCurrency = BigDecimal.ZERO;
    @Widget(title="Imput amount")
    private BigDecimal amountToPay = BigDecimal.ZERO;
    @Widget(title="Remaining to pay after cashing", readonly=true)
    private BigDecimal remainingAmountAfterPayment = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public MoveLine getMoveLine() {
        return this.moveLine;
    }

    public void setMoveLine(MoveLine moveLine) {
        this.moveLine = moveLine;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount == null ? BigDecimal.ZERO : this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getRemainingAmount() {
        return this.remainingAmount == null ? BigDecimal.ZERO : this.remainingAmount;
    }

    public void setRemainingAmount(BigDecimal remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public MoveLine getMoveLineGenerated() {
        return this.moveLineGenerated;
    }

    public void setMoveLineGenerated(MoveLine moveLineGenerated) {
        this.moveLineGenerated = moveLineGenerated;
    }

    public PaymentVoucher getPaymentVoucher() {
        return this.paymentVoucher;
    }

    public void setPaymentVoucher(PaymentVoucher paymentVoucher) {
        this.paymentVoucher = paymentVoucher;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BigDecimal getAmountToPayCurrency() {
        return this.amountToPayCurrency == null ? BigDecimal.ZERO : this.amountToPayCurrency;
    }

    public void setAmountToPayCurrency(BigDecimal amountToPayCurrency) {
        this.amountToPayCurrency = amountToPayCurrency;
    }

    public BigDecimal getAmountToPay() {
        return this.amountToPay == null ? BigDecimal.ZERO : this.amountToPay;
    }

    public void setAmountToPay(BigDecimal amountToPay) {
        this.amountToPay = amountToPay;
    }

    public BigDecimal getRemainingAmountAfterPayment() {
        return this.remainingAmountAfterPayment == null ? BigDecimal.ZERO : this.remainingAmountAfterPayment;
    }

    public void setRemainingAmountAfterPayment(BigDecimal remainingAmountAfterPayment) {
        this.remainingAmountAfterPayment = remainingAmountAfterPayment;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PayVoucherElementToPay)) {
            return false;
        }
        PayVoucherElementToPay other = (PayVoucherElementToPay)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("totalAmount", (Object)this.getTotalAmount()).add("remainingAmount", (Object)this.getRemainingAmount()).add("amountToPayCurrency", (Object)this.getAmountToPayCurrency()).add("amountToPay", (Object)this.getAmountToPay()).add("remainingAmountAfterPayment", (Object)this.getRemainingAmountAfterPayment()).omitNullValues().toString();
    }
}

