/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_PAYMENT_CONDITION", indexes={@Index(columnList="name")})
public class PaymentCondition
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_CONDITION_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_CONDITION_SEQ", sequenceName="ACCOUNT_PAYMENT_CONDITION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", translatable=true)
    @NotNull
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Type", selection="account.payment.condition.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Period type", selection="account.payment.condition.period.type.select")
    private Integer periodTypeSelect = 1;
    @Widget(title="Payment period (N days / Month)")
    private Integer paymentTime = 0;
    @Widget(title="Day (end of month)", selection="day.month.select")
    private Integer daySelect = 0;
    @Widget(title="Free")
    private Boolean isFree = Boolean.FALSE;
    @Widget(title="Percentage of advance payment")
    private BigDecimal advancePaymentNeeded = new BigDecimal("0");
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PaymentCondition() {
    }

    public PaymentCondition(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getPeriodTypeSelect() {
        return this.periodTypeSelect == null ? 0 : this.periodTypeSelect;
    }

    public void setPeriodTypeSelect(Integer periodTypeSelect) {
        this.periodTypeSelect = periodTypeSelect;
    }

    public Integer getPaymentTime() {
        return this.paymentTime == null ? 0 : this.paymentTime;
    }

    public void setPaymentTime(Integer paymentTime) {
        this.paymentTime = paymentTime;
    }

    public Integer getDaySelect() {
        return this.daySelect == null ? 0 : this.daySelect;
    }

    public void setDaySelect(Integer daySelect) {
        this.daySelect = daySelect;
    }

    public Boolean getIsFree() {
        return this.isFree == null ? Boolean.FALSE : this.isFree;
    }

    public void setIsFree(Boolean isFree) {
        this.isFree = isFree;
    }

    public BigDecimal getAdvancePaymentNeeded() {
        return this.advancePaymentNeeded == null ? BigDecimal.ZERO : this.advancePaymentNeeded;
    }

    public void setAdvancePaymentNeeded(BigDecimal advancePaymentNeeded) {
        this.advancePaymentNeeded = advancePaymentNeeded;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentCondition)) {
            return false;
        }
        PaymentCondition other = (PaymentCondition)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-770406955, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("typeSelect", (Object)this.getTypeSelect()).add("periodTypeSelect", (Object)this.getPeriodTypeSelect()).add("paymentTime", (Object)this.getPaymentTime()).add("daySelect", (Object)this.getDaySelect()).add("isFree", (Object)this.getIsFree()).add("advancePaymentNeeded", (Object)this.getAdvancePaymentNeeded()).omitNullValues().toString();
    }
}

