/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.base.db.Batch;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_PAYMENT_SCHEDULE_LINE", indexes={@Index(columnList="payment_schedule"), @Index(columnList="interbank_code_line"), @Index(columnList="advance_move_line"), @Index(columnList="reject_move_line"), @Index(columnList="advance_or_payment_move"), @Index(columnList="name")})
public class PaymentScheduleLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_SCHEDULE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_SCHEDULE_LINE_SEQ", sequenceName="ACCOUNT_PAYMENT_SCHEDULE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Payment Schedule")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentSchedule paymentSchedule;
    @Widget(title="Schedule line N\u00b0")
    @NotNull
    private Integer scheduleLineSeq = 0;
    @Widget(title="Amount A.T.I.")
    private BigDecimal inTaxAmount = BigDecimal.ZERO;
    @Widget(title="Amount paid A.T.I.")
    private BigDecimal inTaxAmountPaid = BigDecimal.ZERO;
    @Widget(title="Schedule Date")
    @NotNull
    private LocalDate scheduleDate;
    @Widget(title="Rejected")
    private Boolean rejectedOk = Boolean.FALSE;
    @Widget(title="Debit blocking")
    private Boolean debitBlockingOk = Boolean.FALSE;
    @Widget(title="Status", readonly=true, selection="iaccount.payment.schedule.line.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Rejection date")
    private LocalDate rejectDate;
    @Widget(title="Rejection reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Advance move line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine advanceMoveLine;
    @Widget(title="Direct debit Nbr")
    private String debitNumber;
    @Widget(title="Rejection move line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine rejectMoveLine;
    @Widget(title="Advance/Payment move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move advanceOrPaymentMove;
    @Widget(title="From rejection")
    private Boolean fromReject = Boolean.FALSE;
    @Widget(title="Amount rejected")
    private BigDecimal amountRejected = BigDecimal.ZERO;
    @Widget(title="Batches")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Debited amount", readonly=true)
    private BigDecimal directDebitAmount = BigDecimal.ZERO;
    @Widget(search={"paymentSchedule", "scheduleLineSeq"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PaymentScheduleLine() {
    }

    public PaymentScheduleLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PaymentSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public void setPaymentSchedule(PaymentSchedule paymentSchedule) {
        this.paymentSchedule = paymentSchedule;
    }

    public Integer getScheduleLineSeq() {
        return this.scheduleLineSeq == null ? 0 : this.scheduleLineSeq;
    }

    public void setScheduleLineSeq(Integer scheduleLineSeq) {
        this.scheduleLineSeq = scheduleLineSeq;
    }

    public BigDecimal getInTaxAmount() {
        return this.inTaxAmount == null ? BigDecimal.ZERO : this.inTaxAmount;
    }

    public void setInTaxAmount(BigDecimal inTaxAmount) {
        this.inTaxAmount = inTaxAmount;
    }

    public BigDecimal getInTaxAmountPaid() {
        return this.inTaxAmountPaid == null ? BigDecimal.ZERO : this.inTaxAmountPaid;
    }

    public void setInTaxAmountPaid(BigDecimal inTaxAmountPaid) {
        this.inTaxAmountPaid = inTaxAmountPaid;
    }

    public LocalDate getScheduleDate() {
        return this.scheduleDate;
    }

    public void setScheduleDate(LocalDate scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    public Boolean getRejectedOk() {
        return this.rejectedOk == null ? Boolean.FALSE : this.rejectedOk;
    }

    public void setRejectedOk(Boolean rejectedOk) {
        this.rejectedOk = rejectedOk;
    }

    public Boolean getDebitBlockingOk() {
        return this.debitBlockingOk == null ? Boolean.FALSE : this.debitBlockingOk;
    }

    public void setDebitBlockingOk(Boolean debitBlockingOk) {
        this.debitBlockingOk = debitBlockingOk;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getRejectDate() {
        return this.rejectDate;
    }

    public void setRejectDate(LocalDate rejectDate) {
        this.rejectDate = rejectDate;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public MoveLine getAdvanceMoveLine() {
        return this.advanceMoveLine;
    }

    public void setAdvanceMoveLine(MoveLine advanceMoveLine) {
        this.advanceMoveLine = advanceMoveLine;
    }

    public String getDebitNumber() {
        return this.debitNumber;
    }

    public void setDebitNumber(String debitNumber) {
        this.debitNumber = debitNumber;
    }

    public MoveLine getRejectMoveLine() {
        return this.rejectMoveLine;
    }

    public void setRejectMoveLine(MoveLine rejectMoveLine) {
        this.rejectMoveLine = rejectMoveLine;
    }

    public Move getAdvanceOrPaymentMove() {
        return this.advanceOrPaymentMove;
    }

    public void setAdvanceOrPaymentMove(Move advanceOrPaymentMove) {
        this.advanceOrPaymentMove = advanceOrPaymentMove;
    }

    public Boolean getFromReject() {
        return this.fromReject == null ? Boolean.FALSE : this.fromReject;
    }

    public void setFromReject(Boolean fromReject) {
        this.fromReject = fromReject;
    }

    public BigDecimal getAmountRejected() {
        return this.amountRejected == null ? BigDecimal.ZERO : this.amountRejected;
    }

    public void setAmountRejected(BigDecimal amountRejected) {
        this.amountRejected = amountRejected;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public BigDecimal getDirectDebitAmount() {
        return this.directDebitAmount == null ? BigDecimal.ZERO : this.directDebitAmount;
    }

    public void setDirectDebitAmount(BigDecimal directDebitAmount) {
        this.directDebitAmount = directDebitAmount;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.paymentSchedule != null && this.paymentSchedule.getPaymentScheduleSeq() != null) {
            return this.paymentSchedule.getPaymentScheduleSeq() + " - " + this.scheduleLineSeq;
        }
        if (this.scheduleLineSeq != null) {
            return this.scheduleLineSeq.toString();
        }
        return " - ";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentScheduleLine)) {
            return false;
        }
        PaymentScheduleLine other = (PaymentScheduleLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("scheduleLineSeq", (Object)this.getScheduleLineSeq()).add("inTaxAmount", (Object)this.getInTaxAmount()).add("inTaxAmountPaid", (Object)this.getInTaxAmountPaid()).add("scheduleDate", (Object)this.getScheduleDate()).add("rejectedOk", (Object)this.getRejectedOk()).add("debitBlockingOk", (Object)this.getDebitBlockingOk()).add("statusSelect", (Object)this.getStatusSelect()).add("rejectDate", (Object)this.getRejectDate()).add("debitNumber", (Object)this.getDebitNumber()).add("fromReject", (Object)this.getFromReject()).add("amountRejected", (Object)this.getAmountRejected()).omitNullValues().toString();
    }
}

