/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.DepositSlip;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayVoucherDueElement;
import com.axelor.apps.account.db.PayVoucherElementToPay;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_PAYMENT_VOUCHER", uniqueConstraints={@UniqueConstraint(columnNames={"ref", "company"}), @UniqueConstraint(columnNames={"receiptNo", "company"})}, indexes={@Index(columnList="ref"), @Index(columnList="partner"), @Index(columnList="account"), @Index(columnList="payment_mode"), @Index(columnList="company_bank_details"), @Index(columnList="user_id"), @Index(columnList="move_line"), @Index(columnList="generated_move"), @Index(columnList="company"), @Index(columnList="currency"), @Index(columnList="deposit_slip")})
public class PaymentVoucher
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_VOUCHER_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_VOUCHER_SEQ", sequenceName="ACCOUNT_PAYMENT_VOUCHER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reference")
    @NameColumn
    private String ref;
    @Widget(title="Partner")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Partner account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account account;
    @Widget(title="Payment mode")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Company bank details")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Widget(title="Payment date")
    private LocalDate paymentDate;
    @Widget(title="Amount paid")
    private BigDecimal paidAmount = BigDecimal.ZERO;
    @Widget(title="User", readonly=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Overdue moveline")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLine;
    @Widget(title="Amount Remaining to allocate")
    private BigDecimal remainingAllocatedAmount = BigDecimal.ZERO;
    @Widget(title="Allocated amount")
    private BigDecimal allocatedAmount = BigDecimal.ZERO;
    @Widget(title="List of invoices/schedule lines with remaining amount to pay")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="paymentVoucher", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PayVoucherDueElement> payVoucherDueElementList;
    @Widget(title="List of invoices to pay")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="paymentVoucher", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PayVoucherElementToPay> payVoucherElementToPayList;
    @Widget(title="Status", readonly=true, selection="iaccount.payment.voucher.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Generated move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move generatedMove;
    @Widget(title="Auto. input.")
    private Boolean hasAutoInput = Boolean.FALSE;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="CC Transaction N\u00b0", readonly=true)
    private String bankCardTransactionNumber;
    @Widget(title="Receipt N\u00b0", readonly=true)
    private String receiptNo;
    @Widget(title="Email to use")
    private String email;
    @Widget(title="Save email sent to contact")
    private Boolean toSaveEmailOk = Boolean.TRUE;
    @Widget(title="Default email address")
    private Boolean defaultEmailOk = Boolean.FALSE;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Amount paid in currency")
    private BigDecimal paidAmountInCurrency = BigDecimal.ZERO;
    @Widget(title="Payment type", selection="iinvoice.operation.type.select")
    @NotNull
    private Integer operationTypeSelect = 0;
    @Widget(title="Amount remaining to allocate")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private BigDecimal remainingAmount = BigDecimal.ZERO;
    private String chequeNumber;
    private String chequeBank;
    private String chequeOwner;
    @Widget(title="Bank deposit date")
    private LocalDate chequeDate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DepositSlip depositSlip;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public BigDecimal getPaidAmount() {
        return this.paidAmount == null ? BigDecimal.ZERO : this.paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MoveLine getMoveLine() {
        return this.moveLine;
    }

    public void setMoveLine(MoveLine moveLine) {
        this.moveLine = moveLine;
    }

    public BigDecimal getRemainingAllocatedAmount() {
        return this.remainingAllocatedAmount == null ? BigDecimal.ZERO : this.remainingAllocatedAmount;
    }

    public void setRemainingAllocatedAmount(BigDecimal remainingAllocatedAmount) {
        this.remainingAllocatedAmount = remainingAllocatedAmount;
    }

    public BigDecimal getAllocatedAmount() {
        return this.allocatedAmount == null ? BigDecimal.ZERO : this.allocatedAmount;
    }

    public void setAllocatedAmount(BigDecimal allocatedAmount) {
        this.allocatedAmount = allocatedAmount;
    }

    public List<PayVoucherDueElement> getPayVoucherDueElementList() {
        return this.payVoucherDueElementList;
    }

    public void setPayVoucherDueElementList(List<PayVoucherDueElement> payVoucherDueElementList) {
        this.payVoucherDueElementList = payVoucherDueElementList;
    }

    public void addPayVoucherDueElementListItem(PayVoucherDueElement item) {
        if (this.getPayVoucherDueElementList() == null) {
            this.setPayVoucherDueElementList(new ArrayList<PayVoucherDueElement>());
        }
        this.getPayVoucherDueElementList().add(item);
        item.setPaymentVoucher(this);
    }

    public void removePayVoucherDueElementListItem(PayVoucherDueElement item) {
        if (this.getPayVoucherDueElementList() == null) {
            return;
        }
        this.getPayVoucherDueElementList().remove((Object)item);
    }

    public void clearPayVoucherDueElementList() {
        if (this.getPayVoucherDueElementList() != null) {
            this.getPayVoucherDueElementList().clear();
        }
    }

    public List<PayVoucherElementToPay> getPayVoucherElementToPayList() {
        return this.payVoucherElementToPayList;
    }

    public void setPayVoucherElementToPayList(List<PayVoucherElementToPay> payVoucherElementToPayList) {
        this.payVoucherElementToPayList = payVoucherElementToPayList;
    }

    public void addPayVoucherElementToPayListItem(PayVoucherElementToPay item) {
        if (this.getPayVoucherElementToPayList() == null) {
            this.setPayVoucherElementToPayList(new ArrayList<PayVoucherElementToPay>());
        }
        this.getPayVoucherElementToPayList().add(item);
        item.setPaymentVoucher(this);
    }

    public void removePayVoucherElementToPayListItem(PayVoucherElementToPay item) {
        if (this.getPayVoucherElementToPayList() == null) {
            return;
        }
        this.getPayVoucherElementToPayList().remove((Object)item);
    }

    public void clearPayVoucherElementToPayList() {
        if (this.getPayVoucherElementToPayList() != null) {
            this.getPayVoucherElementToPayList().clear();
        }
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Move getGeneratedMove() {
        return this.generatedMove;
    }

    public void setGeneratedMove(Move generatedMove) {
        this.generatedMove = generatedMove;
    }

    public Boolean getHasAutoInput() {
        return this.hasAutoInput == null ? Boolean.FALSE : this.hasAutoInput;
    }

    public void setHasAutoInput(Boolean hasAutoInput) {
        this.hasAutoInput = hasAutoInput;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getBankCardTransactionNumber() {
        return this.bankCardTransactionNumber;
    }

    public void setBankCardTransactionNumber(String bankCardTransactionNumber) {
        this.bankCardTransactionNumber = bankCardTransactionNumber;
    }

    public String getReceiptNo() {
        return this.receiptNo;
    }

    public void setReceiptNo(String receiptNo) {
        this.receiptNo = receiptNo;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getToSaveEmailOk() {
        return this.toSaveEmailOk == null ? Boolean.FALSE : this.toSaveEmailOk;
    }

    public void setToSaveEmailOk(Boolean toSaveEmailOk) {
        this.toSaveEmailOk = toSaveEmailOk;
    }

    public Boolean getDefaultEmailOk() {
        return this.defaultEmailOk == null ? Boolean.FALSE : this.defaultEmailOk;
    }

    public void setDefaultEmailOk(Boolean defaultEmailOk) {
        this.defaultEmailOk = defaultEmailOk;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BigDecimal getPaidAmountInCurrency() {
        return this.paidAmountInCurrency == null ? BigDecimal.ZERO : this.paidAmountInCurrency;
    }

    public void setPaidAmountInCurrency(BigDecimal paidAmountInCurrency) {
        this.paidAmountInCurrency = paidAmountInCurrency;
    }

    public Integer getOperationTypeSelect() {
        return this.operationTypeSelect == null ? 0 : this.operationTypeSelect;
    }

    public void setOperationTypeSelect(Integer operationTypeSelect) {
        this.operationTypeSelect = operationTypeSelect;
    }

    public BigDecimal getRemainingAmount() {
        try {
            this.remainingAmount = this.computeRemainingAmount();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getRemainingAmount()", (Throwable)e);
        }
        return this.remainingAmount;
    }

    protected BigDecimal computeRemainingAmount() {
        BigDecimal totalElementToPay = BigDecimal.ZERO;
        if (this.getPaidAmount().signum() != 0) {
            if (this.getPayVoucherElementToPayList() != null && !this.getPayVoucherElementToPayList().isEmpty()) {
                for (PayVoucherElementToPay payVoucherElementToPay : this.getPayVoucherElementToPayList()) {
                    if (payVoucherElementToPay == null) continue;
                    totalElementToPay = totalElementToPay.add(payVoucherElementToPay.getAmountToPayCurrency());
                }
            }
            return this.getPaidAmount().subtract(totalElementToPay);
        }
        return totalElementToPay;
    }

    public void setRemainingAmount(BigDecimal remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public String getChequeNumber() {
        return this.chequeNumber;
    }

    public void setChequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
    }

    public String getChequeBank() {
        return this.chequeBank;
    }

    public void setChequeBank(String chequeBank) {
        this.chequeBank = chequeBank;
    }

    public String getChequeOwner() {
        return this.chequeOwner;
    }

    public void setChequeOwner(String chequeOwner) {
        this.chequeOwner = chequeOwner;
    }

    public LocalDate getChequeDate() {
        return this.chequeDate;
    }

    public void setChequeDate(LocalDate chequeDate) {
        this.chequeDate = chequeDate;
    }

    public DepositSlip getDepositSlip() {
        return this.depositSlip;
    }

    public void setDepositSlip(DepositSlip depositSlip) {
        this.depositSlip = depositSlip;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentVoucher)) {
            return false;
        }
        PaymentVoucher other = (PaymentVoucher)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("ref", (Object)this.getRef()).add("paymentDate", (Object)this.getPaymentDate()).add("paidAmount", (Object)this.getPaidAmount()).add("remainingAllocatedAmount", (Object)this.getRemainingAllocatedAmount()).add("allocatedAmount", (Object)this.getAllocatedAmount()).add("statusSelect", (Object)this.getStatusSelect()).add("hasAutoInput", (Object)this.getHasAutoInput()).add("bankCardTransactionNumber", (Object)this.getBankCardTransactionNumber()).add("receiptNo", (Object)this.getReceiptNo()).add("email", (Object)this.getEmail()).add("toSaveEmailOk", (Object)this.getToSaveEmailOk()).omitNullValues().toString();
    }
}

