/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.ReconcileGroup;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_RECONCILE", uniqueConstraints={@UniqueConstraint(columnNames={"reconcileSeq", "company"})}, indexes={@Index(columnList="reconcileSeq"), @Index(columnList="company"), @Index(columnList="debit_move_line"), @Index(columnList="credit_move_line"), @Index(columnList="reconcile_group")})
public class Reconcile
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_RECONCILE_SEQ")
    @SequenceGenerator(name="ACCOUNT_RECONCILE_SEQ", sequenceName="ACCOUNT_RECONCILE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reference")
    @NameColumn
    private String reconcileSeq;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Amount charged")
    private BigDecimal amount = new BigDecimal("0.0");
    @Widget(title="Debit line")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine debitMoveLine;
    @Widget(title="Credit line")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine creditMoveLine;
    @Widget(title="Status", readonly=true, selection="account.reconcile.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Reconciliation date", readonly=true)
    private LocalDate reconciliationDate;
    @Widget(title="Clear remaining amount")
    private Boolean canBeZeroBalanceOk = Boolean.FALSE;
    @Widget(title="Must be solded out")
    private Boolean mustBeZeroBalanceOk = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ReconcileGroup reconcileGroup;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Reconcile() {
    }

    public Reconcile(Company company, BigDecimal amount, MoveLine debitMoveLine, MoveLine creditMoveLine, Integer statusSelect, Boolean canBeZeroBalanceOk) {
        this.company = company;
        this.amount = amount;
        this.debitMoveLine = debitMoveLine;
        this.creditMoveLine = creditMoveLine;
        this.statusSelect = statusSelect;
        this.canBeZeroBalanceOk = canBeZeroBalanceOk;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReconcileSeq() {
        return this.reconcileSeq;
    }

    public void setReconcileSeq(String reconcileSeq) {
        this.reconcileSeq = reconcileSeq;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public MoveLine getDebitMoveLine() {
        return this.debitMoveLine;
    }

    public void setDebitMoveLine(MoveLine debitMoveLine) {
        this.debitMoveLine = debitMoveLine;
    }

    public MoveLine getCreditMoveLine() {
        return this.creditMoveLine;
    }

    public void setCreditMoveLine(MoveLine creditMoveLine) {
        this.creditMoveLine = creditMoveLine;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getReconciliationDate() {
        return this.reconciliationDate;
    }

    public void setReconciliationDate(LocalDate reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }

    public Boolean getCanBeZeroBalanceOk() {
        return this.canBeZeroBalanceOk == null ? Boolean.FALSE : this.canBeZeroBalanceOk;
    }

    public void setCanBeZeroBalanceOk(Boolean canBeZeroBalanceOk) {
        this.canBeZeroBalanceOk = canBeZeroBalanceOk;
    }

    public Boolean getMustBeZeroBalanceOk() {
        return this.mustBeZeroBalanceOk == null ? Boolean.FALSE : this.mustBeZeroBalanceOk;
    }

    public void setMustBeZeroBalanceOk(Boolean mustBeZeroBalanceOk) {
        this.mustBeZeroBalanceOk = mustBeZeroBalanceOk;
    }

    public ReconcileGroup getReconcileGroup() {
        return this.reconcileGroup;
    }

    public void setReconcileGroup(ReconcileGroup reconcileGroup) {
        this.reconcileGroup = reconcileGroup;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Reconcile)) {
            return false;
        }
        Reconcile other = (Reconcile)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("reconcileSeq", (Object)this.getReconcileSeq()).add("amount", (Object)this.getAmount()).add("statusSelect", (Object)this.getStatusSelect()).add("reconciliationDate", (Object)this.getReconciliationDate()).add("canBeZeroBalanceOk", (Object)this.getCanBeZeroBalanceOk()).add("mustBeZeroBalanceOk", (Object)this.getMustBeZeroBalanceOk()).omitNullValues().toString();
    }
}

