/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_REIMBURSEMENT", uniqueConstraints={@UniqueConstraint(columnNames={"ref", "company"})}, indexes={@Index(columnList="ref"), @Index(columnList="partner"), @Index(columnList="company"), @Index(columnList="bank_details"), @Index(columnList="interbank_code_line"), @Index(columnList="reject_move_line")})
public class Reimbursement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_REIMBURSEMENT_SEQ")
    @SequenceGenerator(name="ACCOUNT_REIMBURSEMENT_SEQ", sequenceName="ACCOUNT_REIMBURSEMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Ref.", readonly=true)
    @NameColumn
    private String ref;
    @Widget(title="Status", selection="iaccount.reimbursement.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Partner")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Overdue payment")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MoveLine> moveLineSet;
    @Widget(title="Reimbursed amount", readonly=true)
    private BigDecimal amountReimbursed = BigDecimal.ZERO;
    @Widget(title="Bank Details")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Description")
    private String description;
    @Widget(title="Rejected reimbursement", readonly=true)
    private Boolean rejectedOk = Boolean.FALSE;
    @Widget(title="Rejection reason", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Rejection date", readonly=true)
    private LocalDate rejectDate;
    @Widget(title="Rejection move line", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine rejectMoveLine;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Amount to reimburse", readonly=true)
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private BigDecimal amountToReimburse = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<MoveLine> getMoveLineSet() {
        return this.moveLineSet;
    }

    public void setMoveLineSet(Set<MoveLine> moveLineSet) {
        this.moveLineSet = moveLineSet;
    }

    public void addMoveLineSetItem(MoveLine item) {
        if (this.getMoveLineSet() == null) {
            this.setMoveLineSet(new HashSet<MoveLine>());
        }
        this.getMoveLineSet().add(item);
    }

    public void removeMoveLineSetItem(MoveLine item) {
        if (this.getMoveLineSet() == null) {
            return;
        }
        this.getMoveLineSet().remove((Object)item);
    }

    public void clearMoveLineSet() {
        if (this.getMoveLineSet() != null) {
            this.getMoveLineSet().clear();
        }
    }

    public BigDecimal getAmountReimbursed() {
        return this.amountReimbursed == null ? BigDecimal.ZERO : this.amountReimbursed;
    }

    public void setAmountReimbursed(BigDecimal amountReimbursed) {
        this.amountReimbursed = amountReimbursed;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRejectedOk() {
        return this.rejectedOk == null ? Boolean.FALSE : this.rejectedOk;
    }

    public void setRejectedOk(Boolean rejectedOk) {
        this.rejectedOk = rejectedOk;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public LocalDate getRejectDate() {
        return this.rejectDate;
    }

    public void setRejectDate(LocalDate rejectDate) {
        this.rejectDate = rejectDate;
    }

    public MoveLine getRejectMoveLine() {
        return this.rejectMoveLine;
    }

    public void setRejectMoveLine(MoveLine rejectMoveLine) {
        this.rejectMoveLine = rejectMoveLine;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public BigDecimal getAmountToReimburse() {
        try {
            this.amountToReimburse = this.computeAmountToReimburse();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getAmountToReimburse()", (Throwable)e);
        }
        return this.amountToReimburse;
    }

    protected BigDecimal computeAmountToReimburse() {
        BigDecimal total = new BigDecimal("0.0");
        if (this.moveLineSet != null && !this.moveLineSet.isEmpty()) {
            for (MoveLine line : this.moveLineSet) {
                total = total.add(line.getAmountRemaining());
            }
        }
        return total;
    }

    public void setAmountToReimburse(BigDecimal amountToReimburse) {
        this.amountToReimburse = amountToReimburse;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Reimbursement)) {
            return false;
        }
        Reimbursement other = (Reimbursement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("ref", (Object)this.getRef()).add("statusSelect", (Object)this.getStatusSelect()).add("amountReimbursed", (Object)this.getAmountReimbursed()).add("description", (Object)this.getDescription()).add("rejectedOk", (Object)this.getRejectedOk()).add("rejectDate", (Object)this.getRejectDate()).omitNullValues().toString();
    }
}

