/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_SUBROGATION_RELEASE", indexes={@Index(columnList="sequenceNumber"), @Index(columnList="company")})
@Track(fields={@TrackField(name="statusSelect")}, messages={@TrackMessage(message="New release", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Release transmitted", condition="statusSelect == 2"), @TrackMessage(message="Release accounted", condition="statusSelect == 3"), @TrackMessage(message="Release cleared", condition="statusSelect == 4"), @TrackMessage(message="Release canceled", condition="statusSelect == 5")})
public class SubrogationRelease
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_SUBROGATION_RELEASE_SEQ")
    @SequenceGenerator(name="ACCOUNT_SUBROGATION_RELEASE_SEQ", sequenceName="ACCOUNT_SUBROGATION_RELEASE_SEQ", allocationSize=1)
    private Long id;
    @Widget(readonly=true)
    @NameColumn
    private String sequenceNumber;
    @Widget(title="Status", readonly=true, selection="account.subrogation.release.status.select")
    private Integer statusSelect = 1;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Release details")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Invoice> invoiceSet;
    @Widget(title="Transmission Date", readonly=true)
    private LocalDate transmissionDate;
    @Widget(title="Accounting Date")
    private LocalDate accountingDate;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Reasons of cancelation")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String cancelReason;
    @Widget(readonly=true, hidden=true)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Move> moveList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Invoice> getInvoiceSet() {
        return this.invoiceSet;
    }

    public void setInvoiceSet(Set<Invoice> invoiceSet) {
        this.invoiceSet = invoiceSet;
    }

    public void addInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            this.setInvoiceSet(new HashSet<Invoice>());
        }
        this.getInvoiceSet().add(item);
    }

    public void removeInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            return;
        }
        this.getInvoiceSet().remove((Object)item);
    }

    public void clearInvoiceSet() {
        if (this.getInvoiceSet() != null) {
            this.getInvoiceSet().clear();
        }
    }

    public LocalDate getTransmissionDate() {
        return this.transmissionDate;
    }

    public void setTransmissionDate(LocalDate transmissionDate) {
        this.transmissionDate = transmissionDate;
    }

    public LocalDate getAccountingDate() {
        return this.accountingDate;
    }

    public void setAccountingDate(LocalDate accountingDate) {
        this.accountingDate = accountingDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public List<Move> getMoveList() {
        return this.moveList;
    }

    public void setMoveList(List<Move> moveList) {
        this.moveList = moveList;
    }

    public void addMoveListItem(Move item) {
        if (this.getMoveList() == null) {
            this.setMoveList(new ArrayList<Move>());
        }
        this.getMoveList().add(item);
    }

    public void removeMoveListItem(Move item) {
        if (this.getMoveList() == null) {
            return;
        }
        this.getMoveList().remove((Object)item);
    }

    public void clearMoveList() {
        if (this.getMoveList() != null) {
            this.getMoveList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubrogationRelease)) {
            return false;
        }
        SubrogationRelease other = (SubrogationRelease)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequenceNumber", (Object)this.getSequenceNumber()).add("statusSelect", (Object)this.getStatusSelect()).add("transmissionDate", (Object)this.getTransmissionDate()).add("accountingDate", (Object)this.getAccountingDate()).omitNullValues().toString();
    }
}

