/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db.repo;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.SubrogationRelease;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.SubrogationReleaseRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceManagementRepository
extends InvoiceRepository {
    public Invoice copy(Invoice entity, boolean deep) {
        Invoice copy = (Invoice)((Object)super.copy((Model)((Object)entity), deep));
        InvoiceToolService.resetInvoiceStatusOnCopy(copy);
        return copy;
    }

    public Invoice save(Invoice invoice) {
        try {
            List<InvoicePayment> invoicePayments = invoice.getInvoicePaymentList();
            if (CollectionUtils.isNotEmpty(invoicePayments)) {
                LocalDate latestPaymentDate = invoicePayments.stream().filter(invoicePayment -> invoicePayment.getStatusSelect() == 1).map(InvoicePayment::getPaymentDate).max(LocalDate::compareTo).orElse(null);
                invoice.setPaymentDate(latestPaymentDate);
            }
            invoice = (Invoice)((Object)super.save((Model)((Object)invoice)));
            ((InvoiceService)Beans.get(InvoiceService.class)).setDraftSequence(invoice);
            return invoice;
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        try {
            String subrogationStatusSelect = "$subrogationStatusSelect";
            if (context.get("_model") != null && context.get("_model").toString().equals(SubrogationRelease.class.getName())) {
                if (context.get("id") != null) {
                    long id = (Long)context.get("id");
                    SubrogationRelease subrogationRelease = (SubrogationRelease)((Object)((SubrogationReleaseRepository)((Object)Beans.get(SubrogationReleaseRepository.class))).find(id));
                    if (subrogationRelease != null && subrogationRelease.getStatusSelect() != null) {
                        json.put("$subrogationStatusSelect", subrogationRelease.getStatusSelect());
                    } else {
                        json.put("$subrogationStatusSelect", 1);
                    }
                }
            } else {
                json.put("$subrogationStatusSelect", 1);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return super.populate(json, context);
    }
}

