/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db.repo;

import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.util.List;
import javax.persistence.PersistenceException;

public class MoveLineManagementRepository
extends MoveLineRepository {
    public void remove(MoveLine entity) {
        if (!entity.getMove().getStatusSelect().equals(1)) {
            try {
                throw new AxelorException(4, I18n.get((String)"You can't remove this move %s"), new Object[]{entity.getMove().getReference()});
            }
            catch (AxelorException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        super.remove((Model)((Object)entity));
    }

    public MoveLine save(MoveLine entity) {
        List<AnalyticMoveLine> analyticMoveLineList = entity.getAnalyticMoveLineList();
        if (analyticMoveLineList != null) {
            for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
                analyticMoveLine.setAccount(entity.getAccount());
                analyticMoveLine.setAccountType(entity.getAccount().getAccountType());
            }
        }
        try {
            ((MoveLineService)Beans.get(MoveLineService.class)).validateMoveLine(entity);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        return (MoveLine)((Object)super.save((Model)((Object)entity)));
    }
}

