/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db.repo;

import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.move.MoveSequenceService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.PersistenceException;

public class MoveManagementRepository
extends MoveRepository {
    public Move copy(Move entity, boolean deep) {
        Move copy = (Move)((Object)super.copy((Model)((Object)entity), deep));
        copy.setDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(copy.getCompany()));
        Period period = null;
        try {
            period = ((PeriodService)Beans.get(PeriodService.class)).getActivePeriod(copy.getDate(), entity.getCompany(), 1);
        }
        catch (AxelorException e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
        copy.setStatusSelect(1);
        copy.setReference(null);
        copy.setExportNumber(null);
        copy.setExportDate(null);
        copy.setAccountingReport(null);
        copy.setValidationDate(null);
        copy.setPeriod(period);
        copy.setAccountingOk(false);
        copy.setIgnoreInDebtRecoveryOk(false);
        copy.setPaymentVoucher(null);
        copy.setRejectOk(false);
        copy.setInvoice(null);
        List<MoveLine> moveLineList = copy.getMoveLineList();
        if (moveLineList != null) {
            moveLineList.forEach(moveLine -> this.resetMoveLine((MoveLine)((Object)moveLine), copy.getDate()));
        }
        return copy;
    }

    public void resetMoveLine(MoveLine moveLine, LocalDate date) {
        moveLine.setInvoiceReject(null);
        moveLine.setDate(date);
        moveLine.setExportedDirectDebitOk(false);
        moveLine.setReimbursementStatusSelect(0);
        List<AnalyticMoveLine> analyticMoveLineList = moveLine.getAnalyticMoveLineList();
        if (analyticMoveLineList != null) {
            moveLine.getAnalyticMoveLineList().forEach(line -> line.setDate(moveLine.getDate()));
        }
    }

    public Move save(Move move) {
        try {
            if (move.getStatusSelect() == 2) {
                ((MoveValidateService)Beans.get(MoveValidateService.class)).checkPreconditions(move);
            }
            ((MoveSequenceService)Beans.get(MoveSequenceService.class)).setDraftSequence(move);
            List<MoveLine> moveLineList = move.getMoveLineList();
            if (moveLineList != null) {
                for (MoveLine moveLine : moveLineList) {
                    List<AnalyticMoveLine> analyticMoveLineList = moveLine.getAnalyticMoveLineList();
                    if (analyticMoveLineList == null) continue;
                    for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
                        analyticMoveLine.setAccount(moveLine.getAccount());
                        analyticMoveLine.setAccountType(moveLine.getAccount().getAccountType());
                    }
                }
            }
            return (Move)((Object)super.save((Model)((Object)move)));
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public void remove(Move entity) {
        if (!entity.getStatusSelect().equals(1)) {
            try {
                throw new AxelorException(4, I18n.get((String)"You can't remove this move %s"), new Object[]{entity.getReference()});
            }
            catch (AxelorException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        super.remove((Model)((Object)entity));
    }
}

