/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.FiscalPositionAccountServiceImpl;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.tax.AccountManagementServiceImpl;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.apps.base.service.tax.TaxService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.CallMethod;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountManagementServiceAccountImpl
extends AccountManagementServiceImpl
implements AccountManagementAccountService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public AccountManagementServiceAccountImpl(FiscalPositionService fiscalPositionService, TaxService taxService) {
        super(fiscalPositionService, taxService);
    }

    @Override
    public Account getProductAccount(Product product, Company company, FiscalPosition fiscalPosition, boolean isPurchase, boolean fixedAsset) throws AxelorException {
        this.log.debug("Get the account for the product {} (company : {}, purchase : {}, fixed asset : {}, fiscal position : {})", new Object[]{product != null ? product.getCode() : null, company.getName(), isPurchase, fixedAsset, fiscalPosition != null ? fiscalPosition.getCode() : null});
        Account generalAccount = this.getProductAccount(product, company, isPurchase, fixedAsset, 1);
        Account account = new FiscalPositionAccountServiceImpl().getAccount(fiscalPosition, generalAccount);
        if (account != null) {
            return account;
        }
        throw new AxelorException(4, I18n.get((String)"Accounting configuration is missing for Product: %s (company: %s)"), new Object[]{product != null ? product.getCode() : null, company.getName()});
    }

    @CallMethod
    protected Account getProductAccount(Product product, Company company, boolean isPurchase, boolean fixedAsset, int configObject) {
        AccountManagement accountManagement = this.getAccountManagement(product, company, configObject);
        Account account = null;
        if (accountManagement != null) {
            account = isPurchase ? (fixedAsset ? accountManagement.getPurchFixedAssetsAccount() : accountManagement.getPurchaseAccount()) : accountManagement.getSaleAccount();
        }
        if (account == null && configObject == 1) {
            return this.getProductAccount(product, company, isPurchase, fixedAsset, 2);
        }
        return account;
    }

    @Override
    public AnalyticDistributionTemplate getAnalyticDistributionTemplate(Product product, Company company) {
        return this.getAnalyticDistributionTemplate(product, company, 1);
    }

    protected AnalyticDistributionTemplate getAnalyticDistributionTemplate(Product product, Company company, int configObject) {
        AccountManagement accountManagement = this.getAccountManagement(product, company, configObject);
        AnalyticDistributionTemplate analyticDistributionTemplate = null;
        if (accountManagement != null) {
            analyticDistributionTemplate = accountManagement.getAnalyticDistributionTemplate();
        }
        if (analyticDistributionTemplate == null && configObject == 1) {
            return this.getAnalyticDistributionTemplate(product, company, 2);
        }
        return analyticDistributionTemplate;
    }

    @Override
    public FixedAssetCategory getProductFixedAssetCategory(Product product, Company company) {
        return this.getProductFixedAssetCategory(product, company, 1);
    }

    protected FixedAssetCategory getProductFixedAssetCategory(Product product, Company company, int configObject) {
        AccountManagement accountManagement = this.getAccountManagement(product, company, configObject);
        FixedAssetCategory fixedAssetCategory = null;
        if (accountManagement != null) {
            fixedAssetCategory = accountManagement.getFixedAssetCategory();
        }
        if (fixedAssetCategory == null && configObject == 1) {
            return this.getProductFixedAssetCategory(product, company, 2);
        }
        return fixedAssetCategory;
    }
}

