/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.db.JPA;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Integer BALANCE_TYPE_DEBIT_BALANCE = 1;
    public static final Integer BALANCE_TYPE_CREDIT_BALANCE = 2;
    public static final int MAX_LEVEL_OF_ACCOUNT = 20;
    protected AccountRepository accountRepository;

    @Inject
    public AccountService(AccountRepository accountRepository) {
        this.accountRepository = accountRepository;
    }

    public BigDecimal computeBalance(Account account, int balanceType) {
        Query balanceQuery = JPA.em().createQuery("select sum(self.debit - self.credit) from MoveLine self where self.account = :account and self.move.ignoreInAccountingOk IN ('false', null) and self.move.statusSelect IN (2, 3)");
        balanceQuery.setParameter("account", (Object)account);
        BigDecimal balance = (BigDecimal)balanceQuery.getSingleResult();
        if (balance != null) {
            if (balanceType == BALANCE_TYPE_CREDIT_BALANCE) {
                balance = balance.negate();
            }
            this.log.debug("Account balance : {}", (Object)balance);
            return balance;
        }
        return BigDecimal.ZERO;
    }

    public List<Long> getAllAccountsSubAccountIncluded(List<Long> accountList) {
        return this.getAllAccountsSubAccountIncluded(accountList, 0);
    }

    public List<Long> getAllAccountsSubAccountIncluded(List<Long> accountList, int counter) {
        if (counter > 20) {
            return new ArrayList<Long>();
        }
        ++counter;
        ArrayList<Long> allAccountsSubAccountIncluded = new ArrayList<Long>();
        if (accountList != null && !accountList.isEmpty()) {
            allAccountsSubAccountIncluded.addAll(accountList);
            for (Long accountId : accountList) {
                allAccountsSubAccountIncluded.addAll(this.getAllAccountsSubAccountIncluded(this.getSubAccounts(accountId), counter));
            }
        }
        return allAccountsSubAccountIncluded;
    }

    public List<Long> getSubAccounts(Long accountId) {
        return this.accountRepository.all().filter("self.parentAccount.id = ?1", new Object[]{accountId}).select(new String[]{"id"}).fetch(0, 0).stream().map(m -> (Long)m.get("id")).collect(Collectors.toList());
    }
}

