/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountType;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.AccountingSituationRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AccountingSituationServiceImpl
implements AccountingSituationService {
    protected AccountConfigService accountConfigService;
    protected SequenceService sequenceService;
    protected AccountingSituationRepository accountingSituationRepo;

    @Inject
    public AccountingSituationServiceImpl(AccountConfigService accountConfigService, SequenceService sequenceService, AccountingSituationRepository accountingSituationRepo) {
        this.accountConfigService = accountConfigService;
        this.sequenceService = sequenceService;
        this.accountingSituationRepo = accountingSituationRepo;
    }

    @Override
    public boolean checkAccountingSituationList(List<AccountingSituation> accountingSituationList, Company company) {
        if (accountingSituationList != null) {
            for (AccountingSituation accountingSituation : accountingSituationList) {
                if (!accountingSituation.getCompany().equals((Object)company)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public List<AccountingSituation> createAccountingSituation(Partner partner) throws AxelorException {
        Set<Company> companySet = partner.getCompanySet();
        if (companySet != null) {
            for (Company company : companySet) {
                if (this.checkAccountingSituationList(partner.getAccountingSituationList(), company)) continue;
                this.createAccountingSituation(partner, company);
            }
        }
        return partner.getAccountingSituationList();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public AccountingSituation createAccountingSituation(Partner partner, Company company) throws AxelorException {
        List<BankDetails> authorizedOutBankDetails;
        List<BankDetails> authorizedInBankDetails;
        AccountingSituation accountingSituation = new AccountingSituation();
        accountingSituation.setCompany(company);
        partner.addCompanySetItem(company);
        PaymentMode inPaymentMode = partner.getInPaymentMode();
        PaymentMode outPaymentMode = partner.getOutPaymentMode();
        BankDetails defaultBankDetails = company.getDefaultBankDetails();
        if (inPaymentMode != null && (authorizedInBankDetails = ((PaymentModeService)Beans.get(PaymentModeService.class)).getCompatibleBankDetailsList(inPaymentMode, company)).contains((Object)defaultBankDetails)) {
            accountingSituation.setCompanyInBankDetails(defaultBankDetails);
        }
        if (outPaymentMode != null && (authorizedOutBankDetails = ((PaymentModeService)Beans.get(PaymentModeService.class)).getCompatibleBankDetailsList(outPaymentMode, company)).contains((Object)defaultBankDetails)) {
            accountingSituation.setCompanyOutBankDetails(defaultBankDetails);
        }
        AccountConfig accountConfig = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(company);
        accountingSituation.setInvoiceAutomaticMail(accountConfig.getInvoiceAutomaticMail());
        accountingSituation.setInvoiceMessageTemplate(accountConfig.getInvoiceMessageTemplate());
        partner.addAccountingSituationListItem(accountingSituation);
        return (AccountingSituation)((Object)this.accountingSituationRepo.save((Model)((Object)accountingSituation)));
    }

    @Override
    public AccountingSituation getAccountingSituation(Partner partner, Company company) {
        if (partner == null || partner.getAccountingSituationList() == null) {
            return null;
        }
        for (AccountingSituation accountingSituation : partner.getAccountingSituationList()) {
            if (accountingSituation.getCompany() == null || !accountingSituation.getCompany().equals((Object)company)) continue;
            return accountingSituation;
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void createPartnerAccounts(AccountingSituation situation) throws AxelorException {
        int creationMode;
        AccountConfig accountConfig = situation.getCompany().getAccountConfig();
        if (accountConfig == null || (creationMode = accountConfig.getPartnerAccountGenerationModeSelect().intValue()) == 0) {
            return;
        }
        this.createCustomerAccount(accountConfig, situation, creationMode);
        this.createSupplierAccount(accountConfig, situation, creationMode);
        this.createEmployeeAccount(accountConfig, situation, creationMode);
    }

    protected void createCustomerAccount(AccountConfig accountConfig, AccountingSituation situation, int creationMode) throws AxelorException {
        String accountCode;
        Partner partner = situation.getPartner();
        if (partner.getIsCustomer() == Boolean.FALSE || situation.getCustomerAccount() != null) {
            return;
        }
        if (accountConfig.getCustomerAccount() == null) {
            throw new AxelorException((Model)((Object)partner), 1, I18n.get((String)"%s : A customer account is missing for the company %s"), new Object[]{I18n.get((String)"Warning !"), situation.getCompany().getName()});
        }
        if (creationMode == 1) {
            String prefix = accountConfig.getCustomerAccountPrefix();
            if (StringUtils.isBlank((CharSequence)prefix)) {
                throw new AxelorException((Model)((Object)situation), 1, I18n.get((String)"You have to enter a prefix for automatic customer account creation in accounting application parameters of company %s"), new Object[]{situation.getCompany().getName()});
            }
            accountCode = this.getPrefixedAccountCode(prefix, partner);
        } else if (creationMode == 2) {
            Sequence sequence = accountConfig.getCustomerAccountSequence();
            if (sequence == null) {
                throw new AxelorException((Model)((Object)situation), 1, I18n.get((String)"You have to select a sequence for automatic customer account creation in accounting application parameters of company %s"), new Object[]{situation.getCompany().getName()});
            }
            accountCode = this.sequenceService.getSequenceNumber(sequence);
        } else {
            throw new AxelorException((Model)((Object)situation), 5, I18n.get((String)"Invalid automatic partner account creation mode, this is a bug that should be reported."), new Object[]{situation.getCompany().getName()});
        }
        Account account = this.createAccount(partner.getFullName(), accountCode, accountConfig.getCustomerAccount(), accountConfig.getCustomerAccount().getAccountType(), true, situation.getCompany(), true);
        situation.setCustomerAccount(account);
    }

    protected void createSupplierAccount(AccountConfig accountConfig, AccountingSituation situation, int creationMode) throws AxelorException {
        String accountCode;
        Partner partner = situation.getPartner();
        if (partner.getIsSupplier() == Boolean.FALSE || situation.getSupplierAccount() != null) {
            return;
        }
        if (accountConfig.getSupplierAccount() == null) {
            throw new AxelorException((Model)((Object)partner), 1, I18n.get((String)"%s : A supplier account is missing for the company %s"), new Object[]{I18n.get((String)"Warning !"), situation.getCompany().getName()});
        }
        if (creationMode == 1) {
            String prefix = accountConfig.getSupplierAccountPrefix();
            if (StringUtils.isBlank((CharSequence)prefix)) {
                throw new AxelorException((Model)((Object)situation), 1, I18n.get((String)"You have to enter a prefix for automatic supplier account creation in accounting application parameters of company %s"), new Object[]{situation.getCompany().getName()});
            }
            accountCode = this.getPrefixedAccountCode(prefix, partner);
        } else if (creationMode == 2) {
            Sequence sequence = accountConfig.getSupplierAccountSequence();
            if (sequence == null) {
                throw new AxelorException((Model)((Object)situation), 1, I18n.get((String)"You have to select a sequence for automatic supplier account creation in accounting application parameters of company %s"), new Object[]{situation.getCompany().getName()});
            }
            accountCode = this.sequenceService.getSequenceNumber(sequence);
        } else {
            throw new AxelorException((Model)((Object)situation), 5, I18n.get((String)"Invalid automatic partner account creation mode, this is a bug that should be reported."), new Object[]{situation.getCompany().getName()});
        }
        Account account = this.createAccount(partner.getFullName(), accountCode, accountConfig.getSupplierAccount(), accountConfig.getSupplierAccount().getAccountType(), true, situation.getCompany(), true);
        situation.setSupplierAccount(account);
    }

    protected void createEmployeeAccount(AccountConfig accountConfig, AccountingSituation situation, int creationMode) throws AxelorException {
        String accountCode;
        Partner partner = situation.getPartner();
        if (partner.getIsEmployee() == Boolean.FALSE || situation.getEmployeeAccount() != null) {
            return;
        }
        if (accountConfig.getEmployeeAccount() == null) {
            throw new AxelorException((Model)((Object)partner), 1, I18n.get((String)"%s : You must configure an employee account for the company %s"), new Object[]{I18n.get((String)"Warning !"), situation.getCompany().getName()});
        }
        if (creationMode == 1) {
            String prefix = accountConfig.getEmployeeAccountPrefix();
            if (StringUtils.isBlank((CharSequence)prefix)) {
                throw new AxelorException((Model)((Object)situation), 1, I18n.get((String)"You have to enter a prefix for automatic employee account creation in accounting application parameters of company %s"), new Object[]{situation.getCompany().getName()});
            }
            accountCode = this.getPrefixedAccountCode(prefix, partner);
        } else if (creationMode == 2) {
            Sequence sequence = accountConfig.getEmployeeAccountSequence();
            if (sequence == null) {
                throw new AxelorException((Model)((Object)situation), 1, I18n.get((String)"You have to select a sequence for automatic employee account creation in accounting application parameters of company %s"), new Object[]{situation.getCompany().getName()});
            }
            accountCode = this.sequenceService.getSequenceNumber(sequence);
        } else {
            throw new AxelorException((Model)((Object)situation), 5, I18n.get((String)"Invalid automatic partner account creation mode, this is a bug that should be reported."), new Object[]{situation.getCompany().getName()});
        }
        Account account = this.createAccount(partner.getFullName(), accountCode, accountConfig.getEmployeeAccount(), accountConfig.getEmployeeAccount().getAccountType(), true, situation.getCompany(), true);
        situation.setEmployeeAccount(account);
    }

    protected String getPrefixedAccountCode(String prefix, Partner partner) {
        return (prefix + StringUtils.stripAccent((CharSequence)partner.getFullName())).toUpperCase().replaceAll("[^A-Z0-9]", "");
    }

    @Override
    public String createDomainForBankDetails(AccountingSituation accountingSituation, boolean isInBankDetails) {
        String domain = "";
        if (accountingSituation.getPartner() != null) {
            List<BankDetails> authorizedBankDetails = isInBankDetails ? ((PaymentModeService)Beans.get(PaymentModeService.class)).getCompatibleBankDetailsList(accountingSituation.getPartner().getInPaymentMode(), accountingSituation.getCompany()) : ((PaymentModeService)Beans.get(PaymentModeService.class)).getCompatibleBankDetailsList(accountingSituation.getPartner().getOutPaymentMode(), accountingSituation.getCompany());
            String idList = StringTool.getIdListString(authorizedBankDetails);
            if (idList.equals("")) {
                return domain;
            }
            domain = "self.id IN (" + idList + ") AND self.active = true";
        }
        return domain;
    }

    @Override
    public void updateCustomerCredit(Partner partner) throws AxelorException {
    }

    @Override
    public Account getCustomerAccount(Partner partner, Company company) throws AxelorException {
        Account account = null;
        AccountingSituation accountingSituation = this.getAccountingSituation(partner, company);
        if (accountingSituation != null) {
            account = accountingSituation.getCustomerAccount();
        }
        if (account == null) {
            AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
            account = this.accountConfigService.getCustomerAccount(accountConfig);
        }
        return account;
    }

    @Override
    public Account getSupplierAccount(Partner partner, Company company) throws AxelorException {
        Account account = null;
        AccountingSituation accountingSituation = this.getAccountingSituation(partner, company);
        if (accountingSituation != null) {
            account = accountingSituation.getSupplierAccount();
        }
        if (account == null) {
            AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
            account = this.accountConfigService.getSupplierAccount(accountConfig);
        }
        return account;
    }

    @Override
    public Account getEmployeeAccount(Partner partner, Company company) throws AxelorException {
        Account account = null;
        AccountingSituation accountingSituation = this.getAccountingSituation(partner, company);
        if (accountingSituation != null) {
            account = accountingSituation.getEmployeeAccount();
        }
        if (account == null) {
            AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
            account = this.accountConfigService.getEmployeeAccount(accountConfig);
        }
        return account;
    }

    @Override
    public BankDetails getCompanySalesBankDetails(Company company, Partner partner) {
        AccountingSituation situation = this.getAccountingSituation(partner, company);
        if (situation != null && situation.getCompanyInBankDetails() != null && situation.getCompanyInBankDetails().getActive().booleanValue()) {
            return situation.getCompanyInBankDetails();
        }
        return company.getDefaultBankDetails();
    }

    protected Account createAccount(String fullName, String accountCode, Account parentAccount, AccountType accountType, boolean reconcileOk, Company company, boolean useForPartnerBalance) {
        Account account = new Account();
        account.setName(fullName);
        account.setCode(accountCode);
        account.setParentAccount(parentAccount);
        account.setAccountType(accountType);
        account.setReconcileOk(reconcileOk);
        account.setCompany(company);
        account.setUseForPartnerBalance(useForPartnerBalance);
        account.setCompatibleAccountSet(new HashSet<Account>());
        return account;
    }
}

