/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BankDetailsServiceImpl;
import com.axelor.apps.tool.StringTool;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BankDetailsServiceAccountImpl
extends BankDetailsServiceImpl {
    public String createCompanyBankDetailsDomain(Partner partner, Company company, PaymentMode paymentMode, Integer operationTypeSelect) throws AxelorException {
        AppAccountService appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        if (!appAccountService.isApp("account") || !appAccountService.getAppBase().getManageMultiBanks().booleanValue()) {
            return super.createCompanyBankDetailsDomain(partner, company, paymentMode, operationTypeSelect);
        }
        if (partner != null) {
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        }
        List<Object> authorizedBankDetails = new ArrayList();
        if (partner != null && partner.getFactorizedCustomer().booleanValue() && operationTypeSelect != null && (operationTypeSelect == 3 || operationTypeSelect == 4)) {
            authorizedBankDetails = this.createCompanyBankDetailsDomainFromFactorPartner(company);
        } else {
            if (paymentMode == null) {
                return "self.id IN (0)";
            }
            List<AccountManagement> accountManagementList = paymentMode.getAccountManagementList();
            authorizedBankDetails = new ArrayList();
            for (AccountManagement accountManagement : accountManagementList) {
                if (accountManagement.getCompany() == null || !accountManagement.getCompany().equals((Object)company)) continue;
                authorizedBankDetails.add((Object)accountManagement.getBankDetails());
            }
        }
        if (authorizedBankDetails.isEmpty()) {
            return "self.id IN (0)";
        }
        return "self.id IN (" + StringTool.getIdListString(authorizedBankDetails) + ") AND self.active = true";
    }

    private List<BankDetails> createCompanyBankDetailsDomainFromFactorPartner(Company company) throws AxelorException {
        AccountConfig accountConfig = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(company);
        List<BankDetails> bankDetailsList = accountConfig.getFactorPartner().getBankDetailsList();
        return bankDetailsList.stream().filter(bankDetails -> bankDetails.getActive()).collect(Collectors.toList());
    }

    public BankDetails getDefaultCompanyBankDetails(Company company, PaymentMode paymentMode, Partner partner, Integer operationTypeSelect) throws AxelorException {
        AppAccountService appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        if (!appAccountService.isApp("account") || !appAccountService.getAppBase().getManageMultiBanks().booleanValue()) {
            return super.getDefaultCompanyBankDetails(company, paymentMode, partner, operationTypeSelect);
        }
        if (partner != null && partner.getFactorizedCustomer().booleanValue() && operationTypeSelect != null && (operationTypeSelect == 3 || operationTypeSelect == 4)) {
            return this.getDefaultCompanyBankDetailsFromFactorPartner(company);
        }
        if (paymentMode == null) {
            return null;
        }
        BankDetails candidateBankDetails = this.getDefaultCompanyBankDetailsFromPartner(company, paymentMode, partner);
        List<BankDetails> authorizedBankDetails = ((PaymentModeService)Beans.get(PaymentModeService.class)).getCompatibleBankDetailsList(paymentMode, company);
        if (candidateBankDetails != null && authorizedBankDetails.contains((Object)candidateBankDetails) && candidateBankDetails.getActive().booleanValue()) {
            return candidateBankDetails;
        }
        if (authorizedBankDetails.size() == 1) {
            return authorizedBankDetails.get(0);
        }
        return null;
    }

    private BankDetails getDefaultCompanyBankDetailsFromFactorPartner(Company company) throws AxelorException {
        AccountConfig accountConfig = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(company);
        if (accountConfig.getFactorPartner() == null) {
            return null;
        }
        List<BankDetails> bankDetailsList = accountConfig.getFactorPartner().getBankDetailsList();
        return bankDetailsList.stream().filter(bankDetails -> bankDetails.getIsDefault()).findFirst().orElse(null);
    }

    protected BankDetails getDefaultCompanyBankDetailsFromPartner(Company company, PaymentMode paymentMode, Partner partner) {
        if (partner == null) {
            return null;
        }
        AccountingSituation accountingSituation = ((AccountingSituationService)Beans.get(AccountingSituationService.class)).getAccountingSituation(partner, company);
        if (accountingSituation == null) {
            return null;
        }
        BankDetails candidateBankDetails = null;
        if (paymentMode.getInOutSelect() == 1) {
            candidateBankDetails = accountingSituation.getCompanyInBankDetails();
        } else if (paymentMode.getInOutSelect() == 2) {
            candidateBankDetails = accountingSituation.getCompanyOutBankDetails();
        }
        return candidateBankDetails;
    }
}

