/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.BudgetLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.repo.BudgetDistributionRepository;
import com.axelor.apps.account.db.repo.BudgetLineRepository;
import com.axelor.apps.account.db.repo.BudgetRepository;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BudgetService {
    protected BudgetLineRepository budgetLineRepository;
    protected BudgetRepository budgetRepository;

    @Inject
    public BudgetService(BudgetLineRepository budgetLineRepository, BudgetRepository budgetRepository) {
        this.budgetLineRepository = budgetLineRepository;
        this.budgetRepository = budgetRepository;
    }

    public BigDecimal compute(Budget budget) {
        BigDecimal total = BigDecimal.ZERO;
        if (budget.getBudgetLineList() != null) {
            for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                total = total.add(budgetLine.getAmountExpected());
            }
        }
        return total;
    }

    @Transactional
    public BigDecimal computeTotalAmountRealized(Budget budget) {
        List<BudgetLine> budgetLineList = budget.getBudgetLineList();
        if (budgetLineList == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalAmountRealized = budgetLineList.stream().map(BudgetLine::getAmountRealized).reduce(BigDecimal.ZERO, BigDecimal::add);
        budget.setTotalAmountRealized(totalAmountRealized);
        return totalAmountRealized;
    }

    @Transactional
    public List<BudgetLine> updateLines(Budget budget) {
        if (budget.getBudgetLineList() != null && !budget.getBudgetLineList().isEmpty()) {
            for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                budgetLine.setAmountRealized(BigDecimal.ZERO);
            }
            List budgetDistributionList = ((BudgetDistributionRepository)((Object)Beans.get(BudgetDistributionRepository.class))).all().filter("self.budget.id = ?1 AND (self.invoiceLine.invoice.statusSelect = ?2 OR self.invoiceLine.invoice.statusSelect = ?3)", new Object[]{budget.getId(), 2, 3}).fetch();
            for (BudgetDistribution budgetDistribution : budgetDistributionList) {
                Optional<LocalDate> optionaldate = this.getDate(budgetDistribution);
                optionaldate.ifPresent(date -> {
                    for (BudgetLine budgetLine : budget.getBudgetLineList()) {
                        LocalDate fromDate = budgetLine.getFromDate();
                        LocalDate toDate = budgetLine.getToDate();
                        if (fromDate == null || toDate == null || !fromDate.isBefore((ChronoLocalDate)date) && !fromDate.isEqual((ChronoLocalDate)date) || !toDate.isAfter((ChronoLocalDate)date) && !toDate.isEqual((ChronoLocalDate)date)) continue;
                        budgetLine.setAmountRealized(budgetLine.getAmountRealized().add(budgetDistribution.getAmount()));
                        break;
                    }
                });
            }
        }
        return budget.getBudgetLineList();
    }

    protected Optional<LocalDate> getDate(BudgetDistribution budgetDistribution) {
        Invoice invoice = budgetDistribution.getInvoiceLine().getInvoice();
        LocalDate invoiceDate = invoice.getInvoiceDate();
        if (invoiceDate != null) {
            return Optional.of(invoiceDate);
        }
        return Optional.of(invoice.getValidatedDate());
    }

    public List<BudgetLine> generatePeriods(Budget budget) throws AxelorException {
        List<Object> budgetLineList;
        if (budget.getBudgetLineList() != null && !budget.getBudgetLineList().isEmpty()) {
            budgetLineList = budget.getBudgetLineList();
            budgetLineList.clear();
        }
        budgetLineList = new ArrayList();
        Integer duration = budget.getPeriodDurationSelect();
        LocalDate fromDate = budget.getFromDate();
        LocalDate toDate = budget.getToDate();
        LocalDate budgetLineToDate = fromDate;
        Integer budgetLineNumber = 1;
        int c = 0;
        int loopLimit = 1000;
        while (budgetLineToDate.isBefore(toDate)) {
            if (budgetLineNumber != 1 && duration != 0) {
                fromDate = fromDate.plusMonths(duration.intValue());
            }
            if (c >= loopLimit) {
                throw new AxelorException(5, I18n.get((String)"Too much iterations."));
            }
            ++c;
            LocalDate localDate = budgetLineToDate = duration == 0 ? toDate : fromDate.plusMonths(duration.intValue()).minusDays(1L);
            if (budgetLineToDate.isAfter(toDate)) {
                budgetLineToDate = toDate;
            }
            if (fromDate.isAfter(toDate)) continue;
            BudgetLine budgetLine = new BudgetLine();
            budgetLine.setFromDate(fromDate);
            budgetLine.setToDate(budgetLineToDate);
            budgetLine.setBudget(budget);
            budgetLine.setAmountExpected(budget.getAmountForGeneration());
            budgetLineList.add((Object)budgetLine);
            Integer n = budgetLineNumber;
            Integer n2 = budgetLineNumber = Integer.valueOf(budgetLineNumber + 1);
            if (duration != 0) continue;
            break;
        }
        return budgetLineList;
    }

    public void checkSharedDates(Budget budget) throws AxelorException {
        if (budget.getBudgetLineList() == null) {
            return;
        }
        List<BudgetLine> budgetLineList = budget.getBudgetLineList();
        for (int i = 0; i < budgetLineList.size() - 1; ++i) {
            BudgetLine budgetLineA = budgetLineList.get(i);
            LocalDate fromDateA = budgetLineA.getFromDate();
            LocalDate toDateA = budgetLineA.getToDate();
            for (int j = i + 1; j < budgetLineList.size(); ++j) {
                BudgetLine budgetLineB = budgetLineList.get(j);
                LocalDate fromDateB = budgetLineB.getFromDate();
                LocalDate toDateB = budgetLineB.getToDate();
                if (fromDateA.equals(fromDateB) || toDateA.equals(toDateB)) {
                    throw new AxelorException(5, I18n.get((String)"Two or more budget lines share dates"));
                }
                if (fromDateA.isBefore(fromDateB) && !toDateA.isBefore(fromDateB)) {
                    throw new AxelorException(5, I18n.get((String)"Two or more budget lines share dates"));
                }
                if (!fromDateA.isAfter(fromDateB) || fromDateA.isAfter(toDateB)) continue;
                throw new AxelorException(5, I18n.get((String)"Two or more budget lines share dates"));
            }
        }
    }

    @Transactional
    public void validate(Budget budget) {
        budget.setStatusSelect(2);
    }

    @Transactional
    public void draft(Budget budget) {
        budget.setStatusSelect(1);
    }

    public void updateBudgetLinesFromInvoice(Invoice invoice) {
        List<InvoiceLine> invoiceLineList = invoice.getInvoiceLineList();
        if (invoiceLineList == null) {
            return;
        }
        invoiceLineList.stream().filter(invoiceLine -> invoiceLine.getBudgetDistributionList() != null).flatMap(x -> x.getBudgetDistributionList().stream()).forEach(budgetDistribution -> {
            Budget budget = budgetDistribution.getBudget();
            this.updateLines(budget);
            this.computeTotalAmountRealized(budget);
        });
    }
}

