/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.DepositSlip;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.service.DepositSlipService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherConfirmService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.QueryBuilder;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;

public class DepositSlipServiceImpl
implements DepositSlipService {
    @Override
    @Transactional(rollbackOn={Exception.class})
    public void loadPayments(DepositSlip depositSlip) throws AxelorException {
        if (depositSlip.getPublicationDate() != null) {
            throw new AxelorException((Model)((Object)depositSlip), 4, I18n.get((String)"The deposit slip has already been published."));
        }
        depositSlip.clearPaymentVoucherList();
        this.fetchPaymentVouchers(depositSlip).forEach(depositSlip::addPaymentVoucherListItem);
        this.compute(depositSlip);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public String publish(DepositSlip depositSlip) throws AxelorException {
        this.confirmPayments(depositSlip);
        ReportSettings settings = ReportFactory.createReport((String)this.getReportName(depositSlip), (String)this.getFilename(depositSlip));
        settings.addParam("DepositSlipId", (Object)depositSlip.getId());
        settings.addParam("Locale", (Object)ReportSettings.getPrintingLocale(null));
        settings.addParam("Timezone", depositSlip.getCompany() != null ? depositSlip.getCompany().getTimezone() : null);
        settings.addFormat("pdf");
        String fileLink = settings.toAttach((Model)((Object)depositSlip)).generate().getFileLink();
        depositSlip.setPublicationDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(depositSlip.getCompany()));
        return fileLink;
    }

    @Override
    public String getFilename(DepositSlip depositSlip) throws AxelorException {
        String name;
        switch (depositSlip.getPaymentModeTypeSelect()) {
            case 7: {
                name = I18n.get((String)"Cheque deposit slip");
                break;
            }
            case 5: {
                name = I18n.get((String)"Cash deposit slip");
                break;
            }
            default: {
                throw new AxelorException((Model)((Object)depositSlip), 4, "Unsupported payment mode type");
            }
        }
        return String.format("%s - %s", name, depositSlip.getDepositNumber());
    }

    private String getReportName(DepositSlip depositSlip) throws AxelorException {
        switch (depositSlip.getPaymentModeTypeSelect()) {
            case 7: {
                return "ChequeDepositSlip.rptdesign";
            }
            case 5: {
                return "CashDepositSlip.rptdesign";
            }
        }
        throw new AxelorException((Model)((Object)depositSlip), 4, "Unsupported payment mode type");
    }

    private void compute(DepositSlip depositSlip) {
        if (depositSlip.getPaymentVoucherList() != null) {
            List<PaymentVoucher> paymentVoucherList = depositSlip.getPaymentVoucherList();
            BigDecimal totalAmount = paymentVoucherList.stream().map(PaymentVoucher::getPaidAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            depositSlip.setTotalAmount(totalAmount);
            depositSlip.setChequeCount(paymentVoucherList.size());
        }
    }

    private List<PaymentVoucher> fetchPaymentVouchers(DepositSlip depositSlip) {
        QueryBuilder queryBuilder = QueryBuilder.of(PaymentVoucher.class);
        if (depositSlip.getPaymentModeTypeSelect() != 0) {
            queryBuilder.add("self.paymentMode.typeSelect = :paymentModeTypeSelect");
            queryBuilder.bind("paymentModeTypeSelect", (Object)depositSlip.getPaymentModeTypeSelect());
        }
        if (depositSlip.getCompany() != null) {
            queryBuilder.add("self.company = :company");
            queryBuilder.bind("company", (Object)depositSlip.getCompany());
        }
        if (depositSlip.getCurrency() != null) {
            queryBuilder.add("self.currency = :currency");
            queryBuilder.bind("currency", (Object)depositSlip.getCurrency());
        }
        if (depositSlip.getCompanyBankDetails() != null && ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getManageMultiBanks().booleanValue()) {
            queryBuilder.add("self.companyBankDetails = :companyBankDetails");
            queryBuilder.bind("companyBankDetails", (Object)depositSlip.getCompanyBankDetails());
        }
        if (depositSlip.getFromDate() != null) {
            if (depositSlip.getToDate() != null) {
                queryBuilder.add("self.chequeDate IS NULL OR self.chequeDate BETWEEN :fromDate AND :toDate");
                queryBuilder.bind("fromDate", (Object)depositSlip.getFromDate());
                queryBuilder.bind("toDate", (Object)depositSlip.getToDate());
            } else {
                queryBuilder.add("self.chequeDate IS NULL OR self.chequeDate >= :fromDate");
                queryBuilder.bind("fromDate", (Object)depositSlip.getFromDate());
            }
        } else if (depositSlip.getToDate() != null) {
            queryBuilder.add("self.chequeDate IS NULL OR self.chequeDate <= :toDate");
            queryBuilder.bind("toDate", (Object)depositSlip.getToDate());
        }
        queryBuilder.add("self.depositSlip IS NULL");
        queryBuilder.add("self.statusSelect = :statusSelect");
        queryBuilder.bind("statusSelect", (Object)2);
        return queryBuilder.build().fetch();
    }

    private void confirmPayments(DepositSlip depositSlip) throws AxelorException {
        if (depositSlip.getPaymentVoucherList() != null) {
            PaymentVoucherConfirmService paymentVoucherConfirmService = (PaymentVoucherConfirmService)Beans.get(PaymentVoucherConfirmService.class);
            for (PaymentVoucher paymentVoucher : depositSlip.getPaymentVoucherList()) {
                paymentVoucherConfirmService.createMoveAndConfirm(paymentVoucher);
            }
        }
    }
}

