/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FixedAsset;
import com.axelor.apps.account.db.FixedAssetLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.FixedAssetLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.FixedAssetLineService;
import com.axelor.apps.account.service.move.MoveCreateService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAssetLineServiceImpl
implements FixedAssetLineService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private FixedAssetLineRepository fixedAssetLineRepo;
    @Inject
    private MoveCreateService moveCreateService;
    @Inject
    private MoveRepository moveRepo;
    protected MoveLineService moveLineService;

    @Inject
    public FixedAssetLineServiceImpl(MoveLineService moveLineService) {
        this.moveLineService = moveLineService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void realize(FixedAssetLine fixedAssetLine) throws AxelorException {
        this.generateMove(fixedAssetLine);
        fixedAssetLine.setStatusSelect(2);
        FixedAsset fixedAsset = fixedAssetLine.getFixedAsset();
        BigDecimal residualValue = fixedAsset.getResidualValue();
        fixedAsset.setResidualValue(residualValue.subtract(fixedAssetLine.getDepreciation()));
        FixedAssetLine plannedFixedAssetLine = fixedAsset.getFixedAssetLineList().stream().filter(line -> line.getStatusSelect() == 1).findAny().orElse(null);
        if (plannedFixedAssetLine == null && fixedAsset.getDisposalValue().compareTo(BigDecimal.ZERO) == 0) {
            fixedAsset.setStatusSelect(3);
        }
        this.fixedAssetLineRepo.save((Model)((Object)fixedAssetLine));
    }

    @Transactional(rollbackOn={Exception.class})
    private void generateMove(FixedAssetLine fixedAssetLine) throws AxelorException {
        FixedAsset fixedAsset = fixedAssetLine.getFixedAsset();
        Journal journal = fixedAsset.getJournal();
        Company company = fixedAsset.getCompany();
        Partner partner = fixedAsset.getPartner();
        LocalDate date = fixedAssetLine.getDepreciationDate();
        this.log.debug("Creating an fixed asset line specific accounting entry {} (Company : {}, Journal : {})", new Object[]{fixedAsset.getReference(), company.getName(), journal.getCode()});
        Move move = this.moveCreateService.createMove(journal, company, company.getCurrency(), partner, date, null, 2);
        if (move != null) {
            ArrayList<MoveLine> moveLines = new ArrayList<MoveLine>();
            String origin = fixedAsset.getReference();
            Account debitLineAccount = fixedAsset.getFixedAssetCategory().getChargeAccount();
            Account creditLineAccount = fixedAsset.getFixedAssetCategory().getDepreciationAccount();
            BigDecimal amount = fixedAssetLine.getDepreciation();
            MoveLine debitMoveLine = new MoveLine(move, partner, debitLineAccount, date, null, 1, amount, BigDecimal.ZERO, fixedAsset.getName(), origin, null, BigDecimal.ZERO, date);
            moveLines.add(debitMoveLine);
            this.addAnalyticToMoveLine(fixedAsset.getAnalyticDistributionTemplate(), debitMoveLine);
            MoveLine creditMoveLine = new MoveLine(move, partner, creditLineAccount, date, null, 2, BigDecimal.ZERO, amount, fixedAsset.getName(), origin, null, BigDecimal.ZERO, date);
            moveLines.add(creditMoveLine);
            this.addAnalyticToMoveLine(fixedAsset.getAnalyticDistributionTemplate(), creditMoveLine);
            move.getMoveLineList().addAll(moveLines);
        }
        this.moveRepo.save((Model)((Object)move));
        fixedAssetLine.setDepreciationAccountMove(move);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void generateDisposalMove(FixedAssetLine fixedAssetLine) throws AxelorException {
        FixedAsset fixedAsset = fixedAssetLine.getFixedAsset();
        Journal journal = fixedAsset.getJournal();
        Company company = fixedAsset.getCompany();
        Partner partner = fixedAsset.getPartner();
        LocalDate date = fixedAssetLine.getDepreciationDate();
        Move move = this.moveCreateService.createMove(journal, company, company.getCurrency(), partner, date, null, 2);
        if (move != null) {
            ArrayList<MoveLine> moveLines = new ArrayList<MoveLine>();
            String origin = fixedAsset.getReference();
            Account chargeAccount = fixedAsset.getFixedAssetCategory().getChargeAccount();
            Account depreciationAccount = fixedAsset.getFixedAssetCategory().getDepreciationAccount();
            Account purchaseAccount = fixedAsset.getPurchaseAccount();
            BigDecimal chargeAmount = fixedAssetLine.getResidualValue();
            BigDecimal cumulativeDepreciationAmount = fixedAssetLine.getCumulativeDepreciation();
            MoveLine chargeAccountDebitMoveLine = new MoveLine(move, partner, chargeAccount, date, null, 1, chargeAmount, BigDecimal.ZERO, fixedAsset.getName(), origin, null, BigDecimal.ZERO, date);
            moveLines.add(chargeAccountDebitMoveLine);
            this.addAnalyticToMoveLine(fixedAsset.getAnalyticDistributionTemplate(), chargeAccountDebitMoveLine);
            MoveLine deprecationAccountDebitMoveLine = new MoveLine(move, partner, depreciationAccount, date, null, 1, cumulativeDepreciationAmount, BigDecimal.ZERO, fixedAsset.getName(), origin, null, BigDecimal.ZERO, date);
            moveLines.add(deprecationAccountDebitMoveLine);
            this.addAnalyticToMoveLine(fixedAsset.getAnalyticDistributionTemplate(), deprecationAccountDebitMoveLine);
            MoveLine creditMoveLine = new MoveLine(move, partner, purchaseAccount, date, null, 2, BigDecimal.ZERO, fixedAsset.getGrossValue(), fixedAsset.getName(), origin, null, BigDecimal.ZERO, date);
            moveLines.add(creditMoveLine);
            this.addAnalyticToMoveLine(fixedAsset.getAnalyticDistributionTemplate(), creditMoveLine);
            move.getMoveLineList().addAll(moveLines);
        }
        this.moveRepo.save((Model)((Object)move));
        fixedAsset.setDisposalMove(move);
    }

    @Transactional
    protected void addAnalyticToMoveLine(AnalyticDistributionTemplate analyticDistributionTemplate, MoveLine moveLine) {
        if (analyticDistributionTemplate != null && moveLine.getAccount().getAnalyticDistributionAuthorized().booleanValue()) {
            moveLine.setAnalyticDistributionTemplate(analyticDistributionTemplate);
            this.moveLineService.computeAnalyticDistribution(moveLine);
        }
    }
}

