/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Journal;
import com.axelor.db.JPA;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Query;

public class JournalService {
    public Map<String, BigDecimal> computeBalance(Journal journal) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        String query = "select sum(self.debit),sum(self.credit) from MoveLine self where self.move.journal.id = :journal and self.move.ignoreInAccountingOk IN ('false', null) and self.move.statusSelect IN (:statusDaybook, :statusValidated) and self.account.accountType MEMBER OF self.move.journal.journalType.accountTypeSet";
        Query resultQuery = JPA.em().createQuery(query);
        resultQuery.setParameter("journal", (Object)journal.getId());
        resultQuery.setParameter("statusDaybook", (Object)2);
        resultQuery.setParameter("statusValidated", (Object)3);
        Object[] resultArr = (Object[])resultQuery.getResultList().get(0);
        resultMap.put("debit", resultArr[0] != null ? new BigDecimal(resultArr[0].toString()) : BigDecimal.ZERO);
        resultMap.put("credit", resultArr[1] != null ? new BigDecimal(resultArr[1].toString()) : BigDecimal.ZERO);
        resultMap.put("balance", ((BigDecimal)resultMap.get("debit")).subtract((BigDecimal)resultMap.get("credit")));
        return resultMap;
    }
}

