/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.JournalType;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.ReconcileGroup;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.db.repo.AccountingReportRepository;
import com.axelor.apps.account.db.repo.JournalRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountingReportService;
import com.axelor.apps.account.service.MoveLineExportService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveLineExportServiceImpl
implements MoveLineExportService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppAccountService appAccountService;
    protected AccountingReportService accountingReportService;
    protected SequenceService sequenceService;
    protected AccountConfigService accountConfigService;
    protected MoveRepository moveRepo;
    protected MoveLineRepository moveLineRepo;
    protected AccountingReportRepository accountingReportRepo;
    protected JournalRepository journalRepo;
    protected AccountRepository accountRepo;
    protected MoveLineService moveLineService;
    protected PartnerService partnerService;
    protected static final String DATE_FORMAT_YYYYMMDD = "yyyyMMdd";
    protected static final String DATE_FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    @Inject
    public MoveLineExportServiceImpl(AppAccountService appAccountService, AccountingReportService accountingReportService, SequenceService sequenceService, AccountConfigService accountConfigService, MoveRepository moveRepo, MoveLineRepository moveLineRepo, AccountingReportRepository accountingReportRepo, JournalRepository journalRepo, AccountRepository accountRepo, MoveLineService moveLineService, PartnerService partnerService) {
        this.accountingReportService = accountingReportService;
        this.sequenceService = sequenceService;
        this.accountConfigService = accountConfigService;
        this.moveRepo = moveRepo;
        this.moveLineRepo = moveLineRepo;
        this.accountingReportRepo = accountingReportRepo;
        this.journalRepo = journalRepo;
        this.accountRepo = accountRepo;
        this.moveLineService = moveLineService;
        this.partnerService = partnerService;
        this.appAccountService = appAccountService;
    }

    public void updateMoveList(List<Move> moveList, AccountingReport accountingReport, LocalDate localDate, String exportNumber) {
        int i = 0;
        int moveListSize = moveList.size();
        for (Move move : moveList) {
            this.updateMove((Move)((Object)this.moveRepo.find(move.getId())), (AccountingReport)((Object)this.accountingReportRepo.find(accountingReport.getId())), localDate, exportNumber);
            if (i % 10 == 0) {
                JPA.clear();
            }
            if (i++ % 100 != 0) continue;
            this.log.debug("Process : {} / {}", (Object)i, (Object)moveListSize);
        }
    }

    @Transactional
    public Move updateMove(Move move, AccountingReport accountingReport, LocalDate localDate, String exportNumber) {
        move.setExportNumber(exportNumber);
        move.setExportDate(localDate);
        move.setAccountingOk(true);
        move.setAccountingReport(accountingReport);
        this.moveRepo.save((Model)((Object)move));
        return move;
    }

    public BigDecimal getSumDebit(String queryFilter, List<? extends Move> moveList) {
        TypedQuery q = JPA.em().createQuery("select SUM(self.debit) FROM MoveLine as self WHERE " + queryFilter, BigDecimal.class);
        q.setParameter(1, moveList);
        BigDecimal result = (BigDecimal)q.getSingleResult();
        this.log.debug("Total debit : {}", (Object)result);
        if (result != null) {
            return result;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getSumCredit(String queryFilter, List<Move> moveList) {
        TypedQuery q = JPA.em().createQuery("select SUM(self.credit) FROM MoveLine as self WHERE " + queryFilter, BigDecimal.class);
        q.setParameter(1, moveList);
        BigDecimal result = (BigDecimal)q.getSingleResult();
        this.log.debug("Total credit : {}", (Object)result);
        if (result != null) {
            return result;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getSumCredit(List<MoveLine> moveLineList) {
        BigDecimal sumCredit = BigDecimal.ZERO;
        for (MoveLine moveLine : moveLineList) {
            sumCredit = sumCredit.add(moveLine.getCredit());
        }
        return sumCredit;
    }

    public BigDecimal getTotalAmount(List<MoveLine> moveLinelst) {
        BigDecimal totDebit = BigDecimal.ZERO;
        BigDecimal totCredit = BigDecimal.ZERO;
        for (MoveLine moveLine : moveLinelst) {
            totDebit = totDebit.add(moveLine.getDebit());
            totCredit = totCredit.add(moveLine.getCredit());
        }
        return totCredit.subtract(totDebit);
    }

    public String getSaleExportNumber(Company company) throws AxelorException {
        String exportNumber = this.sequenceService.getSequenceNumber("saleInterface", company);
        if (exportNumber == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"%s : Error : You must configure a sale interface sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return exportNumber;
    }

    public String getRefundExportNumber(Company company) throws AxelorException {
        String exportNumber = this.sequenceService.getSequenceNumber("refundInterface", company);
        if (exportNumber == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"%s : Error : You must configure a credit note interface sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return exportNumber;
    }

    public String getTreasuryExportNumber(Company company) throws AxelorException {
        String exportNumber = this.sequenceService.getSequenceNumber("treasuryInterface", company);
        if (exportNumber == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"%s : Error : You must configure a treasury interface sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return exportNumber;
    }

    public String getPurchaseExportNumber(Company company) throws AxelorException {
        String exportNumber = this.sequenceService.getSequenceNumber("purchaseInterface", company);
        if (exportNumber == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"%s : Error : You must configure a purchase interface sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return exportNumber;
    }

    @Override
    public void exportMoveLineTypeSelect1006(AccountingReport mlr, boolean replay) throws AxelorException, IOException {
        this.log.info("In Export type service : ");
        String fileName = "detail" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "ventes.dat";
        this.exportMoveLineTypeSelect1006FILE1(mlr, replay);
        this.exportMoveLineAllTypeSelectFILE2(mlr, fileName);
    }

    @Transactional(rollbackOn={Exception.class})
    public void exportMoveLineTypeSelect1006FILE1(AccountingReport accountingReport, boolean replay) throws AxelorException, IOException {
        this.log.info("In export service Type 1006 FILE 1 :");
        Company company = accountingReport.getCompany();
        String dateQueryStr = String.format(" WHERE self.company = %s", company.getId());
        JournalType journalType = this.accountingReportService.getJournalType(accountingReport);
        dateQueryStr = accountingReport.getJournal() != null ? dateQueryStr + String.format(" AND self.journal = %s", accountingReport.getJournal().getId()) : dateQueryStr + String.format(" AND self.journal.journalType = %s", journalType.getId());
        if (accountingReport.getPeriod() != null) {
            dateQueryStr = dateQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        dateQueryStr = replay ? dateQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : dateQueryStr + " AND self.accountingOk = false ";
        dateQueryStr = dateQueryStr + " AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false ";
        dateQueryStr = dateQueryStr + String.format(" AND (self.statusSelect = %s OR self.statusSelect = %s) ", 3, 2);
        Query dateQuery = JPA.em().createQuery("SELECT self.date from Move self" + dateQueryStr + "group by self.date order by self.date");
        List allDates = dateQuery.getResultList();
        this.log.debug("allDates : {}", (Object)allDates);
        ArrayList<String[]> allMoveData = new ArrayList<String[]>();
        String companyCode = "";
        String reference = "";
        String moveQueryStr = "";
        String moveLineQueryStr = "";
        if (accountingReport.getRef() != null) {
            reference = accountingReport.getRef();
        }
        if (company != null) {
            companyCode = company.getCode();
            moveQueryStr = moveQueryStr + String.format(" AND self.company = %s", company.getId());
        }
        if (accountingReport.getPeriod() != null) {
            moveQueryStr = moveQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        if (accountingReport.getDateFrom() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date >= '%s'", accountingReport.getDateFrom().toString());
        }
        if (accountingReport.getDateTo() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDateTo().toString());
        }
        if (accountingReport.getDate() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDate().toString());
        }
        moveQueryStr = replay ? moveQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : moveQueryStr + " AND self.accountingOk = false ";
        moveQueryStr = moveQueryStr + String.format(" AND self.statusSelect = %s ", 3);
        LocalDate interfaceDate = accountingReport.getDate();
        for (LocalDate dt : allDates) {
            ArrayList<Journal> journalList = this.journalRepo.all().filter("self.journalType = ?1 AND self.notExportOk = false", new Object[]{journalType}).fetch();
            if (accountingReport.getJournal() != null) {
                journalList = new ArrayList<Journal>();
                journalList.add(accountingReport.getJournal());
            }
            for (Journal journal : journalList) {
                BigDecimal sumDebit;
                List moveList = this.moveRepo.all().filter("self.date = ?1 AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false AND self.journal = ?2" + moveQueryStr, new Object[]{dt, journal}).fetch();
                String journalCode = journal.getExportCode();
                if (moveList.size() <= 0 || (sumDebit = this.getSumDebit("self.account.useForPartnerBalance = true AND self.debit != 0.00 AND self.move in ?1 " + moveLineQueryStr, moveList)).compareTo(BigDecimal.ZERO) != 1) continue;
                String exportNumber = this.getSaleExportNumber(company);
                Move firstMove = (Move)((Object)moveList.get(0));
                String periodCode = firstMove.getPeriod().getFromDate().format(DateTimeFormatter.ofPattern("yyyyMM"));
                this.updateMoveList(moveList, accountingReport, interfaceDate, exportNumber);
                String[] items = new String[]{companyCode, journalCode, exportNumber, interfaceDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), sumDebit.toString(), reference, dt.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), periodCode};
                allMoveData.add(items);
            }
        }
        String fileName = "entete" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "ventes.dat";
        this.writeMoveLineToCsvFile(company, fileName, this.createHeaderForHeaderFile(accountingReport.getTypeSelect()), allMoveData, accountingReport);
    }

    @Override
    public void exportMoveLineTypeSelect1007(AccountingReport accountingReport, boolean replay) throws AxelorException, IOException {
        this.log.info("In Export type 1007 service : ");
        String fileName = "detail" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "avoirs.dat";
        this.exportMoveLineTypeSelect1007FILE1(accountingReport, replay);
        this.exportMoveLineAllTypeSelectFILE2(accountingReport, fileName);
    }

    @Transactional(rollbackOn={Exception.class})
    public void exportMoveLineTypeSelect1007FILE1(AccountingReport accountingReport, boolean replay) throws AxelorException, IOException {
        this.log.info("In export service 1007 FILE 1:");
        Company company = accountingReport.getCompany();
        String dateQueryStr = String.format(" WHERE self.company = %s", company.getId());
        JournalType journalType = this.accountingReportService.getJournalType(accountingReport);
        dateQueryStr = accountingReport.getJournal() != null ? dateQueryStr + String.format(" AND self.journal = %s", accountingReport.getJournal().getId()) : dateQueryStr + String.format(" AND self.journal.journalType = %s", journalType.getId());
        if (accountingReport.getPeriod() != null) {
            dateQueryStr = dateQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        dateQueryStr = replay ? dateQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : dateQueryStr + " AND self.accountingOk = false ";
        dateQueryStr = dateQueryStr + " AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false ";
        dateQueryStr = dateQueryStr + String.format(" AND (self.statusSelect = %s OR self.statusSelect = %s) ", 3, 2);
        Query dateQuery = JPA.em().createQuery("SELECT self.date from Move self" + dateQueryStr + "group by self.date order by self.date");
        List allDates = new ArrayList();
        allDates = dateQuery.getResultList();
        this.log.debug("allDates : {}", allDates);
        ArrayList<String[]> allMoveData = new ArrayList<String[]>();
        String companyCode = "";
        String reference = "";
        String moveQueryStr = "";
        String moveLineQueryStr = "";
        if (accountingReport.getRef() != null) {
            reference = accountingReport.getRef();
        }
        if (accountingReport.getCompany() != null) {
            companyCode = accountingReport.getCompany().getCode();
            moveQueryStr = moveQueryStr + String.format(" AND self.company = %s", accountingReport.getCompany().getId());
        }
        if (accountingReport.getPeriod() != null) {
            moveQueryStr = moveQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        if (accountingReport.getDateFrom() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date >= '%s'", accountingReport.getDateFrom().toString());
        }
        if (accountingReport.getDateTo() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDateTo().toString());
        }
        if (accountingReport.getDate() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDate().toString());
        }
        moveQueryStr = replay ? moveQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : moveQueryStr + " AND self.accountingOk = false ";
        moveQueryStr = moveQueryStr + String.format(" AND self.statusSelect = %s ", 3);
        LocalDate interfaceDate = accountingReport.getDate();
        for (LocalDate dt : allDates) {
            ArrayList<Journal> journalList = this.journalRepo.all().filter("self.journalType = ?1 AND self.notExportOk = false", new Object[]{journalType}).fetch();
            if (accountingReport.getJournal() != null) {
                journalList = new ArrayList<Journal>();
                journalList.add(accountingReport.getJournal());
            }
            for (Journal journal : journalList) {
                BigDecimal sumCredit;
                List moveList = this.moveRepo.all().filter("self.date = ?1 AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false AND self.journal = ?2" + moveQueryStr, new Object[]{dt, journal}).fetch();
                String journalCode = journal.getExportCode();
                if (moveList.size() <= 0 || (sumCredit = this.getSumCredit("self.account.useForPartnerBalance = true AND self.credit != 0.00 AND self.move in ?1 " + moveLineQueryStr, moveList)).compareTo(BigDecimal.ZERO) != 1) continue;
                String exportNumber = this.getRefundExportNumber(company);
                Move firstMove = (Move)((Object)moveList.get(0));
                String periodCode = firstMove.getPeriod().getFromDate().format(DateTimeFormatter.ofPattern("yyyyMM"));
                this.updateMoveList(moveList, accountingReport, interfaceDate, exportNumber);
                String[] items = new String[]{companyCode, journalCode, exportNumber, interfaceDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), sumCredit.toString(), reference, dt.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), periodCode};
                allMoveData.add(items);
            }
        }
        String fileName = "entete" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "avoirs.dat";
        this.writeMoveLineToCsvFile(company, fileName, this.createHeaderForHeaderFile(accountingReport.getTypeSelect()), allMoveData, accountingReport);
    }

    @Override
    public void exportMoveLineTypeSelect1008(AccountingReport accountingReport, boolean replay) throws AxelorException, IOException {
        this.log.info("In Export type 1008 service : ");
        String fileName = "detail" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "tresorerie.dat";
        this.exportMoveLineTypeSelect1008FILE1(accountingReport, replay);
        this.exportMoveLineAllTypeSelectFILE2(accountingReport, fileName);
    }

    @Transactional(rollbackOn={Exception.class})
    public void exportMoveLineTypeSelect1008FILE1(AccountingReport accountingReport, boolean replay) throws AxelorException, IOException {
        this.log.info("In export service 1008 FILE 1:");
        Company company = accountingReport.getCompany();
        String dateQueryStr = String.format(" WHERE self.company = %s", company.getId());
        JournalType journalType = this.accountingReportService.getJournalType(accountingReport);
        dateQueryStr = accountingReport.getJournal() != null ? dateQueryStr + String.format(" AND self.journal = %s", accountingReport.getJournal().getId()) : dateQueryStr + String.format(" AND self.journal.journalType = %s", journalType.getId());
        if (accountingReport.getPeriod() != null) {
            dateQueryStr = dateQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        dateQueryStr = replay ? dateQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : dateQueryStr + " AND self.accountingOk = false ";
        dateQueryStr = dateQueryStr + " AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false ";
        dateQueryStr = dateQueryStr + String.format(" AND (self.statusSelect = %s OR self.statusSelect = %s) ", 3, 2);
        Query dateQuery = JPA.em().createQuery("SELECT self.date from Move self" + dateQueryStr + "group by self.date order by self.date");
        List allDates = new ArrayList();
        allDates = dateQuery.getResultList();
        this.log.debug("allDates : {}", allDates);
        ArrayList<String[]> allMoveData = new ArrayList<String[]>();
        String companyCode = "";
        String reference = "";
        String moveQueryStr = "";
        String moveLineQueryStr = "";
        if (accountingReport.getRef() != null) {
            reference = accountingReport.getRef();
        }
        if (company != null) {
            companyCode = accountingReport.getCompany().getCode();
            moveQueryStr = moveQueryStr + String.format(" AND self.company = %s", company.getId());
        }
        if (accountingReport.getPeriod() != null) {
            moveQueryStr = moveQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        if (accountingReport.getDateFrom() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date >= '%s'", accountingReport.getDateFrom().toString());
        }
        if (accountingReport.getDateTo() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDateTo().toString());
        }
        if (accountingReport.getDate() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDate().toString());
        }
        moveQueryStr = replay ? moveQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : moveQueryStr + " AND self.accountingOk = false ";
        moveQueryStr = moveQueryStr + String.format(" AND self.statusSelect = %s ", 3);
        LocalDate interfaceDate = accountingReport.getDate();
        for (LocalDate dt : allDates) {
            ArrayList<Journal> journalList = this.journalRepo.all().filter("self.journalType = ?1 AND self.notExportOk = false", new Object[]{journalType}).fetch();
            if (accountingReport.getJournal() != null) {
                journalList = new ArrayList<Journal>();
                journalList.add(accountingReport.getJournal());
            }
            for (Journal journal : journalList) {
                long moveLineListSize;
                List moveList = this.moveRepo.all().filter("self.date = ?1 AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false AND self.journal = ?2" + moveQueryStr, new Object[]{dt, journal}).fetch();
                String journalCode = journal.getExportCode();
                if (moveList.size() <= 0 || (moveLineListSize = this.moveLineRepo.all().filter("self.move in ?1 AND (self.debit > 0 OR self.credit > 0) " + moveLineQueryStr, new Object[]{moveList}).count()) <= 0L) continue;
                String exportNumber = this.getTreasuryExportNumber(company);
                Move firstMove = (Move)((Object)moveList.get(0));
                String periodCode = firstMove.getPeriod().getFromDate().format(DateTimeFormatter.ofPattern("yyyyMM"));
                this.updateMoveList(moveList, accountingReport, interfaceDate, exportNumber);
                String[] items = new String[]{companyCode, journalCode, exportNumber, interfaceDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), "0", reference, dt.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), periodCode};
                allMoveData.add(items);
            }
        }
        String fileName = "entete" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "tresorerie.dat";
        this.writeMoveLineToCsvFile(company, fileName, this.createHeaderForHeaderFile(accountingReport.getTypeSelect()), allMoveData, accountingReport);
    }

    @Override
    public void exportMoveLineTypeSelect1009(AccountingReport accountingReport, boolean replay) throws AxelorException, IOException {
        this.log.info("In Export type 1009 service : ");
        String fileName = "detail" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "achats.dat";
        this.exportMoveLineTypeSelect1009FILE1(accountingReport, replay);
        this.exportMoveLineAllTypeSelectFILE2(accountingReport, fileName);
    }

    @Transactional(rollbackOn={Exception.class})
    public void exportMoveLineTypeSelect1009FILE1(AccountingReport accountingReport, boolean replay) throws AxelorException, IOException {
        this.log.info("In export service 1009 FILE 1:");
        Company company = accountingReport.getCompany();
        String dateQueryStr = String.format(" WHERE self.company = %s", company.getId());
        JournalType journalType = this.accountingReportService.getJournalType(accountingReport);
        dateQueryStr = accountingReport.getJournal() != null ? dateQueryStr + String.format(" AND self.journal = %s", accountingReport.getJournal().getId()) : dateQueryStr + String.format(" AND self.journal.journalType = %s", journalType.getId());
        if (accountingReport.getPeriod() != null) {
            dateQueryStr = dateQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        dateQueryStr = replay ? dateQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : dateQueryStr + " AND self.accountingOk = false ";
        dateQueryStr = dateQueryStr + " AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false ";
        dateQueryStr = dateQueryStr + String.format(" AND (self.statusSelect = %s OR self.statusSelect = %s) ", 3, 2);
        Query dateQuery = JPA.em().createQuery("SELECT self.date from Move self" + dateQueryStr + "group by self.date order by self.date");
        List allDates = new ArrayList();
        allDates = dateQuery.getResultList();
        this.log.debug("allDates : {}", allDates);
        ArrayList<String[]> allMoveData = new ArrayList<String[]>();
        String companyCode = "";
        String reference = "";
        String moveQueryStr = "";
        String moveLineQueryStr = "";
        if (accountingReport.getRef() != null) {
            reference = accountingReport.getRef();
        }
        if (company != null) {
            companyCode = company.getCode();
            moveQueryStr = moveQueryStr + String.format(" AND self.company = %s", company.getId());
        }
        if (accountingReport.getPeriod() != null) {
            moveQueryStr = moveQueryStr + String.format(" AND self.period = %s", accountingReport.getPeriod().getId());
        }
        if (accountingReport.getDateFrom() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date >= '%s'", accountingReport.getDateFrom().toString());
        }
        if (accountingReport.getDateTo() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDateTo().toString());
        }
        if (accountingReport.getDate() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDate().toString());
        }
        moveQueryStr = replay ? moveQueryStr + String.format(" AND self.accountingOk = true AND self.accountingReport = %s", accountingReport.getId()) : moveQueryStr + " AND self.accountingOk = false ";
        moveQueryStr = moveQueryStr + String.format(" AND self.statusSelect = %s ", 3);
        LocalDate interfaceDate = accountingReport.getDate();
        for (LocalDate dt : allDates) {
            ArrayList<Journal> journalList = this.journalRepo.all().filter("self.journalType = ?1 AND self.notExportOk = false", new Object[]{journalType}).fetch();
            if (accountingReport.getJournal() != null) {
                journalList = new ArrayList<Journal>();
                journalList.add(accountingReport.getJournal());
            }
            for (Journal journal : journalList) {
                List moveList = this.moveRepo.all().filter("self.date = ?1 AND self.ignoreInAccountingOk = false AND self.journal.notExportOk = false AND self.journal = ?2" + moveQueryStr, new Object[]{dt, journal}).fetch();
                String journalCode = journal.getExportCode();
                int moveListSize = moveList.size();
                if (moveListSize <= 0) continue;
                int i = 0;
                for (Move move : moveList) {
                    List moveLineList = this.moveLineRepo.all().filter("self.account.useForPartnerBalance = true AND self.credit != 0.00 AND self.move in ?1" + moveLineQueryStr, new Object[]{moveList}).fetch();
                    if (moveLineList.size() <= 0) continue;
                    String exportNumber = this.getPurchaseExportNumber(company);
                    String periodCode = move.getPeriod().getFromDate().format(DateTimeFormatter.ofPattern("yyyyMM"));
                    BigDecimal totalCredit = this.getSumCredit(moveLineList);
                    String invoiceId = "";
                    String dueDate = "";
                    if (move.getInvoice() != null) {
                        invoiceId = move.getInvoice().getInvoiceId();
                        dueDate = move.getInvoice().getDueDate().toString();
                    }
                    MoveLine firstMoveLine = (MoveLine)((Object)moveLineList.get(0));
                    String[] items = new String[]{companyCode, journalCode, exportNumber, interfaceDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), invoiceId, dueDate, firstMoveLine.getAccount().getCode(), totalCredit.toString(), reference, dt.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")), periodCode};
                    allMoveData.add(items);
                    this.updateMove(move, accountingReport, interfaceDate, exportNumber);
                    if (i % 10 == 0) {
                        JPA.clear();
                    }
                    if (i++ % 100 != 0) continue;
                    this.log.debug("Process : {} / {}", (Object)i, (Object)moveListSize);
                }
            }
        }
        String fileName = "entete" + this.appAccountService.getTodayDateTime().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS)) + "achats.dat";
        this.writeMoveLineToCsvFile(company, fileName, this.createHeaderForHeaderFile(accountingReport.getTypeSelect()), allMoveData, accountingReport);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void exportMoveLineTypeSelect1010(AccountingReport accountingReport) throws AxelorException, IOException {
        this.log.info("In Export type 1010 service:");
        ArrayList<String[]> allMoveLineData = new ArrayList<String[]>();
        String filterStr = this.accountingReportService.getMoveLineList(accountingReport);
        String queryStr = String.format("SELECT self.accountCode, self.accountName, SUM(self.debit), SUM(self.credit) FROM MoveLine self WHERE %s GROUP BY self.accountCode, self.accountName ORDER BY self.accountCode", filterStr);
        Query query = JPA.em().createQuery(queryStr);
        List resultList = query.getResultList();
        for (Object[] result : resultList) {
            String[] items = new String[result.length];
            for (int i = 0; i < result.length; ++i) {
                items[i] = String.valueOf(result[i]);
            }
            allMoveLineData.add(items);
        }
        LocalDate date = accountingReport.getDateTo() != null ? accountingReport.getDateTo() : (accountingReport.getPeriod() != null ? accountingReport.getPeriod().getToDate() : null);
        String dateStr = date != null ? "-" + date : "";
        String fileName = String.format("%s %s%s.csv", I18n.get((String)"General balance"), accountingReport.getRef(), dateStr);
        this.writeMoveLineToCsvFile(accountingReport.getCompany(), fileName, null, allMoveLineData, accountingReport);
    }

    @Transactional(rollbackOn={Exception.class})
    public MetaFile exportMoveLineTypeSelect1000(AccountingReport accountingReport, boolean administration, boolean replay) throws AxelorException, IOException {
        List moveLineList;
        this.log.info("In Export type 1000 service : ");
        ArrayList<String[]> allMoveLineData = new ArrayList<String[]>();
        Company company = accountingReport.getCompany();
        LocalDate interfaceDate = accountingReport.getDate();
        String moveLineQueryStr = String.format("(self.move.statusSelect = %s", 3);
        if (!administration) {
            moveLineQueryStr = moveLineQueryStr + String.format(" OR self.move.statusSelect = %s", 2);
        }
        moveLineQueryStr = moveLineQueryStr + ")";
        moveLineQueryStr = moveLineQueryStr + String.format(" AND self.move.company = %s", company.getId());
        if (accountingReport.getYear() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.move.period.year = %s", accountingReport.getYear().getId());
        }
        if (accountingReport.getPeriod() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.move.period = %s", accountingReport.getPeriod().getId());
        } else {
            if (accountingReport.getDateFrom() != null) {
                moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date >= '%s'", accountingReport.getDateFrom().toString());
            }
            if (accountingReport.getDateTo() != null) {
                moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDateTo().toString());
            }
        }
        if (accountingReport.getDate() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDate().toString());
        }
        moveLineQueryStr = moveLineQueryStr + " AND self.move.ignoreInAccountingOk = false";
        if (!administration) {
            moveLineQueryStr = moveLineQueryStr + " AND self.move.journal.notExportOk = false";
            moveLineQueryStr = replay ? moveLineQueryStr + String.format(" AND self.move.accountingOk = true AND self.move.accountingReport.id = %s", accountingReport.getId()) : moveLineQueryStr + " AND self.move.accountingOk = false";
        }
        if (!(moveLineList = this.moveLineRepo.all().filter(moveLineQueryStr).order("move.validationDate").order("date").order("name").fetch()).isEmpty()) {
            ArrayList<Move> moveList = new ArrayList<Move>();
            for (MoveLine moveLine : moveLineList) {
                String[] items = new String[18];
                Move move = moveLine.getMove();
                if (!moveList.contains((Object)move)) {
                    moveList.add(move);
                }
                Journal journal = move.getJournal();
                items[0] = journal.getCode();
                items[1] = journal.getName();
                items[2] = moveLine.getMove().getReference();
                items[3] = moveLine.getDate().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDD));
                items[4] = moveLine.getAccount().getCode();
                items[5] = moveLine.getAccount().getName();
                items[6] = "";
                items[7] = "";
                Partner partner = moveLine.getPartner();
                if (partner != null) {
                    items[6] = partner.getPartnerSeq();
                    items[7] = partner.getName();
                }
                items[8] = moveLine.getOrigin();
                if (moveLine.getOriginDate() != null) {
                    items[9] = moveLine.getOriginDate().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDD));
                }
                items[10] = moveLine.getDescription();
                items[11] = moveLine.getDebit().toString().replace('.', ',');
                items[12] = moveLine.getCredit().toString().replace('.', ',');
                ReconcileGroup reconcileGroup = moveLine.getReconcileGroup();
                if (reconcileGroup != null && reconcileGroup.getStatusSelect() == 2) {
                    items[13] = reconcileGroup.getCode();
                    items[14] = reconcileGroup.getDateOfLettering().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDD)).toString();
                } else {
                    items[13] = "";
                    items[14] = "";
                }
                if (move.getValidationDate() != null) {
                    items[15] = move.getValidationDate().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDD));
                }
                items[16] = moveLine.getCurrencyAmount().toString().replace('.', ',');
                if (moveLine.getCurrencyAmount().compareTo(BigDecimal.ZERO) > 0 && moveLine.getCredit().compareTo(BigDecimal.ZERO) > 0) {
                    items[16] = "-" + items[16];
                }
                if (move.getCurrency() != null) {
                    items[17] = move.getCurrency().getCode();
                }
                allMoveLineData.add(items);
            }
            if (!administration) {
                String exportNumber = this.getSaleExportNumber(company);
                this.updateMoveList(moveList, accountingReport, interfaceDate, exportNumber);
            }
        }
        accountingReport = (AccountingReport)((Object)this.accountingReportRepo.find(accountingReport.getId()));
        String fileName = this.setFileName(accountingReport);
        this.accountingReportRepo.save((Model)((Object)accountingReport));
        return this.writeMoveLineToCsvFile(company, fileName, this.createHeaderForJournalEntry(), allMoveLineData, accountingReport);
    }

    public void exportMoveLineAllTypeSelectFILE2(AccountingReport accountingReport, String fileName) throws AxelorException, IOException {
        this.log.info("In export service FILE 2 :");
        Company company = accountingReport.getCompany();
        String companyCode = "";
        String moveLineQueryStr = "";
        int typeSelect = accountingReport.getTypeSelect();
        if (company != null) {
            companyCode = company.getCode();
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.move.company = %s", company.getId());
        }
        moveLineQueryStr = accountingReport.getJournal() != null ? moveLineQueryStr + String.format(" AND self.move.journal = %s", accountingReport.getJournal().getId()) : moveLineQueryStr + String.format(" AND self.move.journal.journalType = %s", this.accountingReportService.getJournalType(accountingReport).getId());
        if (accountingReport.getPeriod() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.move.period = %s", accountingReport.getPeriod().getId());
        }
        if (accountingReport.getDateFrom() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date >= '%s'", accountingReport.getDateFrom().toString());
        }
        if (accountingReport.getDateTo() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDateTo().toString());
        }
        if (accountingReport.getDate() != null) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.date <= '%s'", accountingReport.getDate().toString());
        }
        if (typeSelect != 8) {
            moveLineQueryStr = moveLineQueryStr + String.format(" AND self.account.useForPartnerBalance = false ", new Object[0]);
        }
        moveLineQueryStr = moveLineQueryStr + String.format("AND self.move.accountingOk = true AND self.move.ignoreInAccountingOk = false AND self.move.accountingReport = %s", accountingReport.getId());
        moveLineQueryStr = moveLineQueryStr + String.format(" AND (self.move.statusSelect = %s OR self.move.statusSelect = %s) ", 3, 2);
        Query queryDate = JPA.em().createQuery("SELECT self.date from MoveLine self where self.account != null AND (self.debit > 0 OR self.credit > 0) " + moveLineQueryStr + " group by self.date ORDER BY self.date");
        List dates = new ArrayList();
        dates = queryDate.getResultList();
        this.log.debug("dates : {}", dates);
        ArrayList<String[]> allMoveLineData = new ArrayList<String[]>();
        for (LocalDate localDate : dates) {
            Query queryExportRef = JPA.em().createQuery("SELECT DISTINCT self.move.exportNumber from MoveLine self where self.account != null AND (self.debit > 0 OR self.credit > 0) AND self.date = '" + localDate.toString() + "'" + moveLineQueryStr);
            List exportRefs = new ArrayList();
            exportRefs = queryExportRef.getResultList();
            for (String exportRef : exportRefs) {
                if (exportRef == null || exportRef.isEmpty()) continue;
                int sequence = 1;
                Query query = JPA.em().createQuery("SELECT self.account.id from MoveLine self where self.account != null AND (self.debit > 0 OR self.credit > 0) AND self.date = '" + localDate.toString() + "' AND self.move.exportNumber = '" + exportRef + "'" + moveLineQueryStr + " group by self.account.id");
                List accountIds = new ArrayList();
                accountIds = query.getResultList();
                this.log.debug("accountIds : {}", accountIds);
                for (Long accountId : accountIds) {
                    if (accountId == null) continue;
                    String accountCode = ((Account)((Object)this.accountRepo.find(accountId))).getCode();
                    List moveLines = this.moveLineRepo.all().filter("self.account.id = ?1 AND (self.debit > 0 OR self.credit > 0) AND self.date = '" + localDate.toString() + "' AND self.move.exportNumber = '" + exportRef + "'" + moveLineQueryStr, new Object[]{accountId}).fetch();
                    this.log.debug("movelines  : {} ", (Object)moveLines);
                    if (moveLines.size() <= 0) continue;
                    List<MoveLine> moveLineList = this.moveLineService.consolidateMoveLines(moveLines);
                    List<MoveLine> sortMoveLineList = this.sortMoveLineByDebitCredit(moveLineList);
                    for (MoveLine moveLine3 : sortMoveLineList) {
                        Journal journal = moveLine3.getMove().getJournal();
                        LocalDate date = moveLine3.getDate();
                        String[] items = null;
                        items = typeSelect == 9 ? new String[13] : new String[12];
                        items[0] = companyCode;
                        items[1] = journal.getExportCode();
                        items[2] = moveLine3.getMove().getExportNumber();
                        items[3] = String.format("%s", sequence);
                        ++sequence;
                        items[4] = accountCode;
                        BigDecimal totAmt = moveLine3.getCredit().subtract(moveLine3.getDebit());
                        String moveLineSign = "C";
                        if (totAmt.compareTo(BigDecimal.ZERO) == -1) {
                            moveLineSign = "D";
                            totAmt = totAmt.negate();
                        }
                        items[5] = moveLineSign;
                        items[6] = totAmt.toString();
                        String analyticAccounts = "";
                        for (AnalyticMoveLine analyticDistributionLine : moveLine3.getAnalyticMoveLineList()) {
                            analyticAccounts = analyticAccounts + analyticDistributionLine.getAnalyticAccount().getCode() + "/";
                        }
                        if (typeSelect == 9) {
                            items[7] = "";
                            items[8] = analyticAccounts;
                            items[9] = String.format("%s DU %s", journal.getCode(), date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
                        } else {
                            items[7] = analyticAccounts;
                            items[8] = String.format("%s DU %s", journal.getCode(), date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
                        }
                        allMoveLineData.add(items);
                    }
                }
            }
        }
        this.writeMoveLineToCsvFile(company, fileName, this.createHeaderForDetailFile(typeSelect), allMoveLineData, accountingReport);
    }

    private MetaFile writeMoveLineToCsvFile(Company company, String fileName, String[] columnHeader, List<String[]> allMoveData, AccountingReport accountingReport) throws AxelorException, IOException {
        String filePath = this.accountConfigService.getAccountConfig(company).getExportPath();
        for (String[] items : allMoveData) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                items[i] = items[i].replaceAll("(\r\n|\n\r|\r|\n|\\|)", " ");
            }
        }
        if (filePath == null) {
            filePath = Files.createTempDir().getAbsolutePath();
        } else {
            new File(filePath).mkdirs();
        }
        this.log.debug("Full path to export : {}{}", (Object)filePath, (Object)fileName);
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)'|', (String[])columnHeader, allMoveData);
        Path path = Paths.get(filePath, fileName);
        try (FileInputStream is = new FileInputStream(path.toFile());){
            MetaFile metaFile = ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)is, fileName, (Model)((Object)accountingReport)).getMetaFile();
            return metaFile;
        }
    }

    public List<MoveLine> sortMoveLineByDebitCredit(List<MoveLine> moveLineList) {
        ArrayList<MoveLine> sortMoveLineList = new ArrayList<MoveLine>();
        ArrayList<MoveLine> debitMoveLineList = new ArrayList<MoveLine>();
        ArrayList<MoveLine> creditMoveLineList = new ArrayList<MoveLine>();
        for (MoveLine moveLine : moveLineList) {
            if (moveLine.getDebit().compareTo(moveLine.getCredit()) == 1) {
                debitMoveLineList.add(moveLine);
                continue;
            }
            creditMoveLineList.add(moveLine);
        }
        sortMoveLineList.addAll(debitMoveLineList);
        sortMoveLineList.addAll(creditMoveLineList);
        return sortMoveLineList;
    }

    public String[] createHeaderForJournalEntry() {
        String header = "JournalCode;JournalLib;EcritureNum;EcritureDate;CompteNum;CompteLib;CompAuxNum;CompAuxLib;PieceRef;PieceDate;EcritureLib;Debit;Credit;EcritureLet;DateLet;ValidDate;Montantdevise;Idevise;";
        return header.split(";");
    }

    public String[] createHeaderForHeaderFile(int typeSelect) {
        String header = null;
        switch (typeSelect) {
            case 1006: {
                header = "Soci\u00e9t\u00e9;Journal de Vente;Num\u00e9ro d'\u00e9criture;Date de l'interface;Montant de l'\u00e9criture;R\u00e9f. de l'\u00e9criture;Date de l'\u00e9criture;P\u00e9riode de l'\u00e9criture;";
                return header.split(";");
            }
            case 1007: {
                header = "Soci\u00e9t\u00e9;Journal d'Avoir;Num\u00e9ro d'\u00e9criture;Date de l'interface;Montant de l'\u00e9criture;R\u00e9f. de l'\u00e9criture;Date de l'\u00e9criture;P\u00e9riode de l'\u00e9criture;";
                return header.split(";");
            }
            case 1008: {
                header = "Soci\u00e9t\u00e9;Journal de Tr\u00e9sorerie;Num\u00e9ro d'\u00e9criture;Date de l'interface;Montant de l'\u00e9criture;R\u00e9f. de l'\u00e9criture;Date de l'\u00e9criture;P\u00e9riode de l'\u00e9criture;";
                return header.split(";");
            }
            case 1009: {
                header = "Soci\u00e9t\u00e9;Journal d'Achat;Num\u00e9ro d'\u00e9criture;Date de l'interface;Code fournisseur;Date de la facture;Date d'exigibilit\u00e9;Num\u00e9ro de compte de contrepartie;Montant de l'\u00e9criture;R\u00e9f. de l'\u00e9criture;Date de l'\u00e9criture;P\u00e9riode de l'\u00e9criture;";
                return header.split(";");
            }
        }
        return null;
    }

    public String[] createHeaderForDetailFile(int typeSelect) {
        String header = "";
        header = typeSelect == 1009 ? "Soci\u00e9t\u00e9;Journal;Num\u00e9ro d'\u00e9criture;Num. ligne d'\u00e9criture;Num\u00e9ro de compte;Sens de l'\u00e9criture;Montant de la ligne;Code TVA;CRB;Site;M\u00e9tier;Activit\u00e9;Nom;" : "Soci\u00e9t\u00e9;Journal;Num\u00e9ro d'\u00e9criture;Num. ligne d'\u00e9criture;Num\u00e9ro de compte;Sens de l'\u00e9criture;Montant de la ligne;CRB;Site;M\u00e9tier;Activit\u00e9;Nom;";
        return header.split(";");
    }

    @Override
    public MetaFile exportMoveLine(AccountingReport accountingReport) throws AxelorException, IOException {
        this.accountingReportService.setStatus(accountingReport);
        switch (accountingReport.getTypeSelect()) {
            case 1006: {
                this.exportMoveLineTypeSelect1006(accountingReport, false);
                break;
            }
            case 1007: {
                this.exportMoveLineTypeSelect1007(accountingReport, false);
                break;
            }
            case 1008: {
                this.exportMoveLineTypeSelect1008(accountingReport, false);
                break;
            }
            case 1009: {
                this.exportMoveLineTypeSelect1009(accountingReport, false);
                break;
            }
            case 1010: {
                this.exportMoveLineTypeSelect1010(accountingReport);
                break;
            }
            case 1000: {
                return this.exportMoveLineTypeSelect1000(accountingReport, true, false);
            }
            case 1001: {
                this.exportMoveLineTypeSelect1000(accountingReport, false, false);
                break;
            }
        }
        return null;
    }

    @Override
    public void replayExportMoveLine(AccountingReport accountingReport) throws AxelorException, IOException {
        switch (accountingReport.getTypeSelect()) {
            case 1006: {
                this.exportMoveLineTypeSelect1006(accountingReport, true);
                break;
            }
            case 1007: {
                this.exportMoveLineTypeSelect1007(accountingReport, true);
                break;
            }
            case 1008: {
                this.exportMoveLineTypeSelect1008(accountingReport, true);
                break;
            }
            case 1009: {
                this.exportMoveLineTypeSelect1009(accountingReport, true);
                break;
            }
            case 1001: {
                this.exportMoveLineTypeSelect1000(accountingReport, false, true);
                break;
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public AccountingReport createAccountingReport(Company company, int exportTypeSelect, LocalDate startDate, LocalDate endDate) throws AxelorException {
        AccountingReport accountingReport = new AccountingReport();
        accountingReport.setCompany(company);
        accountingReport.setTypeSelect(exportTypeSelect);
        accountingReport.setDateFrom(startDate);
        accountingReport.setDateTo(endDate);
        accountingReport.setStatusSelect(1);
        accountingReport.setDate(this.appAccountService.getTodayDateTime().toLocalDate());
        accountingReport.setRef(this.accountingReportService.getSequence(accountingReport));
        this.accountingReportService.buildQuery(accountingReport);
        BigDecimal debitBalance = this.accountingReportService.getDebitBalance();
        BigDecimal creditBalance = this.accountingReportService.getCreditBalance();
        accountingReport.setTotalDebit(debitBalance);
        accountingReport.setTotalCredit(creditBalance);
        accountingReport.setBalance(debitBalance.subtract(creditBalance));
        this.accountingReportRepo.save((Model)((Object)accountingReport));
        return accountingReport;
    }

    @Transactional(rollbackOn={Exception.class})
    public String setFileName(AccountingReport accountingReport) throws AxelorException {
        Company company = accountingReport.getCompany();
        Partner partner = company.getPartner();
        String fileName = this.partnerService.getSIRENNumber(partner) + "FEC";
        if (accountingReport.getDateTo() != null) {
            fileName = fileName + accountingReport.getDateTo().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDD));
        } else if (accountingReport.getPeriod() != null) {
            fileName = fileName + accountingReport.getPeriod().getToDate().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDD));
        } else if (accountingReport.getYear() != null) {
            fileName = fileName + accountingReport.getYear().getToDate().format(DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDD));
        } else {
            throw new AxelorException(I18n.get((String)"Year or period or date is null, you must set a period."), 3, new Object[0]);
        }
        fileName = fileName + ".csv";
        return fileName;
    }
}

