/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.PaymentScheduleLineService;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.PaymentService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentScheduleLineServiceImpl
implements PaymentScheduleLineService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppBaseService appBaseService;
    protected PaymentScheduleService paymentScheduleService;
    protected MoveService moveService;
    protected PaymentModeService paymentModeService;
    protected SequenceService sequenceService;
    protected AccountingSituationService accountingSituationService;
    protected MoveToolService moveToolService;
    protected PaymentService paymentService;
    protected MoveLineRepository moveLineRepo;
    protected PaymentScheduleLineRepository paymentScheduleLineRepo;

    @Inject
    public PaymentScheduleLineServiceImpl(AppBaseService appBaseService, PaymentScheduleService paymentScheduleService, MoveService moveService, PaymentModeService paymentModeService, SequenceService sequenceService, AccountingSituationService accountingSituationService, MoveToolService moveToolService, PaymentService paymentService, MoveLineRepository moveLineRepo, PaymentScheduleLineRepository paymentScheduleLineRepo) {
        this.appBaseService = appBaseService;
        this.paymentScheduleService = paymentScheduleService;
        this.moveService = moveService;
        this.paymentModeService = paymentModeService;
        this.sequenceService = sequenceService;
        this.accountingSituationService = accountingSituationService;
        this.moveToolService = moveToolService;
        this.paymentService = paymentService;
        this.moveLineRepo = moveLineRepo;
        this.paymentScheduleLineRepo = paymentScheduleLineRepo;
    }

    @Override
    public PaymentScheduleLine createPaymentScheduleLine(PaymentSchedule paymentSchedule, BigDecimal inTaxAmount, int scheduleLineSeq, LocalDate scheduleDate) {
        PaymentScheduleLine paymentScheduleLine = new PaymentScheduleLine();
        paymentScheduleLine.setScheduleLineSeq(scheduleLineSeq);
        paymentScheduleLine.setScheduleDate(scheduleDate);
        paymentScheduleLine.setInTaxAmount(inTaxAmount);
        paymentScheduleLine.setStatusSelect(1);
        if (paymentSchedule != null) {
            paymentSchedule.addPaymentScheduleLineListItem(paymentScheduleLine);
        }
        this.log.debug("Cr\u00e9ation de la ligne de l'\u00e9ch\u00e9ancier num\u00e9ro {} pour la date du {} et la somme de {}", new Object[]{paymentScheduleLine.getScheduleLineSeq(), paymentScheduleLine.getScheduleDate(), paymentScheduleLine.getInTaxAmount()});
        return paymentScheduleLine;
    }

    @Override
    public List<PaymentScheduleLine> createPaymentScheduleLines(PaymentSchedule paymentSchedule) {
        ArrayList<PaymentScheduleLine> paymentScheduleLines = new ArrayList<PaymentScheduleLine>();
        int nbrTerm = paymentSchedule.getNbrTerm();
        BigDecimal inTaxAmount = paymentSchedule.getInTaxAmount();
        this.log.debug("Cr\u00e9ation de lignes pour l'\u00e9ch\u00e9ancier num\u00e9ro {} (nombre d'\u00e9ch\u00e9ance : {}, montant : {})", new Object[]{paymentSchedule.getPaymentScheduleSeq(), nbrTerm, inTaxAmount});
        if (nbrTerm > 0 && inTaxAmount.compareTo(BigDecimal.ZERO) == 1) {
            BigDecimal termAmount = inTaxAmount.divide(new BigDecimal(nbrTerm), 2, RoundingMode.HALF_EVEN);
            BigDecimal cumul = BigDecimal.ZERO;
            for (int i = 1; i < nbrTerm + 1; ++i) {
                if (i == nbrTerm) {
                    termAmount = inTaxAmount.subtract(cumul);
                } else {
                    cumul = cumul.add(termAmount);
                }
                paymentScheduleLines.add(this.createPaymentScheduleLine(paymentSchedule, termAmount, i, paymentSchedule.getStartDate().plusMonths(i - 1)));
            }
        }
        return paymentScheduleLines;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Move createPaymentMove(PaymentScheduleLine paymentScheduleLine, BankDetails companyBankDetails, PaymentMode paymentMode) throws AxelorException {
        List<MoveLine> debitMoveLineList;
        Preconditions.checkNotNull((Object)((Object)paymentScheduleLine));
        Preconditions.checkNotNull((Object)((Object)companyBankDetails));
        PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
        Company company = paymentSchedule.getCompany();
        Partner partner = paymentSchedule.getPartner();
        Journal journal = this.paymentModeService.getPaymentModeJournal(paymentMode, company, companyBankDetails);
        BigDecimal amount = paymentScheduleLine.getInTaxAmount();
        String name = paymentScheduleLine.getName();
        LocalDate todayDate = this.appBaseService.getTodayDate(company);
        Account account = this.accountingSituationService.getCustomerAccount(partner, company);
        Move move = this.moveService.getMoveCreateService().createMove(journal, company, null, partner, paymentMode, 2);
        MoveLine creditMoveLine = this.moveService.getMoveLineService().createMoveLine(move, partner, account, amount, false, todayDate, 1, name, null);
        move.addMoveLineListItem(creditMoveLine);
        creditMoveLine = (MoveLine)((Object)this.moveLineRepo.save((Model)((Object)creditMoveLine)));
        Account paymentModeAccount = this.paymentModeService.getPaymentModeAccount(paymentMode, company, companyBankDetails);
        MoveLine debitMoveLine = this.moveService.getMoveLineService().createMoveLine(move, partner, paymentModeAccount, amount, true, todayDate, 2, name, null);
        move.addMoveLineListItem(debitMoveLine);
        debitMoveLine = (MoveLine)((Object)this.moveLineRepo.save((Model)((Object)debitMoveLine)));
        this.moveService.getMoveValidateService().validate(move);
        if (paymentSchedule.getTypeSelect() == 1 && paymentSchedule.getInvoiceSet() != null && this.moveToolService.isSameAccount(debitMoveLineList = paymentSchedule.getInvoiceSet().stream().sorted(Comparator.comparing(Invoice::getDueDate)).map(invoice -> this.moveService.getMoveLineService().getDebitCustomerMoveLine((Invoice)((Object)invoice))).collect(Collectors.toList()), account)) {
            ArrayList creditMoveLineList = Lists.newArrayList((Object[])new MoveLine[]{creditMoveLine});
            this.paymentService.useExcessPaymentOnMoveLines(debitMoveLineList, creditMoveLineList);
        }
        paymentScheduleLine.setDirectDebitAmount(amount);
        paymentScheduleLine.setInTaxAmountPaid(amount);
        paymentScheduleLine.setAdvanceOrPaymentMove(move);
        paymentScheduleLine.setAdvanceMoveLine(creditMoveLine);
        paymentScheduleLine.setStatusSelect(3);
        this.paymentScheduleService.closePaymentScheduleIfAllPaid(paymentSchedule);
        return move;
    }
}

